/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.abstractannotations.layers;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.abstractannotations.layers.AnnotationLayer;
import org.bioimageanalysis.icy.icytomine.ui.general.JCheckableItem;
import org.bioimageanalysis.icy.icytomine.ui.general.JCheckedComboBox;

public class AnnotationLayerSelector
extends JPanel {
    private static final long serialVersionUID = -2542566819940944378L;
    private JLabel lblNewLabel;
    private JCheckedComboBox<AnnotationLayer> comboBox;
    private List<ModelChangeListener> modelChangeListeners;

    public AnnotationLayerSelector() {
        this.setupUI();
        this.setupListeners();
    }

    private void setupUI() {
        this.setGridBagLayout();
        this.addTitleLabel();
        this.addSelectionComboBox();
    }

    private void setGridBagLayout() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[3];
        gridBagLayout.rowHeights = new int[2];
        gridBagLayout.columnWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{1.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
    }

    private void addTitleLabel() {
        this.lblNewLabel = new JLabel("Active layers:");
        GridBagConstraints gbc_lblNewLabel = new GridBagConstraints();
        gbc_lblNewLabel.insets = new Insets(0, 0, 0, 5);
        gbc_lblNewLabel.anchor = 13;
        gbc_lblNewLabel.gridx = 0;
        gbc_lblNewLabel.gridy = 0;
        this.add((Component)this.lblNewLabel, gbc_lblNewLabel);
    }

    private void addSelectionComboBox() {
        this.comboBox = new JCheckedComboBox();
        this.comboBox.setModel(new DefaultComboBoxModel());
        GridBagConstraints gbc_comboBox = new GridBagConstraints();
        gbc_comboBox.fill = 2;
        gbc_comboBox.gridx = 1;
        gbc_comboBox.gridy = 0;
        this.add(this.comboBox, gbc_comboBox);
    }

    public void setLayers(AnnotationLayer[] layerList, Function<AnnotationLayer, String> labelFunction) {
        JCheckableItem[] checkableItems = (JCheckableItem[])Arrays.stream(layerList).map(it -> new JCheckableItem<AnnotationLayer>((AnnotationLayer)it, (String)labelFunction.apply((AnnotationLayer)it), false)).toArray(JCheckableItem[]::new);
        this.comboBox.setModel(new DefaultComboBoxModel<JCheckableItem>(checkableItems));
    }

    public Map<AnnotationLayer, Boolean> getAnnotationLayerStates() {
        HashMap<AnnotationLayer, Boolean> layerStates = new HashMap<AnnotationLayer, Boolean>();
        for (JCheckableItem<AnnotationLayer> item : this.comboBox.getCheckableItems()) {
            layerStates.put(item.getObject(), item.isSelected());
        }
        return layerStates;
    }

    private void setupListeners() {
        this.modelChangeListeners = new ArrayList<ModelChangeListener>();
        this.comboBox.addPropertyChangeListener("model", this::onModelChangeListener);
    }

    private void onModelChangeListener(PropertyChangeEvent event) {
        this.modelChangeListeners.forEach(l -> l.modelChanged(this.comboBox.getCheckableItems()));
    }

    public void addModelChangeListener(ModelChangeListener listener) {
        this.modelChangeListeners.add(listener);
    }

    public void removeModelChangeListener(ModelChangeListener listener) {
        this.modelChangeListeners.remove(listener);
    }

    public void addItemChangeListner(ItemListener listener) {
        this.comboBox.addItemListener(listener);
    }

    public void removeItemChangeListner(ItemListener listener) {
        this.comboBox.removeItemListener(listener);
    }

    public static interface ModelChangeListener {
        public void modelChanged(List<JCheckableItem<AnnotationLayer>> var1);
    }
}

