/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.cytomine2Icy;

import icy.common.listener.ProgressListener;
import icy.gui.dialog.MessageDialog;
import icy.main.Icy;
import icy.sequence.Sequence;
import icy.type.dimension.Dimension2D;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.DoubleStream;
import org.bioimageanalysis.icy.icytomine.core.image.annotation.AnnotationInserter;
import org.bioimageanalysis.icy.icytomine.core.image.annotation.AnnotationInserterException;
import org.bioimageanalysis.icy.icytomine.core.image.importer.TiledImageImporter;
import org.bioimageanalysis.icy.icytomine.core.model.AbstractAnnotation;
import org.bioimageanalysis.icy.icytomine.core.model.Image;
import org.bioimageanalysis.icy.icytomine.core.view.converters.MagnificationConverter;
import org.bioimageanalysis.icy.icytomine.core.view.converters.MagnitudeResolutionConverter;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.cytomine2Icy.CytomineToIcyPanel;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.controller.view.ViewController;

public class CytomineToIcyPanelController {
    private static double[] fixedObjectives = new double[]{1.25, 2.5, 5.0, 10.0, 20.0, 40.0};
    private CytomineToIcyPanel panel;
    private Image imageInformation;
    private Rectangle2D viewBoundsAtZeroResolution;
    private double viewResolution;
    private Set<AbstractAnnotation> activeAnnotations;
    private double viewMagnification;
    private ActionListener magnificationListener;
    private ActionListener startListener;
    private ActionListener endListener;
    private TiledImageImporter importer;
    private Set<ActionListener> closeListeners;
    private ProgressListener progressHandler;
    private TiledImageImporter.TiledImageImportationListener tiledImageImportationHandler;
    private Double outputResolution;
    private Dimension2D outputDimension;

    public CytomineToIcyPanelController(CytomineToIcyPanel panel, ViewController viewController) {
        this.panel = panel;
        this.imageInformation = viewController.getImageInformation();
        this.viewBoundsAtZeroResolution = viewController.getCurrentViewBoundsAtZeroResolution();
        this.viewBoundsAtZeroResolution = this.viewBoundsAtZeroResolution.createIntersection(new Rectangle(this.imageInformation.getSize().get()));
        this.viewResolution = viewController.getCurrentResolution();
        this.activeAnnotations = viewController.getActiveAnnotations();
        this.viewMagnification = this.getMagnificationOf(this.viewResolution);
        this.closeListeners = new HashSet<ActionListener>();
        this.setAvailableMagnifications();
        this.setListeners();
        this.setDefaultOutputMagnification();
    }

    private double getMagnificationOf(double resolution) {
        return MagnificationConverter.convertFromResolution(this.getBaseMagnification(), resolution);
    }

    private int getBaseMagnification() {
        Integer magnification = this.imageInformation.getMagnification().orElse(1);
        if (magnification == null) {
            magnification = 1;
        }
        return magnification;
    }

    private void setAvailableMagnifications() {
        this.panel.setAvailableMagnifications(DoubleStream.concat(DoubleStream.of(this.viewMagnification), DoubleStream.of(fixedObjectives)).toArray());
    }

    private void setListeners() {
        this.panel.addMagnificationListener(this.getMagnificationHandler());
        this.panel.addStartButtonActionListener(this.getStartHandler());
        this.panel.addCancelButtonActionListener(this.getCancelHandler());
    }

    private ActionListener getMagnificationHandler() {
        if (this.magnificationListener == null) {
            this.magnificationListener = e -> {
                Optional<Double> outputMagnification = this.panel.getSelectedMagnification();
                if (outputMagnification.isPresent()) {
                    this.outputResolution = MagnificationConverter.convertToResolution(this.getBaseMagnification(), outputMagnification.get());
                    this.outputDimension = MagnitudeResolutionConverter.convertDimension2D((Dimension2D)new Dimension2D.Double(this.viewBoundsAtZeroResolution.getWidth(), this.viewBoundsAtZeroResolution.getHeight()), 0.0, this.outputResolution);
                } else {
                    this.outputResolution = null;
                    this.outputDimension = new Dimension2D.Double();
                }
                this.panel.setOutputImageSize(this.outputDimension);
            };
        }
        return this.magnificationListener;
    }

    private ActionListener getStartHandler() {
        if (this.startListener == null) {
            this.startListener = e -> {
                if (this.outputResolution != null && this.outputDimension.getWidth() > 0.0 && this.outputDimension.getHeight() > 0.0) {
                    this.panel.setStartButtonEnabled(false);
                    this.panel.setMagnificationEnabled(false);
                    this.panel.setProgress(0.0);
                    this.importer = new TiledImageImporter(this.imageInformation);
                    this.importer.addImportationProgressListener(this.getProgressHandler());
                    this.importer.addTiledImageImportationListener(this.getTiledImageImportationHandler());
                    this.importer.requestImage(this.outputResolution, this.viewBoundsAtZeroResolution);
                } else {
                    MessageDialog.showDialog((String)"Invalid magnification", (int)0);
                }
            };
        }
        return this.startListener;
    }

    private ProgressListener getProgressHandler() {
        if (this.progressHandler == null) {
            this.progressHandler = (position, length) -> {
                this.panel.setProgress(position / length);
                return true;
            };
        }
        return this.progressHandler;
    }

    private TiledImageImporter.TiledImageImportationListener getTiledImageImportationHandler() {
        if (this.tiledImageImportationHandler == null) {
            this.tiledImageImportationHandler = result -> this.imageImported(result);
        }
        return this.tiledImageImportationHandler;
    }

    private void imageImported(Future<BufferedImage> result) {
        block10: {
            try {
                Sequence image = new Sequence(result.get());
                Dimension2D pixelSizeAtZeroResolution = this.getPixelSizeAtZeroResolution();
                Dimension2D pixelSizeAtTargetResolution = this.getPixelSizeAtViewResolution();
                image.setName(this.imageInformation.getName().orElse("CytomineImage"));
                image.setPixelSizeX(pixelSizeAtTargetResolution.getWidth());
                image.setPixelSizeY(pixelSizeAtTargetResolution.getHeight());
                image.setPositionX(this.viewBoundsAtZeroResolution.getX() * pixelSizeAtZeroResolution.getWidth());
                image.setPositionY(this.viewBoundsAtZeroResolution.getY() * pixelSizeAtZeroResolution.getHeight());
                this.panel.setProgress("Adding annotations", 0.75);
                AnnotationInserter annotationsInserter = new AnnotationInserter(image);
                annotationsInserter.insertAnnotations(this.viewBoundsAtZeroResolution, this.outputResolution, this.activeAnnotations, false);
                this.panel.setProgress(0.99);
                Icy.getMainInterface().addSequence(image);
            }
            catch (CancellationException image) {
                if (this.importer != null) {
                    this.importer.removeImportationProgressListener(this.getProgressHandler());
                    this.importer.removeTiledImageImportationListener(this.getTiledImageImportationHandler());
                }
                this.importer = null;
                break block10;
            }
            catch (InterruptedException | ExecutionException | AnnotationInserterException e) {
                try {
                    MessageDialog.showDialog((String)"Transfer error", (String)e.getMessage(), (int)0);
                    e.printStackTrace();
                    break block10;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (this.importer != null) {
                        this.importer.removeImportationProgressListener(this.getProgressHandler());
                        this.importer.removeTiledImageImportationListener(this.getTiledImageImportationHandler());
                    }
                    this.importer = null;
                }
            }
            if (this.importer != null) {
                this.importer.removeImportationProgressListener(this.getProgressHandler());
                this.importer.removeTiledImageImportationListener(this.getTiledImageImportationHandler());
            }
            this.importer = null;
        }
        this.panel.setProgressIdle();
        this.panel.setStartButtonEnabled(true);
        this.panel.setMagnificationEnabled(true);
        this.requestDialogClose();
    }

    private Dimension2D getPixelSizeAtZeroResolution() {
        double pixelLength = this.imageInformation.getResolution().orElse(1.0);
        return new Dimension2D.Double(pixelLength, pixelLength);
    }

    private Dimension2D getPixelSizeAtViewResolution() {
        Dimension2D pixelSize = this.getPixelSizeAtZeroResolution();
        return MagnitudeResolutionConverter.convertDimension2D(pixelSize, this.outputResolution, 0.0);
    }

    private ActionListener getCancelHandler() {
        if (this.endListener == null) {
            this.endListener = e -> {
                this.cancelTransfer();
                this.requestDialogClose();
            };
        }
        return this.endListener;
    }

    private void requestDialogClose() {
        this.closeListeners.forEach(l -> l.actionPerformed(null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelTransfer() {
        Object object;
        TiledImageImporter imp = this.importer;
        if (imp != null) {
            object = imp;
            synchronized (object) {
                if (imp != null) {
                    try {
                        imp.cancel();
                        imp.removeImportationProgressListener(this.getProgressHandler());
                        imp.removeTiledImageImportationListener(this.getTiledImageImportationHandler());
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (RuntimeException e) {
                        MessageDialog.showDialog((String)"Transfer error", (String)e.getMessage(), (int)0);
                    }
                }
            }
        }
        this.importer = null;
        object = this.panel;
        synchronized (object) {
            if (this.panel != null) {
                this.panel.setStartButtonEnabled(true);
                this.panel.setMagnificationEnabled(true);
            }
        }
    }

    private void setDefaultOutputMagnification() {
        this.panel.setDefaultMagnification();
    }

    public void addCloseListener(ActionListener listener) {
        this.closeListeners.add(listener);
    }

    public void close() {
        this.cancelTransfer();
    }
}

