/*
 * Decompiled with CFR 0.152.
 */
package plugins.danyfel80.cytomine.batch;

import com.vividsolutions.jts.awt.PointTransformation;
import com.vividsolutions.jts.awt.ShapeWriter;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.bioimageanalysis.icy.icytomine.core.model.AbstractAnnotation;
import org.bioimageanalysis.icy.icytomine.core.view.converters.MagnitudeResolutionConverter;
import plugins.adufour.blocks.lang.Loop;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarInteger;
import vars.cytomine.VarCytomineAbstractAnnotation;
import vars.geom.VarDimension;
import vars.geom.VarPoint;

public class CytomineAnnotationTiler
extends Loop {
    private VarList inputMap;
    private VarCytomineAbstractAnnotation annotationVar;
    private VarDimension tileSizeVar;
    private VarInteger resolutionLevelVar;
    private VarPoint currentTilePositionVar;
    private AbstractAnnotation annotation;
    private Dimension tileSize;
    private Integer resolutionLevel;
    private Dimension tileGridSize;
    private int numGridTiles;
    private Dimension2D tileSizeAtZeroResolution;
    private Rectangle2D annotationBounds;
    private int currentTileIndex;
    Shape annotationShape;
    private Rectangle2D currentTileAtZeroResolution;

    public void declareInput(VarList inputMap) {
        super.declareInput(inputMap);
        this.setInputMap(inputMap);
        this.initializeInputVariables();
        this.addInputVariables();
    }

    private void setInputMap(VarList inputMap) {
        this.inputMap = inputMap;
    }

    private void initializeInputVariables() {
        this.annotationVar = VarCytomineAbstractAnnotation.ofNullable(null);
        this.tileSizeVar = new VarDimension("Tile size");
        this.resolutionLevelVar = new VarInteger("Resolution level", 0);
    }

    private void addInputVariables() {
        this.inputMap.add(this.annotationVar.getName(), (Var)this.annotationVar);
        this.inputMap.add(this.tileSizeVar.getName(), (Var)this.tileSizeVar);
        this.inputMap.add(this.resolutionLevelVar.getName(), (Var)this.resolutionLevelVar);
    }

    public void declareOutput(VarList outputMap) {
        super.declareOutput(outputMap);
        for (Var var : this.inputMap) {
            outputMap.add(var.getName(), var);
        }
        this.currentTilePositionVar = new VarPoint("Current tile position");
        this.currentTilePositionVar.setEnabled(false);
        outputMap.add(this.currentTilePositionVar.getName(), (Var)this.currentTilePositionVar);
    }

    public void declareLoopVariables(List<Var<?>> loopVariables) {
        for (Var var : this.inputMap) {
            loopVariables.add(var);
        }
        loopVariables.add((Var<?>)this.currentTilePositionVar);
    }

    public void initializeLoop() {
        this.retrieveParameters();
        this.computePositionsToLoad();
        this.initializeIterators();
    }

    private void retrieveParameters() {
        this.annotation = (AbstractAnnotation)this.annotationVar.getValue(true);
        this.tileSize = (Dimension)this.tileSizeVar.getValue(true);
        this.resolutionLevel = this.resolutionLevelVar.getValue(true);
    }

    private void computePositionsToLoad() {
        this.annotationBounds = this.annotation.getYAdjustedBounds();
        this.tileSizeAtZeroResolution = MagnitudeResolutionConverter.convertDimension2D(this.tileSize, this.resolutionLevel.intValue(), 0.0);
        int tileGridWidth = (int)Math.ceil(this.annotationBounds.getWidth() / this.tileSizeAtZeroResolution.getWidth());
        int tileGridHeight = (int)Math.ceil(this.annotationBounds.getHeight() / this.tileSizeAtZeroResolution.getHeight());
        this.tileGridSize = new Dimension(tileGridWidth, tileGridHeight);
        this.numGridTiles = tileGridHeight * tileGridWidth;
    }

    private void initializeIterators() {
        this.currentTileIndex = -1;
        this.buildAnnotationShape();
        do {
            ++this.currentTileIndex;
        } while (this.currentTileIndex < this.numGridTiles && !this.isCurrentTileInAnnotation());
    }

    private void buildAnnotationShape() {
        Geometry annotationGeometry = this.annotation.getGeometryAtZeroResolution(false);
        final int maxY = this.annotation.getImage().getSizeY().get();
        ShapeWriter shapeWriter = new ShapeWriter(new PointTransformation(){

            public void transform(Coordinate src, Point2D dest) {
                dest.setLocation(src.x, (double)maxY - src.y);
            }
        });
        this.annotationShape = shapeWriter.toShape(annotationGeometry);
    }

    private boolean isCurrentTileInAnnotation() {
        this.computeCurrentInternalTileAtZeroResolution();
        return this.annotationShape.intersects(this.currentTileAtZeroResolution);
    }

    private void computeCurrentInternalTileAtZeroResolution() {
        int currentTileIndexY = this.currentTileIndex / this.tileGridSize.width;
        int currentTileIndexX = this.currentTileIndex % this.tileGridSize.width;
        Point2D.Double currentTilePositionAtZeroResolution = new Point2D.Double(this.annotationBounds.getMinX() + (double)currentTileIndexX * this.tileSizeAtZeroResolution.getWidth(), this.annotationBounds.getMinY() + (double)currentTileIndexY * this.tileSizeAtZeroResolution.getHeight());
        this.currentTileAtZeroResolution = new Rectangle2D.Double(currentTilePositionAtZeroResolution.x, currentTilePositionAtZeroResolution.y, this.tileSizeAtZeroResolution.getWidth(), this.tileSizeAtZeroResolution.getHeight());
    }

    public void beforeIteration() {
        this.computeCurrentTilePosition();
    }

    private void computeCurrentTilePosition() {
        int currentTileIndexY = this.currentTileIndex / this.tileGridSize.width;
        int currentTileIndexX = this.currentTileIndex % this.tileGridSize.width;
        Point currentTilePositionAtZeroResolution = new Point((int)(this.annotationBounds.getMinX() + (double)currentTileIndexX * this.tileSizeAtZeroResolution.getWidth()), (int)(this.annotationBounds.getMinY() + (double)currentTileIndexY * this.tileSizeAtZeroResolution.getHeight()));
        this.currentTilePositionVar.setValue((Object)currentTilePositionAtZeroResolution);
    }

    public void afterIteration() {
        do {
            ++this.currentTileIndex;
        } while (this.currentTileIndex < this.numGridTiles && !this.isCurrentTileInAnnotation());
        super.afterIteration();
    }

    public boolean isStopConditionReached() {
        return this.currentTileIndex >= this.numGridTiles;
    }
}

