/*
 * Decompiled with CFR 0.152.
 */
package be.cytomine.client;

import be.cytomine.client.CytomineConnection;
import be.cytomine.client.CytomineException;
import be.cytomine.client.HttpClient;
import be.cytomine.client.collections.AmqpQueueCollection;
import be.cytomine.client.collections.AnnotationCollection;
import be.cytomine.client.collections.Collection;
import be.cytomine.client.collections.DeleteCommandCollection;
import be.cytomine.client.collections.ImageInstanceCollection;
import be.cytomine.client.collections.JobDataCollection;
import be.cytomine.client.collections.OntologyCollection;
import be.cytomine.client.collections.ProjectCollection;
import be.cytomine.client.collections.PropertyCollection;
import be.cytomine.client.collections.ReviewedAnnotationCollection;
import be.cytomine.client.collections.RoleCollection;
import be.cytomine.client.collections.SearchCollection;
import be.cytomine.client.collections.SoftwareCollection;
import be.cytomine.client.collections.StorageCollection;
import be.cytomine.client.collections.TermCollection;
import be.cytomine.client.collections.UploadedFileCollection;
import be.cytomine.client.collections.UserCollection;
import be.cytomine.client.models.AbstractImage;
import be.cytomine.client.models.Annotation;
import be.cytomine.client.models.AnnotationTerm;
import be.cytomine.client.models.AnnotationUnion;
import be.cytomine.client.models.AttachedFile;
import be.cytomine.client.models.Description;
import be.cytomine.client.models.ImageFilter;
import be.cytomine.client.models.ImageGroup;
import be.cytomine.client.models.ImageInstance;
import be.cytomine.client.models.ImageSequence;
import be.cytomine.client.models.ImageServer;
import be.cytomine.client.models.Job;
import be.cytomine.client.models.JobData;
import be.cytomine.client.models.JobParameter;
import be.cytomine.client.models.JobTemplate;
import be.cytomine.client.models.Model;
import be.cytomine.client.models.Ontology;
import be.cytomine.client.models.Project;
import be.cytomine.client.models.Property;
import be.cytomine.client.models.Role;
import be.cytomine.client.models.Software;
import be.cytomine.client.models.SoftwareParameter;
import be.cytomine.client.models.SoftwareProject;
import be.cytomine.client.models.Storage;
import be.cytomine.client.models.StorageAbstractImage;
import be.cytomine.client.models.Term;
import be.cytomine.client.models.UploadedFile;
import be.cytomine.client.models.User;
import be.cytomine.client.models.UserJob;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class Cytomine {
    private static final Logger log = LogManager.getLogger(Cytomine.class);
    static Cytomine CYTOMINE;
    CytomineConnection defaultCytomineConnection;
    private String host;
    private String login;
    private String pass;
    private String publicKey;
    private String privateKey;
    private String charEncoding = "UTF-8";
    private int max = 0;
    private int offset = 0;

    public static synchronized CytomineConnection connection(String host, String publicKey, String privateKey) {
        return Cytomine.connection(host, publicKey, privateKey, true);
    }

    public static synchronized CytomineConnection connection(String host, String publicKey, String privateKey, boolean setAsDefault) {
        if (CYTOMINE == null) {
            CYTOMINE = new Cytomine(host, publicKey, privateKey);
        } else {
            Cytomine.CYTOMINE.host = host;
            Cytomine.CYTOMINE.publicKey = publicKey;
            Cytomine.CYTOMINE.privateKey = privateKey;
        }
        CytomineConnection connection = new CytomineConnection(host, publicKey, privateKey);
        if (setAsDefault) {
            Cytomine.CYTOMINE.defaultCytomineConnection = connection;
        }
        return connection;
    }

    public CytomineConnection getDefaultCytomineConnection() {
        return this.defaultCytomineConnection;
    }

    public static Cytomine getInstance() throws CytomineException {
        if (CYTOMINE == null) {
            throw new CytomineException(400, "Connection parameters not set");
        }
        return CYTOMINE;
    }

    private Cytomine(String host, String publicKey, String privateKey) {
        this.host = host;
        this.publicKey = publicKey;
        this.privateKey = privateKey;
        this.login = publicKey;
        this.pass = privateKey;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getCharEncoding() {
        return this.charEncoding;
    }

    public void setCharEncoding(String charEncoding) {
        this.charEncoding = charEncoding;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    boolean testHostConnection() throws Exception {
        HttpClient client = new HttpClient();
        client.connect(this.getHost() + "/server/ping", this.login, this.pass);
        int code = 0;
        try {
            code = client.get();
        }
        catch (Exception e) {
            log.error(e.toString());
        }
        client.disconnect();
        return code == 200 || code == 201 || code == 304;
    }

    public boolean nextPage(Collection collection) throws CytomineException {
        collection.fetchNextPage();
        return !collection.isEmpty();
    }

    private String buildEncode(String keywords) throws CytomineException {
        try {
            return URLEncoder.encode(keywords, this.getCharEncoding());
        }
        catch (UnsupportedEncodingException e) {
            throw new CytomineException(e);
        }
    }

    private void analyzeCode(int code, JSONObject json) throws CytomineException {
        if (code >= 400 && code < 600) {
            throw new CytomineException(code, json);
        }
        if (code == 302) {
            throw new CytomineException(code, json);
        }
    }

    private JSONObject createJSONResponse(int code, String response) throws CytomineException {
        try {
            Object obj = JSONValue.parse(response);
            return (JSONObject)obj;
        }
        catch (Exception e) {
            log.error(e);
            throw new CytomineException(code, response);
        }
        catch (Error e) {
            log.error(e);
            throw new CytomineException(code, response);
        }
    }

    private JSONArray createJSONArrayResponse(int code, String response) throws CytomineException {
        Object obj = JSONValue.parse(response);
        return (JSONArray)obj;
    }

    public String clearAbstractImageProperties(Long idImage) throws CytomineException {
        AbstractImage abs = new AbstractImage();
        abs.set("id", idImage);
        return abs.clearProperties();
    }

    public String populateAbstractImageProperties(Long idImage) throws CytomineException {
        AbstractImage abs = new AbstractImage();
        abs.set("id", idImage);
        return abs.populateProperties();
    }

    public String extractUsefulAbstractImageProperties(Long idImage) throws CytomineException {
        AbstractImage abs = new AbstractImage();
        abs.set("id", idImage);
        return abs.extractUsefulProperties();
    }

    public void downloadAbstractImage(long ID, int maxSize, String dest) throws CytomineException {
        String url = this.getHost() + "/api/abstractimage/" + ID + "/thumb.png?maxSize=" + maxSize;
        this.getDefaultCytomineConnection().downloadPicture(url, dest, "png");
    }

    public void downloadImageInstance(long ID, String dest) throws CytomineException {
        this.getDefaultCytomineConnection().downloadFile("/api/imageinstance/" + ID + "/download", dest);
    }

    public BufferedImage getAbstractImageThumb(long ID, int maxSize) throws CytomineException {
        String url = this.getHost() + "/api/abstractimage/" + ID + "/thumb.png?maxSize=" + maxSize;
        return this.getDefaultCytomineConnection().getPictureAsBufferedImage(url, "png");
    }

    public AttachedFile uploadAttachedFile(String file, String domainClassName, Long domainIdent) throws CytomineException {
        String url = "/api/attachedfile.json?domainClassName=" + domainClassName + "&domainIdent=" + domainIdent;
        JSONObject json = this.getDefaultCytomineConnection().uploadFile(url, file);
        AttachedFile attachedFile = new AttachedFile();
        attachedFile.setAttr(json);
        return attachedFile;
    }

    public void uploadJobData(Long idJobData, byte[] data) throws CytomineException {
        JobData jobData = new JobData();
        jobData.set("id", idJobData);
        jobData.uploadJobData(data);
    }

    public void downloadJobData(Long idJobData, String file) throws CytomineException {
        JobData jobData = new JobData();
        jobData.set("id", idJobData);
        jobData.downloadJobData(file);
    }

    public void downloadAnnotation(Annotation annotation, String path) throws CytomineException {
        String url = annotation.getStr("url");
        this.getDefaultCytomineConnection().downloadPicture(url, path);
    }

    public void uploadImage(String uploadURL, String file, String cytomineHost) throws CytomineException {
        this.uploadImage(uploadURL, file, null, null, cytomineHost);
    }

    public JSONArray uploadImage(String uploadURL, String file, Long idProject, Long idStorage, String cytomineHost) throws CytomineException {
        return this.uploadImage(uploadURL, file, idProject, idStorage, cytomineHost, null, false);
    }

    public JSONArray uploadImage(String uploadURL, String file, Long idProject, Long idStorage, String cytomineHost, Map<String, String> properties, boolean synchrone) throws CytomineException {
        CytomineConnection uploadConnection = Cytomine.connection(uploadURL, Cytomine.getInstance().getDefaultCytomineConnection().getPublicKey(), Cytomine.getInstance().getDefaultCytomineConnection().getPrivateKey(), false);
        HashMap<String, String> entityParts = new HashMap<String, String>();
        if (idProject != null) {
            entityParts.put("idProject", idProject + "");
        }
        if (idStorage != null) {
            entityParts.put("idStorage", idStorage + "");
        }
        String projectParam = "";
        if (idProject != null && idProject != 0L) {
            projectParam = "&idProject=" + idProject;
        }
        String url = "/upload?idStorage=" + idStorage + "&cytomine=" + cytomineHost + projectParam;
        if (properties != null && properties.size() > 0) {
            ArrayList<String> keys = new ArrayList<String>();
            ArrayList<String> values = new ArrayList<String>();
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                keys.add(entry.getKey());
                values.add(entry.getValue());
            }
            url = url + "&keys=" + StringUtils.join(keys, (String)",") + "&values=" + StringUtils.join(values, (String)",");
        }
        if (synchrone) {
            url = url + "&sync=" + true;
        }
        return uploadConnection.uploadImage(file, url, entityParts);
    }

    public void simplifyAnnotation(Long idAnnotation, Long minPoint, Long maxPoint) throws CytomineException {
        String url = "/api/annotation/" + idAnnotation + "/simplify.json?minPoint=" + minPoint + "&maxPoint=" + maxPoint;
        this.defaultCytomineConnection.doPut(url, "");
    }

    public AnnotationTerm setAnnotationTerm(Long idAnnotation, Long idTerm) throws CytomineException {
        try {
            AnnotationTerm annotationTerm = new AnnotationTerm();
            annotationTerm.set("userannotation", idAnnotation);
            annotationTerm.set("annotationIdent", idAnnotation);
            annotationTerm.set("term", idTerm);
            AnnotationTerm model = annotationTerm;
            String clearBeforeURL = "/api/annotation/" + idAnnotation + "/term/" + idTerm + "/clearBefore.json";
            HttpClient client = null;
            client = new HttpClient(this.publicKey, this.privateKey, this.getHost());
            client.authorize("POST", clearBeforeURL, "", "application/json,*/*");
            client.connect(this.getHost() + clearBeforeURL);
            int code = client.post(model.toJSON());
            String response = client.getResponseData();
            client.disconnect();
            JSONObject json = this.createJSONResponse(code, response);
            this.analyzeCode(code, json);
            model.setAttr((JSONObject)json.get(((Model)model).getDomainName()));
            return model;
        }
        catch (IOException e) {
            throw new CytomineException(e);
        }
    }

    public AnnotationCollection getAnnotationsByTermAndProject(Long idTerm, Long idProject) throws CytomineException {
        AnnotationCollection annotations = new AnnotationCollection(this.offset, this.max);
        annotations.addFilter("term", idTerm + "");
        annotations.addFilter("project", idProject + "");
        return (AnnotationCollection)annotations.fetch();
    }

    public AnnotationCollection getAnnotations(Map<String, String> filters) throws CytomineException {
        AnnotationCollection annotations = new AnnotationCollection(this.offset, this.max);
        for (Map.Entry<String, String> entry : filters.entrySet()) {
            annotations.addFilter(entry.getKey(), entry.getValue());
        }
        return (AnnotationCollection)annotations.fetch();
    }

    public AnnotationCollection getAnnotationsByTermAndImage(Long idTerm, Long idImage) throws CytomineException {
        AnnotationCollection annotations = new AnnotationCollection(this.offset, this.max);
        annotations.addFilter("term", idTerm + "");
        annotations.addFilter("imageinstance", idImage + "");
        return (AnnotationCollection)annotations.fetch();
    }

    public AnnotationTerm getAnnotationTerm(Long idAnnotation, Long idTerm) throws CytomineException {
        AnnotationTerm annotationTerm = new AnnotationTerm(idAnnotation, idTerm);
        return annotationTerm.fetch(idAnnotation.toString(), idTerm.toString());
    }

    public void deleteAnnotationTerm(Long idAnnotation, Long idTerm) throws CytomineException {
        AnnotationTerm annotationTerm = new AnnotationTerm();
        annotationTerm.set("annotation", idAnnotation);
        annotationTerm.set("userannotation", idAnnotation);
        annotationTerm.set("term", idTerm);
        annotationTerm.delete();
    }

    public void addUserFromLDAP(String username) throws CytomineException {
        this.defaultCytomineConnection.doPost("/api/ldap/user.json?username=" + username, "");
    }

    public User getCurrentUser() throws CytomineException {
        return this.defaultCytomineConnection.getCurrentUser();
    }

    public void addACL(String domainClassName, Long domainIdent, Long idUser, String auth) throws CytomineException {
        this.defaultCytomineConnection.doPost("/api/domain/" + domainClassName + "/" + domainIdent + "/user/" + idUser + ".json?auth=" + auth, "");
    }

    public void addUserProject(Long idUser, Long idProject) throws CytomineException {
        this.addUserProject(idUser, idProject, false);
    }

    public void addUserProject(Long idUser, Long idProject, boolean admin) throws CytomineException {
        this.defaultCytomineConnection.doPost("/api/project/" + idProject + "/user/" + idUser + (admin ? "/admin" : "") + ".json", "");
    }

    public void deleteUserProject(Long idUser, Long idProject) throws CytomineException {
        this.deleteUserProject(idUser, idProject, false);
    }

    public void deleteUserProject(Long idUser, Long idProject, boolean admin) throws CytomineException {
        this.defaultCytomineConnection.doDelete("/api/project/" + idProject + "/user/" + idUser + (admin ? "/admin" : "") + ".json");
    }

    public UserCollection getProjectUsers(Long idProject) throws CytomineException {
        UserCollection users = new UserCollection(this.offset, this.max);
        users.addFilter("project", idProject + "");
        return (UserCollection)users.fetch();
    }

    public UserCollection getProjectAdmins(Long idProject) throws CytomineException {
        UserCollection users = new UserCollection(this.offset, this.max);
        users.addFilter("project", idProject + "");
        users.addFilter("admin", "true");
        return (UserCollection)users.fetch();
    }

    public void doUserPosition(Long idImage, Long x, Long y, Long zoom) throws CytomineException {
        String data = "{image : " + idImage + ", lat : " + x + ", lon : " + y + ", zoom : " + zoom + "}";
        this.defaultCytomineConnection.doPost("/api/imageinstance/" + idImage + "/position.json", data);
    }

    public void doUserPosition(Long idImage, Long zoom, Long bottomLeftX, Long bottomLeftY, Long bottomRightX, Long bottomRightY, Long topLeftX, Long topLeftY, Long topRightX, Long topRightY) throws CytomineException {
        String data = "{image : " + idImage + ", zoom : " + zoom + ", bottomLeftX : " + bottomLeftX + ", bottomLeftY : " + bottomLeftY + ", bottomRightX : " + bottomRightX + ", bottomRightY : " + bottomRightY + ", topLeftX : " + topLeftX + ", topLeftY : " + topLeftY + ", topRightX : " + topRightX + ", topRightY : " + topRightY + "}";
        this.defaultCytomineConnection.doPost("/api/imageinstance/" + idImage + "/position.json", data);
    }

    public User getUser(String publicKey) throws CytomineException {
        User user = new User();
        user.addParams("publicKey", publicKey);
        return (User)user.fetch(null);
    }

    public String getImageServersOfAbstractImage(Long abstractImageID) {
        String subUrl = "/api/abstractimage/" + abstractImageID + "/imageservers.json";
        HttpClient client = null;
        client = new HttpClient(this.publicKey, this.privateKey, this.getHost());
        try {
            client.authorize("GET", subUrl, "", "application/json,*/*");
            client.connect(this.getHost() + subUrl);
            int code = client.get();
            String response = client.getResponseData();
            client.disconnect();
            JSONObject json = this.createJSONResponse(code, response);
            this.analyzeCode(code, json);
            JSONArray servers = (JSONArray)json.get("imageServersURLs");
            return (String)servers.get(0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CytomineException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Collection<ImageServer> getAbstractImageServers(AbstractImage abstractImage) throws CytomineException {
        Collection<ImageServer> imageServers = new Collection<ImageServer>(ImageServer.class, 0, 0);
        imageServers.addFilter("abstractimage", "" + abstractImage.getId());
        return imageServers.fetch();
    }

    public Collection<ImageServer> getImageInstanceServers(ImageInstance image) throws CytomineException {
        AbstractImage abstractImage = new AbstractImage();
        abstractImage.set("id", image.get("baseImage"));
        return this.getAbstractImageServers(abstractImage);
    }

    public User getKeys(String publicKey) throws CytomineException {
        User user = new User();
        user.addFilter("publicKeyFilter", publicKey);
        return (User)user.fetch(null);
    }

    public User getKeys(Long id) throws CytomineException {
        User user = new User();
        user.addFilter("id", id + "");
        user.addFilter("keys", "keys");
        return (User)user.fetch(id);
    }

    public Job changeStatus(Long id, Job.JobStatus status, int progress) throws CytomineException {
        return this.changeStatus(id, status.getValue(), progress);
    }

    public Job changeStatus(Long id, Job.JobStatus status, int progress, String comment) throws CytomineException {
        return this.changeStatus(id, status.getValue(), progress, comment);
    }

    public Job changeStatus(Long id, int status, int progress) throws CytomineException {
        return this.changeStatus(id, status, progress, null);
    }

    public Job changeStatus(Long id, int status, int progress, String comment) throws CytomineException {
        Job job = (Job)new Job().fetch(id);
        return job.changeStatus(status, progress, comment);
    }

    public User addUserJob(Long idSoftware, Long idProject, Long idUserParent) throws CytomineException {
        return this.addUserJob(idSoftware, idUserParent, idProject, new Date(), null);
    }

    public User addUserJob(Long idSoftware, Long idUserParent, Long idProject, Date created, Long idJob) throws CytomineException {
        UserJob user = new UserJob();
        user.set("parent", idUserParent);
        user.set("software", idSoftware);
        user.set("project", idProject);
        user.set("job", idJob);
        user.set("created", created.getTime());
        user = (UserJob)user.save();
        User userFinal = new User();
        userFinal.setAttr(user.getAttr());
        return userFinal;
    }

    public void unionAnnotation(Long idImage, Long idUser, Integer minIntersectionLength) throws CytomineException {
        AnnotationUnion annotation = new AnnotationUnion();
        annotation.addParams("idImage", idImage + "");
        annotation.addParams("idUser", idUser + "");
        annotation.addParams("minIntersectionLength", minIntersectionLength + "");
        annotation.update();
    }

    public ReviewedAnnotationCollection getReviewedAnnotationsByTermAndImage(Long idTerm, Long idImage) throws CytomineException {
        ReviewedAnnotationCollection reviewed = new ReviewedAnnotationCollection(this.offset, this.max);
        reviewed.addFilter("term", idTerm + "");
        reviewed.addFilter("imageinstance", idImage + "");
        return (ReviewedAnnotationCollection)reviewed.fetch();
    }

    public Property getDomainProperty(Long id, Long domainIdent, String domain) throws CytomineException {
        Property property = new Property(domain, domainIdent);
        return property.fetch(id);
    }

    public PropertyCollection getDomainProperties(String domain, Long domainIdent) throws CytomineException {
        PropertyCollection properties = new PropertyCollection(this.offset, this.max);
        properties.addFilter(domain, domainIdent + "");
        properties.addFilter("domainClassName", domain + "");
        properties.addFilter("domainIdent", domainIdent + "");
        return (PropertyCollection)properties.fetch();
    }

    public Property getPropertyByDomainAndKey(String domain, Long domainIdent, String key) throws CytomineException {
        Property property = new Property(domain, domainIdent);
        property.set("key", key);
        return property.fetch(key);
    }

    public Property addDomainProperties(String domain, Long domainIdent, String key, String value) throws CytomineException {
        Property property = new Property(domain, domainIdent);
        property.set("key", key);
        property.set("value", value);
        return (Property)property.save();
    }

    public Property editDomainProperty(String domain, Long id, Long domainIdent, String key, String value) throws CytomineException {
        Property property = this.getDomainProperty(id, domainIdent, domain);
        property.set("domain", domain);
        property.set("domainIdent", domainIdent);
        property.set("key", key);
        property.set("value", value);
        return (Property)property.update();
    }

    public void deleteDomainProperty(String domain, Long id, Long domainIdent) throws CytomineException {
        Property property = this.getDomainProperty(id, domainIdent, domain);
        property.set("id", id);
        property.set("domain", domain);
        property.set("domainIdent", domainIdent);
        property.delete();
    }

    public PropertyCollection getKeysForDomain(String domain, String nameIdDomain, Long idDomain) throws CytomineException {
        PropertyCollection properties = new PropertyCollection(this.offset, this.max);
        properties.addFilter(domain, "");
        properties.addFilter("idDomain", idDomain + "");
        properties.addFilter("nameIdDomain", nameIdDomain);
        return (PropertyCollection)properties.fetch();
    }

    public SearchCollection getSearch(String keywords, Operator operator, Filter filter) throws CytomineException {
        return this.getSearch(keywords, operator, filter, null);
    }

    public SearchCollection getSearch(String keywords, Operator operator, Filter filter, List<Long> idProjects) throws CytomineException {
        SearchCollection search = new SearchCollection(this.offset, this.max);
        if (operator == null) {
            operator = Operator.OR;
        }
        if (filter == null) {
            filter = Filter.ALL;
        }
        search.addFilter("keywords", this.buildEncode(keywords));
        search.addFilter("operator", this.buildEncode((Object)((Object)operator) + ""));
        search.addFilter("filter", this.buildEncode((Object)((Object)filter) + ""));
        if (idProjects != null) {
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < idProjects.size(); ++i) {
                list.add(idProjects.get(i) + "");
            }
            search.addFilter("projects", Cytomine.join(list, ", "));
        }
        return (SearchCollection)search.fetch();
    }

    public static String join(ArrayList s, String delimiter) {
        if (s.size() == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        Iterator iterator = s.iterator();
        while (iterator.hasNext()) {
            buffer.append(iterator.next());
            if (!iterator.hasNext()) continue;
            buffer.append(delimiter);
        }
        return buffer.toString();
    }

    public String resetPassword(Long idUser, String newPassword) throws CytomineException {
        return this.getDefaultCytomineConnection().doPut("/api/user/" + idUser + "/password.json", "{password: " + newPassword + "}").toString();
    }

    public Description getDescription(Long domainIdent, String domainClassName) throws CytomineException {
        Description description = new Description();
        return description.fetch(domainClassName, domainIdent.toString());
    }

    public Description addDescription(Long domainIdent, String domainClassName, String text) throws CytomineException {
        Description description = new Description();
        description.set("domainIdent", domainIdent);
        description.set("domainClassName", domainClassName);
        description.set("data", text);
        return (Description)description.save();
    }

    public Description editDescription(Long domainIdent, String domainClassName, String text) throws CytomineException {
        Description description = this.getDescription(domainIdent, domainClassName);
        description.set("domainIdent", domainIdent);
        description.set("domainClassName", domainClassName);
        description.set("data", text);
        return (Description)description.update();
    }

    public void deleteDescription(Long domainIdent, String domainClassName) throws CytomineException {
        Description description = this.getDescription(domainIdent, domainClassName);
        description.set("domainIdent", domainIdent);
        description.set("domainClassName", domainClassName);
        description.delete();
    }

    public Map<String, Long> getRoleMap() throws CytomineException {
        TreeMap<String, Long> map = new TreeMap<String, Long>();
        Collection<Role> roles = Collection.fetch(Role.class);
        for (int i = 0; i < roles.size(); ++i) {
            map.put(roles.get(i).getStr("authority"), roles.get(i).getLong("id"));
        }
        return map;
    }

    public Role addRole(Long idUser, Long idRole) throws CytomineException {
        Role role = new Role();
        role.set("user", idUser + "");
        role.set("role", idRole + "");
        role.addFilter("user", idUser + "");
        return (Role)role.save();
    }

    public void deleteRole(Long idUser, Long idRole) throws CytomineException {
        Role role = new Role();
        role.set("user", idUser + "");
        role.set("role", idRole + "");
        role.addFilter("user", idUser + "");
        role.addFilter("role", idRole + "");
        role.delete();
    }

    public AbstractImage addNewImage(Long idUploadedFile, String path, String filename, String mimeType) throws CytomineException {
        return this.addNewImage(idUploadedFile, path, filename, null, mimeType);
    }

    public AbstractImage addNewImage(Long idUploadedFile, String path, String filename, String originalFilename, String mimeType) throws CytomineException {
        AbstractImage image = new AbstractImage();
        image.set("path", path);
        image.set("filename", filename);
        if (originalFilename != null) {
            image.set("originalFilename", originalFilename);
        }
        image.set("mimeType", mimeType);
        image.addFilter("uploadedFile", idUploadedFile + "");
        return (AbstractImage)image.save();
    }

    public UploadedFileCollection getUploadedFiles(boolean deleted) throws CytomineException {
        UploadedFileCollection files = new UploadedFileCollection(this.offset, this.max);
        files.addParams("deleted", "true");
        return (UploadedFileCollection)files.fetch();
    }

    public String getSimplified(String wkt, Long min, Long max) throws CytomineException {
        Annotation annotation = new Annotation();
        annotation.set("wkt", wkt);
        return this.getDefaultCytomineConnection().doPost("/api/simplify.json?minPoint=" + min + "&maxPoint=" + max, annotation.toJSON()).toString();
    }

    @Deprecated
    public Project editProject(Long idProject, String name, Long idOntology) throws CytomineException {
        Project project = (Project)new Project().fetch(idProject);
        project.set("name", name);
        project.set("ontology", idOntology);
        return (Project)project.update();
    }

    @Deprecated
    public Ontology editOntology(Long idOntology, String name) throws CytomineException {
        Ontology ontology = (Ontology)new Ontology().fetch(idOntology);
        ontology.set("name", name);
        return (Ontology)ontology.update();
    }

    @Deprecated
    public Annotation editAnnotation(Long idAnnotation, String locationWKT) throws CytomineException {
        Annotation annotation = (Annotation)new Annotation().fetch(idAnnotation);
        annotation.set("location", locationWKT);
        return (Annotation)annotation.update();
    }

    @Deprecated
    public Term editTerm(Long idTerm, String name, String color, Long idOntology) throws CytomineException {
        Term term = (Term)new Term().fetch(idTerm);
        term.set("name", name);
        term.set("color", color);
        term.set("ontology", idOntology);
        return (Term)term.update();
    }

    @Deprecated
    public JobData editJobData(Long idJobData, String key, Long idJob, String filename) throws CytomineException {
        JobData jobData = (JobData)new JobData().fetch(idJobData);
        jobData.set("key", key);
        jobData.set("job", idJob);
        jobData.set("filename", filename);
        return (JobData)jobData.update();
    }

    @Deprecated
    public UploadedFile editUploadedFile(Long id, int status, boolean converted, Long idParent) throws CytomineException {
        UploadedFile uploadedFile = (UploadedFile)new UploadedFile().fetch(id);
        uploadedFile.set("status", status);
        uploadedFile.set("converted", converted);
        uploadedFile.set("parent", idParent);
        return (UploadedFile)uploadedFile.update();
    }

    @Deprecated
    public UploadedFile editUploadedFile(Long id, int status, boolean converted) throws CytomineException {
        UploadedFile uploadedFile = (UploadedFile)new UploadedFile().fetch(id);
        uploadedFile.set("status", status);
        uploadedFile.set("converted", converted);
        return (UploadedFile)uploadedFile.update();
    }

    @Deprecated
    public UploadedFile editUploadedFile(Long id, int status) throws CytomineException {
        UploadedFile uploadedFile = (UploadedFile)new UploadedFile().fetch(id);
        uploadedFile.set("status", status);
        return (UploadedFile)uploadedFile.update();
    }

    @Deprecated
    public Project getProject(Long id) throws CytomineException {
        return (Project)new Project().fetch(id);
    }

    @Deprecated
    public ProjectCollection getProjects() throws CytomineException {
        ProjectCollection projects = new ProjectCollection(this.offset, this.max);
        return (ProjectCollection)projects.fetch();
    }

    @Deprecated
    public ProjectCollection getProjectsByOntology(Long idOntology) throws CytomineException {
        ProjectCollection projects = new ProjectCollection(this.offset, this.max);
        projects.addFilter("ontology", idOntology + "");
        return (ProjectCollection)projects.fetch();
    }

    @Deprecated
    public ProjectCollection getProjectsByUser(Long idUser) throws CytomineException {
        ProjectCollection projects = new ProjectCollection(this.offset, this.max);
        projects.addFilter("user", idUser + "");
        return (ProjectCollection)projects.fetch();
    }

    @Deprecated
    public Project addProject(String name, Long idOntology) throws CytomineException {
        return (Project)new Project(name, idOntology).save();
    }

    @Deprecated
    public void deleteProject(Long idProject) throws CytomineException {
        new Project().delete(idProject);
    }

    @Deprecated
    public Ontology getOntology(Long id) throws CytomineException {
        return (Ontology)new Ontology().fetch(id);
    }

    @Deprecated
    public OntologyCollection getOntologies() throws CytomineException {
        OntologyCollection ontologys = new OntologyCollection(this.offset, this.max);
        return (OntologyCollection)ontologys.fetch();
    }

    @Deprecated
    public Ontology addOntology(String name) throws CytomineException {
        return (Ontology)new Ontology(name).save();
    }

    @Deprecated
    public void deleteOntology(Long idOntology) throws CytomineException {
        new Ontology().delete(idOntology);
    }

    @Deprecated
    public AbstractImage addAbstractImage(String filename, String mime) throws CytomineException {
        return (AbstractImage)new AbstractImage(filename, mime).save();
    }

    @Deprecated
    public AbstractImage getAbstractImage(Long id) throws CytomineException {
        return (AbstractImage)new AbstractImage().fetch(id);
    }

    @Deprecated
    public ImageInstance getImageInstance(Long id) throws CytomineException {
        return (ImageInstance)new ImageInstance().fetch(id);
    }

    @Deprecated
    public ImageInstanceCollection getImageInstances(Long idProject) throws CytomineException {
        ImageInstanceCollection image = new ImageInstanceCollection(this.offset, this.max);
        image.addFilter("project", idProject + "");
        return (ImageInstanceCollection)image.fetch();
    }

    @Deprecated
    public ImageInstanceCollection getImageInstancesByOffsetWithMax(Long idProject, int offset, int max) throws CytomineException {
        ImageInstanceCollection image = new ImageInstanceCollection(offset, max);
        image.addFilter("project", idProject + "");
        image.addFilter("offset", offset + "");
        image.addFilter("max", max + "");
        return (ImageInstanceCollection)image.fetch();
    }

    @Deprecated
    public ImageInstance addImageInstance(Long idAbstractImage, Long idProject) throws CytomineException {
        return (ImageInstance)new ImageInstance(idAbstractImage, idProject).save();
    }

    @Deprecated
    public void deleteImageInstance(Long idImageInstance) throws CytomineException {
        new ImageInstance().delete(idImageInstance);
    }

    @Deprecated
    public Annotation getAnnotation(Long id) throws CytomineException {
        return (Annotation)new Annotation().fetch(id);
    }

    @Deprecated
    public AnnotationCollection getAnnotations() throws CytomineException {
        AnnotationCollection annotations = new AnnotationCollection(this.offset, this.max);
        return (AnnotationCollection)annotations.fetch();
    }

    @Deprecated
    public AnnotationCollection getAnnotationsByProject(Long idProject) throws CytomineException {
        AnnotationCollection annotations = new AnnotationCollection(this.offset, this.max);
        annotations.addFilter("project", idProject + "");
        return (AnnotationCollection)annotations.fetch();
    }

    @Deprecated
    public AnnotationCollection getAnnotationsByTerm(Long idTerm) throws CytomineException {
        AnnotationCollection annotations = new AnnotationCollection(this.offset, this.max);
        annotations.addFilter("term", idTerm + "");
        return (AnnotationCollection)annotations.fetch();
    }

    @Deprecated
    public AnnotationCollection getAnnotationsByUser(Long idUser) throws CytomineException {
        AnnotationCollection annotations = new AnnotationCollection(this.offset, this.max);
        annotations.addFilter("user", idUser + "");
        return (AnnotationCollection)annotations.fetch();
    }

    @Deprecated
    public AnnotationCollection getAnnotationsByOntology(Long idOntology) throws CytomineException {
        AnnotationCollection annotations = new AnnotationCollection(this.offset, this.max);
        annotations.addFilter("ontology", idOntology + "");
        return (AnnotationCollection)annotations.fetch();
    }

    @Deprecated
    public AnnotationCollection getAnnotationsByImage(Long idImage) throws CytomineException {
        AnnotationCollection annotations = new AnnotationCollection(this.offset, this.max);
        annotations.addFilter("image", idImage + "");
        return (AnnotationCollection)annotations.fetch();
    }

    @Deprecated
    public Annotation addAnnotation(String locationWKT, Long image) throws CytomineException {
        return (Annotation)new Annotation(locationWKT, image).save();
    }

    @Deprecated
    public Annotation addAnnotationWithTerms(String locationWKT, Long image, List<Long> terms) throws CytomineException {
        return (Annotation)new Annotation(locationWKT, image, terms).save();
    }

    @Deprecated
    public Annotation addAnnotation(String locationWKT, Long image, Long project) throws CytomineException {
        return (Annotation)new Annotation(locationWKT, image, project).save();
    }

    @Deprecated
    public void deleteAnnotation(Long idAnnotation) throws CytomineException {
        new Annotation().delete(idAnnotation);
    }

    @Deprecated
    public Term getTerm(Long id) throws CytomineException {
        return (Term)new Term().fetch(id);
    }

    @Deprecated
    public TermCollection getTerms() throws CytomineException {
        TermCollection terms = new TermCollection(this.offset, this.max);
        return (TermCollection)terms.fetch();
    }

    @Deprecated
    public TermCollection getTermsByOntology(Long idOntology) throws CytomineException {
        TermCollection terms = new TermCollection(this.offset, this.max);
        terms.addFilter("ontology", idOntology + "");
        return (TermCollection)terms.fetch();
    }

    @Deprecated
    public TermCollection getTermsByAnnotation(Long idAnnotation) throws CytomineException {
        TermCollection terms = new TermCollection(this.offset, this.max);
        terms.addFilter("annotation", idAnnotation + "");
        return (TermCollection)terms.fetch();
    }

    @Deprecated
    public Term addTerm(String name, String color, Long idOntology) throws CytomineException {
        return (Term)new Term(name, color, idOntology).save();
    }

    @Deprecated
    public void deleteTerm(Long idTerm) throws CytomineException {
        new Term().delete(idTerm);
    }

    @Deprecated
    public AnnotationTerm addAnnotationTerm(Long idAnnotation, Long idTerm) throws CytomineException {
        return (AnnotationTerm)new AnnotationTerm(idAnnotation, idTerm).save();
    }

    @Deprecated
    public AnnotationTerm addAnnotationTerm(Long idAnnotation, Long idTerm, Long idExpectedTerm, Long idUser, double rate) throws CytomineException {
        return (AnnotationTerm)new AnnotationTerm(idAnnotation, idTerm, idExpectedTerm, idUser, rate).save();
    }

    @Deprecated
    public User addUser(String username, String firstname, String lastname, String email, String password) throws CytomineException {
        return (User)new User(username, firstname, lastname, email, password).save();
    }

    @Deprecated
    public User getUser(Long id) throws CytomineException {
        return (User)new User().fetch(id);
    }

    @Deprecated
    public UserCollection getUsers() throws CytomineException {
        UserCollection users = new UserCollection(this.offset, this.max);
        return (UserCollection)users.fetch();
    }

    @Deprecated
    public UserJob getUserJob(Long id) throws CytomineException {
        return (UserJob)new UserJob().fetch(id);
    }

    @Deprecated
    public Job getJob(Long id) throws CytomineException {
        return (Job)new Job().fetch(id);
    }

    @Deprecated
    public Software addSoftware(String name, Long idSoftwareUserRepository, Long idDefaultProcessingServer, String resultType, String executeCommand) throws CytomineException {
        return (Software)new Software(name, resultType, executeCommand, "", idSoftwareUserRepository, idDefaultProcessingServer).save();
    }

    @Deprecated
    public void deleteSoftware(Long idSoftware) throws CytomineException {
        new Software().delete(idSoftware);
    }

    @Deprecated
    public SoftwareParameter addSoftwareParameter(String name, String type, Long idSoftware, String defaultValue, boolean required, int index, String uri, String uriSortAttribut, String uriPrintAttribut, boolean setByServer) throws CytomineException {
        return (SoftwareParameter)new SoftwareParameter(name, type, idSoftware, defaultValue, required, index, uri, uriSortAttribut, uriPrintAttribut, setByServer).save();
    }

    @Deprecated
    public SoftwareParameter addSoftwareParameter(String name, String type, Long idSoftware, String defaultValue, boolean required, int index, String uri, String uriSortAttribut, String uriPrintAttribut) throws CytomineException {
        return this.addSoftwareParameter(name, type, idSoftware, defaultValue, required, index, uri, uriSortAttribut, uriPrintAttribut, false);
    }

    @Deprecated
    public SoftwareParameter addSoftwareParameter(String name, String type, Long idSoftware, String defaultValue, boolean required, int index) throws CytomineException {
        return this.addSoftwareParameter(name, type, idSoftware, defaultValue, required, index, null, null, null, false);
    }

    @Deprecated
    public SoftwareParameter addSoftwareParameter(String name, String type, Long idSoftware, String defaultValue, boolean required, int index, boolean setByServer) throws CytomineException {
        return this.addSoftwareParameter(name, type, idSoftware, defaultValue, required, index, null, null, null, setByServer);
    }

    @Deprecated
    public SoftwareProject addSoftwareProject(Long idSoftware, Long idProject) throws CytomineException {
        return (SoftwareProject)new SoftwareProject(idSoftware, idProject).save();
    }

    @Deprecated
    public SoftwareCollection getSoftwaresByProject(Long idProject) throws CytomineException {
        SoftwareCollection softwares = new SoftwareCollection(this.offset, this.max);
        softwares.addFilter("project", idProject + "");
        return (SoftwareCollection)softwares.fetch();
    }

    @Deprecated
    public SoftwareCollection getSoftwares() throws CytomineException {
        SoftwareCollection softwares = new SoftwareCollection(this.offset, this.max);
        return (SoftwareCollection)softwares.fetch();
    }

    @Deprecated
    public ImageFilter addImageFilter(String name, String baseUrl, String processingServer) throws CytomineException {
        return (ImageFilter)new ImageFilter(name, baseUrl, processingServer).save();
    }

    public JobData getJobData(Long id) throws CytomineException {
        return (JobData)new JobData().fetch(id);
    }

    @Deprecated
    public JobDataCollection getJobDatas() throws CytomineException {
        JobDataCollection jobDatas = new JobDataCollection(this.offset, this.max);
        return (JobDataCollection)jobDatas.fetch();
    }

    @Deprecated
    public JobDataCollection getJobDataByJob(Long idJob) throws CytomineException {
        JobDataCollection jobDatas = new JobDataCollection(this.offset, this.max);
        jobDatas.addFilter("job", idJob + "");
        return (JobDataCollection)jobDatas.fetch();
    }

    @Deprecated
    public JobData addJobData(String key, Long idJob, String filename) throws CytomineException {
        return (JobData)new JobData(idJob, key, filename).save();
    }

    public void deleteJobData(Long idJobData) throws CytomineException {
        new JobData().delete(idJobData);
    }

    @Deprecated
    public ReviewedAnnotationCollection getReviewedAnnotationsByProject(Long idProject) throws CytomineException {
        ReviewedAnnotationCollection reviewed = new ReviewedAnnotationCollection(this.offset, this.max);
        reviewed.addFilter("project", idProject + "");
        return (ReviewedAnnotationCollection)reviewed.fetch();
    }

    @Deprecated
    public Storage getStorage(Long id) throws CytomineException {
        return (Storage)new Storage().fetch(id);
    }

    @Deprecated
    public StorageCollection getStorages() throws CytomineException {
        StorageCollection storages = new StorageCollection(this.offset, this.max);
        return (StorageCollection)storages.fetch();
    }

    @Deprecated
    public StorageAbstractImage addStorageAbstractImage(Long idStorage, Long idAbstractImage) throws CytomineException {
        return new StorageAbstractImage(idStorage, idAbstractImage);
    }

    @Deprecated
    public AbstractImage editAbstractImage(Long idAbstractImage, String originalFilename) throws CytomineException {
        AbstractImage image = (AbstractImage)new AbstractImage().fetch(idAbstractImage);
        image.set("originalFilename", originalFilename);
        return (AbstractImage)image.update();
    }

    @Deprecated
    public ImageGroup addImageGroup(Long idProject) throws CytomineException {
        return (ImageGroup)new ImageGroup(idProject).save();
    }

    @Deprecated
    public ImageSequence addImageSequence(Long idImageGroup, Long idImage, Integer zStack, Integer slice, Integer time, Integer channel) throws CytomineException {
        return (ImageSequence)new ImageSequence(idImageGroup, idImage, zStack, slice, time, channel).save();
    }

    @Deprecated
    public RoleCollection getRoles() throws CytomineException {
        RoleCollection roles = new RoleCollection(this.offset, this.max);
        return (RoleCollection)roles.fetch();
    }

    @Deprecated
    public JobTemplate addJobTemplate(String name, Long iProject, Long idSoftware) throws CytomineException {
        return (JobTemplate)new JobTemplate(name, iProject, idSoftware).save();
    }

    @Deprecated
    public JobParameter addJobParameter(Long job, Long softwareParameter, String value) throws CytomineException {
        return (JobParameter)new JobParameter(job, softwareParameter, value).save();
    }

    @Deprecated
    public UploadedFile addUploadedFile(String originalFilename, String realFilename, String path, Long size, String ext, String contentType, List idProjects, List idStorages, Long idUser, Long idParent) throws CytomineException {
        return this.addUploadedFile(originalFilename, realFilename, path, size, ext, contentType, idProjects, idStorages, idUser, -1L, idParent);
    }

    @Deprecated
    public UploadedFile addUploadedFile(String originalFilename, String realFilename, String path, Long size, String ext, String contentType, List idProjects, List idStorages, Long idUser, Long status, Long idParent) throws CytomineException {
        UploadedFile.Status state = Arrays.stream(UploadedFile.Status.values()).filter(c -> (long)c.getCode() == status).findFirst().get();
        return (UploadedFile)new UploadedFile(originalFilename, realFilename, path, size, ext, contentType, idProjects, idStorages, idUser, state, idParent).save();
    }

    @Deprecated
    public UploadedFile getUploadedFile(Long id) throws CytomineException {
        return (UploadedFile)new UploadedFile().fetch(id);
    }

    @Deprecated
    public void deleteUploadedFile(Long idUploadedFile) throws CytomineException {
        UploadedFile uploadedFile = new UploadedFile();
        uploadedFile.set("id", idUploadedFile);
        uploadedFile.delete();
    }

    public UploadedFile getUploadedFileByAbstractImage(Long idAbstractImage) throws CytomineException {
        return UploadedFile.getByAbstractImage(idAbstractImage);
    }

    @Deprecated
    public AmqpQueueCollection getAmqpQueue() throws CytomineException {
        AmqpQueueCollection queues = new AmqpQueueCollection(this.offset, this.max);
        return (AmqpQueueCollection)queues.fetch();
    }

    public static String convertDomainName(String input) {
        switch (input.toLowerCase()) {
            case "project": {
                return "be.cytomine.project.Project";
            }
            case "imageinstance": {
                return "be.cytomine.image.ImageInstance";
            }
            case "annotation": {
                return "be.cytomine.AnnotationDomain";
            }
            case "software": {
                return "be.cytomine.processing.Software";
            }
            case "softwareparameter": {
                return "be.cytomine.processing.SoftwareParameter";
            }
            case "software_parameter": {
                return "be.cytomine.processing.SoftwareParameter";
            }
            case "storage": {
                return "be.cytomine.image.server.Storage";
            }
        }
        try {
            throw new CytomineException(400, "Client doesn't support other domain for now. Domain was " + input);
        }
        catch (CytomineException e) {
            e.printStackTrace();
            return "";
        }
    }

    public DeleteCommandCollection getDeleteCommandByDomainAndAfterDate(String domain, Long timestamp) throws CytomineException {
        DeleteCommandCollection commands = new DeleteCommandCollection(this.offset, this.max);
        commands.addParams("domain", "uploadedFile");
        commands.addParams("after", timestamp.toString());
        return (DeleteCommandCollection)commands.fetch();
    }

    public static enum Operator {
        OR,
        AND;

    }

    public static enum Filter {
        ALL,
        PROJECT,
        ANNOTATION,
        IMAGE,
        ABSTRACTIMAGE;

    }
}

