/*
 * Decompiled with CFR 0.152.
 */
package be.cytomine.client.models;

import be.cytomine.client.Cytomine;
import be.cytomine.client.CytomineException;
import be.cytomine.client.models.Model;
import be.cytomine.client.models.Project;
import be.cytomine.client.models.Software;

public class Job
extends Model<Job> {
    public Job() {
    }

    public Job(Software software, Project project) {
        this(software.getId(), project.getId());
    }

    public Job(Long softwareId, Long projectId) {
        this.set("project", projectId);
        this.set("software", softwareId);
    }

    public void execute() throws CytomineException {
        Cytomine.getInstance().getDefaultCytomineConnection().doPost("/api/job/" + this.get("id") + "/execute.json", "");
    }

    public Job changeStatus(JobStatus status, int progress) throws CytomineException {
        return this.changeStatus(status.getValue(), progress);
    }

    public Job changeStatus(JobStatus status, int progress, String comment) throws CytomineException {
        return this.changeStatus(status.getValue(), progress, comment);
    }

    public Job changeStatus(int status, int progress) throws CytomineException {
        return this.changeStatus(status, progress, null);
    }

    public Job changeStatus(int status, int progress, String comment) throws CytomineException {
        this.set("progress", progress);
        this.set("status", status);
        this.set("statusComment", comment);
        return (Job)this.update();
    }

    public static enum JobStatus {
        NOTLAUNCH(0),
        INQUEUE(1),
        RUNNING(2),
        SUCCESS(3),
        FAILED(4),
        INDETERMINATE(5),
        WAIT(6),
        PREVIEWED(7),
        KILLED(8);

        private int valueOfJob;

        private JobStatus(int value) {
            this.valueOfJob = value;
        }

        public int getValue() {
            return this.valueOfJob;
        }
    }
}

