/*
 * Decompiled with CFR 0.152.
 */
package be.cytomine.client.models;

import be.cytomine.client.Cytomine;
import be.cytomine.client.CytomineConnection;
import be.cytomine.client.CytomineException;
import be.cytomine.client.models.Model;
import java.util.Map;
import org.json.simple.JSONObject;

public class Property
extends Model<Property> {
    public Property() {
    }

    public Property(Model model) {
        this(model, null, null);
    }

    public Property(Model model, String key, String value) {
        this(model.getClass().getSimpleName().toLowerCase(), model.getId(), key, value);
    }

    public Property(String domain, Long idDomain) {
        this(domain, idDomain, null);
    }

    public Property(String domain, Long idDomain, String key) {
        this(domain, idDomain, key, null);
    }

    public Property(String domain, Long idDomain, String key, String value) {
        this.addFilter(domain, idDomain.toString());
        this.addFilter("key", key);
        this.set("key", key);
        this.set("value", value);
    }

    @Override
    public Property fetch(Long id) throws CytomineException {
        return this.fetch(Cytomine.getInstance().getDefaultCytomineConnection(), id);
    }

    public Property fetch(String id) throws CytomineException {
        return this.fetch(Cytomine.getInstance().getDefaultCytomineConnection(), id);
    }

    @Override
    public Property fetch(CytomineConnection connection, Long id) throws CytomineException {
        throw new CytomineException(400, "Cannot fetch property with an id, fetch it with its key");
    }

    public Property fetch(CytomineConnection connection, String id) throws CytomineException {
        this.set("key", id);
        this.addFilter("key", id);
        JSONObject json = connection.doGet(this.toURL());
        this.setAttr(json);
        return this;
    }

    @Override
    public String getJSONResourceURL() {
        Long id = this.getId();
        String base = "/api/";
        if (this.getFilter("key") != null && this.get("value") != null) {
            this.filters.remove("key");
        }
        base = base + this.getFilterPrefix();
        base = base + this.getDomainName();
        base = id != null ? base + "/" + id + ".json?" : base + ".json?";
        for (Map.Entry param : this.params.entrySet()) {
            base = base + (String)param.getKey() + "=" + (String)param.getValue() + "&";
        }
        base = base.substring(0, base.length() - 1);
        return base;
    }
}

