/*
 * Decompiled with CFR 0.152.
 */
package be.cytomine.client.models;

import be.cytomine.client.Cytomine;
import be.cytomine.client.CytomineConnection;
import be.cytomine.client.CytomineException;
import be.cytomine.client.models.Model;
import java.io.File;
import java.util.Map;

public class Software
extends Model<Software> {
    public Software() {
    }

    public Software(String name, String resultType, String executeCommand, String softwareVersion) {
        this.set("name", name);
        this.set("resultName", resultType);
        this.set("executeCommand", executeCommand);
        this.set("softwareVersion", softwareVersion);
    }

    public Software(String name, String resultType, String executeCommand, String softwareVersion, Long idSoftwareUserRepository, Long idDefaultProcessingServer) {
        this.set("name", name);
        this.set("softwareUserRepository", idSoftwareUserRepository);
        this.set("defaultProcessingServer", idDefaultProcessingServer);
        this.set("resultName", resultType);
        this.set("executeCommand", executeCommand);
        this.set("softwareVersion", softwareVersion);
    }

    public Software(String name, String resultType, String executeCommand, String softwareVersion, Long idSoftwareUserRepository, Long idDefaultProcessingServer, String pullingCommand) {
        this.set("name", name);
        this.set("softwareUserRepository", idSoftwareUserRepository);
        this.set("defaultProcessingServer", idDefaultProcessingServer);
        this.set("resultName", resultType);
        this.set("executeCommand", executeCommand);
        this.set("softwareVersion", softwareVersion);
        this.set("pullingCommand", pullingCommand);
    }

    public Software deprecate() throws CytomineException {
        this.set("deprecated", true);
        return (Software)this.update();
    }

    public void upload(File file) throws CytomineException {
        this.upload(Cytomine.getInstance().getDefaultCytomineConnection(), file);
    }

    public void upload(CytomineConnection connection, File file) throws CytomineException {
        String url = "/api/" + this.getDomainName() + "/upload";
        connection.uploadFile(url, file, (Map<String, String>)this.attr);
    }

    public void download(String destPath) throws CytomineException {
        this.download(new File(destPath));
    }

    public void download(File dest) throws CytomineException {
        this.download(Cytomine.getInstance().getDefaultCytomineConnection(), dest);
    }

    public void download(CytomineConnection connection, File dest) throws CytomineException {
        String url = "/api/" + this.getDomainName() + "/" + this.getId() + "/download";
        connection.downloadFile(url, dest.getPath());
    }
}

