/*
 * Decompiled with CFR 0.152.
 */
package be.cytomine.client.sample;

import be.cytomine.client.Cytomine;
import be.cytomine.client.CytomineException;
import be.cytomine.client.models.AbstractImage;
import be.cytomine.client.models.ImageGroup;
import be.cytomine.client.models.ImageInstance;
import be.cytomine.client.models.ImageSequence;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class ImageExample {
    private static final Logger log = LogManager.getLogger(ImageExample.class);

    public static void changeImageName(Cytomine cytomine, Long idImageInstance, String newName) throws Exception {
        System.out.println("Look for image instance " + idImageInstance);
        ImageInstance ii = (ImageInstance)new ImageInstance().fetch(idImageInstance);
        System.out.println("Look for abstract image " + ii.getLong("baseImage"));
        AbstractImage ai = (AbstractImage)new AbstractImage().fetch(ii.getLong("baseImage"));
        ai.set("originalFilename", newName);
        ai.update();
        System.out.println("New name is " + ((AbstractImage)new AbstractImage().fetch(ai.getId())).getStr("originalFilename"));
    }

    public static void testAddSequence(Cytomine cytomine) throws Exception {
        ImageGroup imageGroup = cytomine.addImageGroup(20475571L);
        ImageSequence imageSequence1 = cytomine.addImageSequence(imageGroup.getId(), 84251653L, 0, 0, 0, 0);
        ImageSequence imageSequence2 = cytomine.addImageSequence(imageGroup.getId(), 84215226L, 0, 0, 0, 1);
        ImageSequence imageSequence3 = cytomine.addImageSequence(imageGroup.getId(), 84225416L, 0, 0, 0, 2);
        ImageSequence imageSequence4 = cytomine.addImageSequence(imageGroup.getId(), 84262543L, 0, 0, 0, 3);
    }

    public static void testUpload(Cytomine cytomine, String uploadURL) throws Exception {
        try {
            String file = "/media/DATA/image/P21-10GH050246-A7_CD3_201404021522.tif";
            Long idProject = 92279388L;
            Long idStorage = 17763541L;
            String cytomineHost = "http://beta.cytomine.be";
            System.out.println("Connection on " + cytomine.getHost());
            boolean i = false;
            JSONArray json = cytomine.uploadImage(uploadURL, file, idProject, idStorage, cytomineHost, null, true);
            System.out.println(json.get(0));
            System.out.println(((JSONObject)json.get(0)).get("images"));
        }
        catch (CytomineException e) {
            log.error(e);
        }
    }
}

