/*
 * Decompiled with CFR 0.152.
 */
package danyfel80.common.stream;

import danyfel80.common.stream.CheckedConsumer;
import danyfel80.common.stream.CheckedFunction;
import danyfel80.common.stream.CheckedSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class StreamUtils {
    public static <T, R> Function<T, R> wrapFunction(CheckedFunction<T, R> checkedFunction) throws RuntimeException {
        return t -> {
            try {
                return checkedFunction.apply(t);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static <T> Consumer<T> wrapConsumer(CheckedConsumer<T> checkedConsumer) throws RuntimeException {
        return t -> {
            try {
                checkedConsumer.apply(t);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static <R> Supplier<R> wrapSupplier(CheckedSupplier<R> checkedSupplier) throws RuntimeException {
        return () -> {
            try {
                return checkedSupplier.apply();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }
}

