/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.command.process;

import java.net.URL;
import org.bioimageanalysis.icy.icytomine.command.process.CommandProcess;
import org.bioimageanalysis.icy.icytomine.core.connection.CytomineConnector;
import org.bioimageanalysis.icy.icytomine.core.connection.client.CytomineClient;
import org.bioimageanalysis.icy.icytomine.core.connection.persistence.Preferences;

public class ConnectionCommand
implements CommandProcess<CytomineClient> {
    private static final String COMMAND = "connect";
    private static final String[] ARGUMENTS = new String[]{"host", "username", "(Optional) publicKey", "(Optional) privateKey"};
    private static final String NAME = "Connection";
    private static final String DESCRIPTION = "Allows to connect to a cytomine server by providing the corresponding credentials";
    private String[] args;

    @Override
    public CytomineClient call() throws Exception {
        Preferences.loadOrDefault();
        Preferences prefs = Preferences.getInstance();
        this.checkArgs();
        URL hostURL = null;
        String username = null;
        String publicKey = null;
        String privateKey = null;
        switch (this.args.length) {
            case 0: {
                if (!prefs.getDefaultHostURL().isPresent()) {
                    throw new IllegalArgumentException("No registered default host.");
                }
                hostURL = new URL(prefs.getDefaultHostURL().get());
                if (!prefs.getDefaultUserName().isPresent()) {
                    throw new IllegalArgumentException("No registered default user.");
                }
                username = prefs.getDefaultUserName().get();
                break;
            }
            case 2: {
                hostURL = new URL(this.args[0]);
                username = this.args[1];
                break;
            }
            case 4: {
                hostURL = new URL(this.args[0]);
                username = this.args[1];
                publicKey = this.args[2];
                privateKey = this.args[3];
            }
        }
        if (this.args.length == 4) {
            CytomineConnector.addUserIfAbsent(hostURL, username, publicKey, privateKey);
            Preferences.save();
        }
        return CytomineConnector.login(hostURL, username).get();
    }

    private void checkArgs() {
        if (this.args.length != 0 && this.args.length != 2 && this.args.length != 4) {
            throw new IllegalArgumentException(String.format("2 or 4 arguments are expected, but received %d.", this.args.length));
        }
    }

    @Override
    public String getCommand() {
        return COMMAND;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String[] getArgumentsDescription() {
        return ARGUMENTS;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    public ConnectionCommand setArguments(String[] args) {
        this.args = args;
        return this;
    }

    @Override
    public CommandProcess<CytomineClient> setPreviousResult(Object result) {
        return this;
    }

    @Override
    public String[] getArguments() {
        return this.args;
    }

    @Override
    public Object getPreviousResult() {
        return null;
    }
}

