/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.command.process.connected;

import java.util.List;
import org.bioimageanalysis.icy.icytomine.command.process.connected.ConnectedCommandProcess;
import org.bioimageanalysis.icy.icytomine.core.model.Project;

public class ProjectsCommandProcess
extends ConnectedCommandProcess<String> {
    private static final String COMMAND = "projects";
    private static final String NAME = "List projects";
    private static final String[] ARGS_DESCRIPTION = new String[0];
    private static final String DESCRIPTION = "Lists all projects associated to the connected user.";

    @Override
    public String getCommand() {
        return COMMAND;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String[] getArgumentsDescription() {
        return ARGS_DESCRIPTION;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public String call() throws Exception {
        StringBuffer projectList = new StringBuffer();
        List<Project> projects = this.getClient().getUserProjects(this.getClient().getCurrentUser().getId());
        projectList.append("Projects (ID, Name, Description, # Images, # Annotations):\n");
        for (Project project : projects) {
            projectList.append(project.getId() + " " + project.getName().orElse("Not specified") + " " + project.getDescription().getData().orElse("Not specified") + " " + project.getNumberOfImages().orElse(0L) + " " + project.getNumberOfAnnotations().orElse(0L) + "\n");
        }
        return projectList.toString();
    }
}

