/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.core.image.importer;

import icy.common.listener.ProgressListener;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.bioimageanalysis.icy.icytomine.core.image.importer.TileGridImporter;
import org.bioimageanalysis.icy.icytomine.core.image.importer.TileGridStitcher;
import org.bioimageanalysis.icy.icytomine.core.image.tile.FixedTileCalculator;
import org.bioimageanalysis.icy.icytomine.core.model.Image;
import org.bioimageanalysis.icy.icytomine.core.view.converters.MagnitudeResolutionConverter;

public class TiledImageImporter {
    private Image imageInformation;
    private double targetResolution;
    private Rectangle2D boundsAtTargetResolution;
    private int zeroResolution = 0;
    private Rectangle2D boundsAtZeroResolution;
    private int requestResolution;
    private Rectangle2D boundsAtRequestResolution;
    private Dimension2D tileDimensionAtRequestResolution;
    private Rectangle tileGrigToRequest;
    private Set<TiledImageImportationListener> tiledImageImportationListeners;
    private Set<ProgressListener> importationProgressListeners;
    private TileGridImporter tileGridImporter;
    private CompletableFuture<BufferedImage> requestResult;

    public TiledImageImporter(Image imageInformation) {
        this.imageInformation = imageInformation;
        this.tiledImageImportationListeners = new HashSet<TiledImageImportationListener>();
        this.importationProgressListeners = new HashSet<ProgressListener>();
    }

    public Future<BufferedImage> requestImage(double resolution, Rectangle2D boundsAtZeroResolution) {
        this.targetResolution = resolution;
        this.boundsAtZeroResolution = boundsAtZeroResolution;
        this.computeRequestParameters();
        return this.requestImage();
    }

    private void computeRequestParameters() {
        this.computeBoundsAtTargetResolution();
        this.computeRequestResolution();
        this.computeBoundsAtRequestResolution();
        this.computeTileDimensionAtRequestResolution();
        this.computeTileGridToRequest();
    }

    private void computeBoundsAtTargetResolution() {
        this.boundsAtTargetResolution = MagnitudeResolutionConverter.convertRectangle2D(this.boundsAtZeroResolution, this.zeroResolution, this.targetResolution);
    }

    private void computeRequestResolution() {
        int minResolution = this.zeroResolution;
        int maxResolution = this.imageInformation.getDepth().get().intValue();
        this.requestResolution = Math.max(minResolution, Math.min((int)this.targetResolution, maxResolution));
    }

    private void computeBoundsAtRequestResolution() {
        this.boundsAtRequestResolution = MagnitudeResolutionConverter.convertRectangle2D(this.boundsAtZeroResolution, this.zeroResolution, this.requestResolution);
    }

    private void computeTileDimensionAtRequestResolution() {
        this.tileDimensionAtRequestResolution = this.imageInformation.getTileSize().get();
    }

    private void computeTileGridToRequest() {
        Dimension tileDim = new Dimension((int)this.tileDimensionAtRequestResolution.getWidth(), (int)this.tileDimensionAtRequestResolution.getHeight());
        FixedTileCalculator calculator = new FixedTileCalculator(this.boundsAtRequestResolution, new Point(), tileDim);
        Dimension2D imageDim = this.getImageSizeAtRequestResolution();
        this.tileGrigToRequest = calculator.getLimitedTileGridBounds(imageDim);
    }

    private Dimension2D getImageSizeAtRequestResolution() {
        Dimension dimAtZeroRes = this.imageInformation.getSize().get();
        return MagnitudeResolutionConverter.convertDimension2D(dimAtZeroRes, 0.0, this.requestResolution);
    }

    private Future<BufferedImage> requestImage() {
        this.tileGridImporter = new TileGridImporter(this.imageInformation, this.requestResolution, this.tileGrigToRequest);
        TileGridStitcher tileStitcher = new TileGridStitcher(this.targetResolution, this.boundsAtTargetResolution, this.tileGridImporter);
        tileStitcher.addStitchingFinishListener(endResult -> this.stitchingFinished(tileStitcher, endResult));
        this.importationProgressListeners.forEach(listener -> tileStitcher.addProgressListener((ProgressListener)listener));
        tileStitcher.startStitchingTiles();
        this.requestResult = new CompletableFuture();
        return this.requestResult;
    }

    private void stitchingFinished(TileGridStitcher tileStitcher, Future<Void> endResult) {
        try {
            if (!endResult.isCancelled()) {
                endResult.get();
                this.requestResult.complete(tileStitcher.getTargetImage());
            } else {
                this.requestResult.cancel(true);
            }
        }
        catch (InterruptedException | ExecutionException e) {
            this.requestResult.completeExceptionally(e);
        }
        this.tiledImageImportationListeners.forEach(l -> l.imageImported(this.requestResult));
    }

    public void addTiledImageImportationListener(TiledImageImportationListener listener) {
        this.tiledImageImportationListeners.add(listener);
    }

    public void removeTiledImageImportationListener(TiledImageImportationListener listener) {
        this.tiledImageImportationListeners.remove(listener);
    }

    public void addImportationProgressListener(ProgressListener listener) {
        this.importationProgressListeners.add(listener);
    }

    public void removeImportationProgressListener(ProgressListener listener) {
        this.importationProgressListeners.remove(listener);
    }

    public void cancel() throws RuntimeException, InterruptedException {
        if (this.tileGridImporter != null) {
            this.tileGridImporter.cancelImportation();
        }
    }

    public static interface TiledImageImportationListener {
        public void imageImported(Future<BufferedImage> var1);
    }
}

