/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.core.model;

import java.awt.Color;
import java.util.Optional;
import org.bioimageanalysis.icy.icytomine.core.connection.client.CytomineClient;
import org.bioimageanalysis.icy.icytomine.core.connection.client.CytomineClientException;
import org.bioimageanalysis.icy.icytomine.core.model.Entity;

public class Term
extends Entity {
    public static final Color DEFAULT_TERM_COLOR = Color.GREEN;

    public static Term retrieve(CytomineClient client, long termId) throws CytomineClientException {
        return client.getTerm(termId);
    }

    public Term(CytomineClient client, be.cytomine.client.models.Term internalTerm) {
        super(client, internalTerm);
    }

    public be.cytomine.client.models.Term getInternalTerm() {
        return (be.cytomine.client.models.Term)this.getModel();
    }

    public Optional<String> getName() {
        return this.getStr("name");
    }

    public Optional<String> getComment() {
        return this.getStr("comment");
    }

    public Optional<String> getHexColor() {
        return this.getStr("color");
    }

    public Color getColor() {
        Optional<String> hexColor = this.getHexColor();
        if (!hexColor.isPresent()) {
            return DEFAULT_TERM_COLOR;
        }
        String hexColorString = hexColor.get();
        int red = Integer.parseInt(hexColorString.substring(1, 3), 16);
        int green = Integer.parseInt(hexColorString.substring(3, 5), 16);
        int blue = Integer.parseInt(hexColorString.substring(5, 7), 16);
        Color termColor = new Color(red, green, blue);
        return termColor;
    }

    @Override
    public String toString() {
        return String.format("Term: id=%s, name=%s", String.valueOf(this.getId()), this.getName().orElse("Not specified"));
    }
}

