/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.core.model.cache;

import icy.plugin.PluginLoader;
import org.bioimageanalysis.icy.icytomine.core.connection.client.CytomineClient;
import org.bioimageanalysis.icy.icytomine.core.model.Entity;
import org.bioimageanalysis.icy.icytomine.core.model.cache.EntityCacheException;
import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.ehcache.config.Builder;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;

public abstract class EntityCache<K, V extends Entity> {
    private static CacheManager cacheManager = CacheManagerBuilder.newCacheManagerBuilder().withClassLoader(PluginLoader.getLoader()).withDefaultSizeOfMaxObjectGraph(500L).build(true);
    protected static final long ENTITY_HEAP_SIZE = 500L;
    private CytomineClient client;
    private Cache<K, V> cache;

    public static CacheManager getCacheManager() {
        return cacheManager;
    }

    public EntityCache(CytomineClient client) {
        this.client = client;
    }

    public V retrieve(K entityId) throws EntityCacheException {
        Entity entity = (Entity)this.getCache().get(entityId);
        if (entity == null) {
            throw new EntityCacheException(String.format("Entity was not found in %s cache: %s", this.getValueClass().getSimpleName(), entityId.toString()));
        }
        return (V)entity;
    }

    public void store(K entityId, V entity) {
        this.getCache().put(entityId, entity);
    }

    public Cache<K, V> getCache() {
        if (this.cache == null) {
            this.cache = this.retrieveOrCreateCache();
        }
        return this.cache;
    }

    public boolean remove(K entityId) {
        if (this.cache != null) {
            this.cache.remove(entityId);
            return true;
        }
        return false;
    }

    private Cache<K, V> retrieveOrCreateCache() {
        Cache cache = cacheManager.getCache(this.getCacheAlias(), this.getKeyClass(), this.getValueClass());
        if (cache == null) {
            return cacheManager.createCache(this.getCacheAlias(), CacheConfigurationBuilder.newCacheConfigurationBuilder(this.getKeyClass(), this.getValueClass(), (Builder)ResourcePoolsBuilder.heap((long)this.getHeapSize())).build());
        }
        return cache;
    }

    public String getCacheAlias() {
        return String.format("%s%d", this.getClass().getSimpleName(), this.getClient().hashCode());
    }

    protected CytomineClient getClient() {
        return this.client;
    }

    protected abstract Class<K> getKeyClass();

    protected abstract Class<V> getValueClass();

    public long getHeapSize() {
        return 500L;
    }
}

