/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.ui.core.login;

import icy.gui.dialog.MessageDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class AddHostDialog
extends JDialog {
    private Container contentPane = this.getContentPane();
    private JTextField hostTextField;
    private JButton addHostButton;
    private JButton cancelButton;
    private ActionListener addHostButtonListener;

    public AddHostDialog(Frame owner) {
        super(owner, "Add Host - Icytomine", true);
        this.setPreferredSize(new Dimension(275, 140));
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.setResizable(false);
        this.adjustLayout();
        this.addHostLabel();
        this.addHostTextField();
        this.addAddHostButton();
        this.addCancelButton();
        this.setCancelButtonHandler();
        this.pack();
        this.setLocationRelativeTo(owner);
    }

    private void adjustLayout() {
        this.contentPane.setPreferredSize(new Dimension(300, 210));
        GridBagLayout contentPanelLayout = new GridBagLayout();
        contentPanelLayout.columnWidths = new int[]{1, 1};
        contentPanelLayout.rowHeights = new int[]{0, 0, 0};
        contentPanelLayout.columnWeights = new double[]{0.0, 0.0};
        contentPanelLayout.rowWeights = new double[]{0.0, 0.0, 0.0};
        this.contentPane.setLayout(contentPanelLayout);
    }

    private void addHostLabel() {
        JLabel hostLabel = new JLabel("Specify the host address");
        GridBagConstraints hostLabelConstraints = new GridBagConstraints();
        hostLabelConstraints.gridwidth = 2;
        hostLabelConstraints.insets = new Insets(10, 0, 5, 0);
        hostLabelConstraints.gridx = 0;
        hostLabelConstraints.gridy = 0;
        this.contentPane.add((Component)hostLabel, hostLabelConstraints);
    }

    private void addHostTextField() {
        this.hostTextField = new JTextField();
        this.hostTextField.setColumns(10);
        GridBagConstraints hostTextFieldConstraints = new GridBagConstraints();
        hostTextFieldConstraints.gridwidth = 2;
        hostTextFieldConstraints.insets = new Insets(0, 0, 5, 0);
        hostTextFieldConstraints.fill = 2;
        hostTextFieldConstraints.gridx = 0;
        hostTextFieldConstraints.gridy = 1;
        this.contentPane.add((Component)this.hostTextField, hostTextFieldConstraints);
    }

    private void addAddHostButton() {
        this.addHostButton = new JButton("Add host");
        this.addHostButton.setMinimumSize(new Dimension(75, 23));
        this.addHostButton.setMaximumSize(new Dimension(75, 23));
        this.addHostButton.setPreferredSize(new Dimension(75, 23));
        this.addHostButton.setAlignmentX(0.5f);
        GridBagConstraints addHostButtonConstraints = new GridBagConstraints();
        addHostButtonConstraints.insets = new Insets(0, 0, 0, 5);
        addHostButtonConstraints.gridx = 0;
        addHostButtonConstraints.gridy = 2;
        this.contentPane.add((Component)this.addHostButton, addHostButtonConstraints);
    }

    private void addCancelButton() {
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setMinimumSize(new Dimension(75, 23));
        this.cancelButton.setMaximumSize(new Dimension(75, 23));
        this.cancelButton.setPreferredSize(new Dimension(75, 23));
        this.cancelButton.setAlignmentX(0.5f);
        GridBagConstraints cancelButtonConstraints = new GridBagConstraints();
        cancelButtonConstraints.gridx = 1;
        cancelButtonConstraints.gridy = 2;
        this.contentPane.add((Component)this.cancelButton, cancelButtonConstraints);
    }

    public void setHostAdditionListener(HostAdditionListener listener) {
        if (this.addHostButtonListener == null) {
            this.addHostButtonListener = e -> {
                String hostName = this.hostTextField.getText();
                try {
                    listener.requestAddition(hostName);
                    this.setVisible(false);
                    this.dispose();
                }
                catch (RuntimeException ex) {
                    MessageDialog.showDialog((String)"Error adding host", (String)ex.getMessage(), (int)0);
                }
            };
        }
        this.addHostButton.addActionListener(this.addHostButtonListener);
    }

    public void unsetHostAdditionListener() {
        if (this.addHostButtonListener != null) {
            this.addHostButton.removeActionListener(this.addHostButtonListener);
        }
    }

    private void setCancelButtonHandler() {
        this.cancelButton.addActionListener(e -> {
            this.setVisible(false);
            this.dispose();
        });
    }

    public static interface HostAdditionListener {
        public void requestAddition(String var1) throws RuntimeException;
    }
}

