/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.ui.core.login;

import icy.gui.dialog.MessageDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AddUserDialog
extends JDialog {
    private String targetHostName;
    private Container contentPane;
    private JTextField userTextField;
    private JTextField publicKeyTextField;
    private JTextField privateKeyTextField;
    private JButton addButton;
    private JButton cancelButton;
    private ActionListener addUserButtonListener;

    public AddUserDialog(Frame owner, String hostName) {
        super(owner, "Add User - Icytomine", true);
        this.targetHostName = hostName;
        this.contentPane = this.getContentPane();
        this.setPreferredSize(new Dimension(300, 210));
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.setResizable(false);
        this.adjustLayout();
        this.setHostNameLabel();
        this.setUserNameLabel();
        this.setUserNameTextField();
        this.setPublicKeyLabel();
        this.setPublicKeyTextField();
        this.setPrivateKeyLabel();
        this.setPrivateKeyTextField();
        this.setActionButtonsPanel();
        this.setCancelButtonHandler();
        this.pack();
        this.setLocationRelativeTo(owner);
    }

    private void adjustLayout() {
        this.getContentPane().setPreferredSize(new Dimension(300, 210));
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{70, 150};
        gridBagLayout.rowHeights = new int[]{0, 0, 0, 0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, 0.0};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
        this.contentPane.setLayout(gridBagLayout);
    }

    private void setHostNameLabel() {
        JLabel hostLabel = new JLabel("Target host: " + this.targetHostName);
        hostLabel.setHorizontalAlignment(0);
        GridBagConstraints hostLabelConstraints = new GridBagConstraints();
        hostLabelConstraints.gridx = 0;
        hostLabelConstraints.gridy = 0;
        hostLabelConstraints.gridwidth = 2;
        hostLabelConstraints.insets = new Insets(0, 0, 7, 0);
        this.contentPane.add((Component)hostLabel, hostLabelConstraints);
    }

    private void setUserNameLabel() {
        JLabel userLabel = new JLabel("User");
        GridBagConstraints userLabelConstraints = new GridBagConstraints();
        userLabelConstraints.anchor = 13;
        userLabelConstraints.insets = new Insets(0, 0, 5, 5);
        userLabelConstraints.gridx = 0;
        userLabelConstraints.gridy = 1;
        this.contentPane.add((Component)userLabel, userLabelConstraints);
    }

    private void setUserNameTextField() {
        this.userTextField = new JTextField();
        this.userTextField.setColumns(10);
        this.userTextField.setText("");
        GridBagConstraints userTextFieldConstraints = new GridBagConstraints();
        userTextFieldConstraints.insets = new Insets(0, 0, 5, 0);
        userTextFieldConstraints.fill = 2;
        userTextFieldConstraints.gridx = 1;
        userTextFieldConstraints.gridy = 1;
        this.contentPane.add((Component)this.userTextField, userTextFieldConstraints);
    }

    private void setPublicKeyLabel() {
        JLabel publicKeyLabel = new JLabel("Public Key");
        GridBagConstraints publicKeyLabelConstraints = new GridBagConstraints();
        publicKeyLabelConstraints.anchor = 13;
        publicKeyLabelConstraints.insets = new Insets(0, 0, 5, 5);
        publicKeyLabelConstraints.gridx = 0;
        publicKeyLabelConstraints.gridy = 2;
        this.contentPane.add((Component)publicKeyLabel, publicKeyLabelConstraints);
    }

    private void setPublicKeyTextField() {
        this.publicKeyTextField = new JTextField();
        this.publicKeyTextField.setColumns(10);
        this.publicKeyTextField.setText("");
        GridBagConstraints publicKeyTextFieldConstraints = new GridBagConstraints();
        publicKeyTextFieldConstraints.insets = new Insets(0, 0, 5, 0);
        publicKeyTextFieldConstraints.fill = 2;
        publicKeyTextFieldConstraints.gridx = 1;
        publicKeyTextFieldConstraints.gridy = 2;
        this.contentPane.add((Component)this.publicKeyTextField, publicKeyTextFieldConstraints);
    }

    private void setPrivateKeyLabel() {
        JLabel privateKeyLabel = new JLabel("Private Key");
        GridBagConstraints privateKeyLabelConstraints = new GridBagConstraints();
        privateKeyLabelConstraints.anchor = 13;
        privateKeyLabelConstraints.insets = new Insets(0, 0, 10, 5);
        privateKeyLabelConstraints.gridx = 0;
        privateKeyLabelConstraints.gridy = 3;
        this.contentPane.add((Component)privateKeyLabel, privateKeyLabelConstraints);
    }

    private void setPrivateKeyTextField() {
        this.privateKeyTextField = new JTextField();
        this.privateKeyTextField.setColumns(10);
        this.privateKeyTextField.setText("");
        GridBagConstraints privateKeyTextFieldConstraints = new GridBagConstraints();
        privateKeyTextFieldConstraints.insets = new Insets(0, 0, 10, 0);
        privateKeyTextFieldConstraints.fill = 2;
        privateKeyTextFieldConstraints.gridx = 1;
        privateKeyTextFieldConstraints.gridy = 3;
        this.contentPane.add((Component)this.privateKeyTextField, privateKeyTextFieldConstraints);
    }

    private void setActionButtonsPanel() {
        JPanel actionButtonsPanel = new JPanel();
        actionButtonsPanel.setLayout(new GridLayout(0, 2, 10, 0));
        GridBagConstraints actionButtonsPanelConstraints = new GridBagConstraints();
        actionButtonsPanelConstraints.insets = new Insets(5, 0, 0, 0);
        actionButtonsPanelConstraints.gridwidth = 2;
        actionButtonsPanelConstraints.gridx = 0;
        actionButtonsPanelConstraints.gridy = 4;
        this.getContentPane().add((Component)actionButtonsPanel, actionButtonsPanelConstraints);
        this.addButton = new JButton("Add");
        actionButtonsPanel.add(this.addButton);
        this.cancelButton = new JButton("Cancel");
        actionButtonsPanel.add(this.cancelButton);
    }

    public void setUserAdditionListener(UserAdditionListener listener) {
        if (this.addUserButtonListener == null) {
            this.addUserButtonListener = e -> {
                String userName = this.userTextField.getText();
                String publicKey = this.publicKeyTextField.getText();
                String privateKey = this.privateKeyTextField.getText();
                try {
                    listener.requestAddition(this.targetHostName, userName, publicKey, privateKey);
                    this.setVisible(false);
                    this.dispose();
                }
                catch (RuntimeException ex) {
                    MessageDialog.showDialog((String)"Error adding user", (String)ex.getMessage(), (int)0);
                }
            };
        }
        this.addButton.addActionListener(this.addUserButtonListener);
    }

    public void unsetHostAdditionListener() {
        if (this.addUserButtonListener != null) {
            this.addButton.removeActionListener(this.addUserButtonListener);
        }
    }

    private void setCancelButtonHandler() {
        this.cancelButton.addActionListener(e -> {
            this.setVisible(false);
            this.dispose();
        });
    }

    public static interface UserAdditionListener {
        public void requestAddition(String var1, String var2, String var3, String var4) throws RuntimeException;
    }
}

