/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.ui.core.login;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.MouseListener;
import java.util.Optional;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.bioimageanalysis.icy.icytomine.ui.core.login.CredentialManagementTools;
import org.bioimageanalysis.icy.icytomine.ui.core.login.LoginPanelController;

public class LoginPanel
extends JPanel {
    private static final long serialVersionUID = 885665565700074663L;
    private JComboBox<String> hostComboBox;
    private CredentialManagementTools hostCredentialsManagementTools;
    private JComboBox<String> userComboBox;
    private CredentialManagementTools userCredentialsManagementTools;
    private JButton loginButton;
    private LoginPanelController controller;
    private Frame parentFrame;

    public LoginPanel(Frame parent) {
        this.parentFrame = parent;
        this.setView();
        this.setController();
    }

    public Frame getParentFrame() {
        return this.parentFrame;
    }

    private void setView() {
        this.setPreferredSize(new Dimension(400, 150));
        this.setMinimumSize(new Dimension(340, 150));
        this.setGridBagLayout();
        this.setHostServerField();
        this.setUserField();
        this.setLoginButton();
    }

    private void setGridBagLayout() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{40, 100, 110, 66};
        gridBagLayout.rowHeights = new int[]{30, 30, 25};
        gridBagLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0};
        this.setLayout(gridBagLayout);
    }

    private void setHostServerField() {
        JLabel hostLabel = new JLabel("Host");
        hostLabel.setHorizontalAlignment(4);
        GridBagConstraints hostLabelConstraints = new GridBagConstraints();
        hostLabelConstraints.fill = 2;
        hostLabelConstraints.insets = new Insets(0, 0, 10, 5);
        hostLabelConstraints.gridx = 0;
        hostLabelConstraints.gridy = 0;
        this.add((Component)hostLabel, hostLabelConstraints);
        this.hostComboBox = new JComboBox();
        hostLabel.setLabelFor(this.hostComboBox);
        GridBagConstraints hostComboBoxConstraints = new GridBagConstraints();
        hostComboBoxConstraints.insets = new Insets(0, 0, 10, 5);
        hostComboBoxConstraints.fill = 1;
        hostComboBoxConstraints.gridwidth = 2;
        hostComboBoxConstraints.gridx = 1;
        hostComboBoxConstraints.gridy = 0;
        this.add(this.hostComboBox, hostComboBoxConstraints);
        this.hostCredentialsManagementTools = new CredentialManagementTools();
        this.hostCredentialsManagementTools.setAddToolTip("Add a new host");
        this.hostCredentialsManagementTools.setRemoveToolTip("Remove current host");
        this.hostCredentialsManagementTools.setEditToolTip("Edit current host");
        GridBagConstraints hostCredentialsManagementToolsConstraints = new GridBagConstraints();
        hostCredentialsManagementToolsConstraints.anchor = 17;
        hostCredentialsManagementToolsConstraints.insets = new Insets(0, 0, 10, 0);
        hostLabelConstraints.fill = 2;
        hostLabelConstraints.insets = new Insets(0, 0, 10, 0);
        hostLabelConstraints.gridx = 3;
        hostLabelConstraints.gridy = 0;
        this.add((Component)this.hostCredentialsManagementTools, hostCredentialsManagementToolsConstraints);
    }

    private void setUserField() {
        JLabel userLabel = new JLabel("User");
        userLabel.setHorizontalAlignment(4);
        GridBagConstraints userLabelConstraints = new GridBagConstraints();
        userLabelConstraints.anchor = 13;
        userLabelConstraints.insets = new Insets(0, 0, 10, 5);
        userLabelConstraints.gridx = 0;
        userLabelConstraints.gridy = 1;
        this.add((Component)userLabel, userLabelConstraints);
        this.userComboBox = new JComboBox();
        GridBagConstraints userComboBoxConstraints = new GridBagConstraints();
        userComboBoxConstraints.gridwidth = 2;
        userComboBoxConstraints.insets = new Insets(0, 0, 10, 5);
        userComboBoxConstraints.fill = 1;
        userComboBoxConstraints.gridx = 1;
        userComboBoxConstraints.gridy = 1;
        this.add(this.userComboBox, userComboBoxConstraints);
        this.userCredentialsManagementTools = new CredentialManagementTools();
        this.userCredentialsManagementTools.setAddToolTip("Add a new user");
        this.userCredentialsManagementTools.setRemoveToolTip("Remove current user");
        this.userCredentialsManagementTools.setEditToolTip("Edit current user");
        GridBagConstraints userCredentialsManagementToolsConstraints = new GridBagConstraints();
        userCredentialsManagementToolsConstraints.anchor = 17;
        userCredentialsManagementToolsConstraints.insets = new Insets(0, 0, 10, 0);
        userLabelConstraints.anchor = 17;
        userCredentialsManagementToolsConstraints.gridx = 3;
        userCredentialsManagementToolsConstraints.gridy = 1;
        this.add((Component)this.userCredentialsManagementTools, userCredentialsManagementToolsConstraints);
    }

    private void setLoginButton() {
        this.loginButton = new JButton("Login");
        GridBagConstraints loginButtonConstraints = new GridBagConstraints();
        loginButtonConstraints.gridwidth = 4;
        loginButtonConstraints.insets = new Insets(0, 0, 0, 0);
        loginButtonConstraints.gridx = 0;
        loginButtonConstraints.gridy = 2;
        this.add((Component)this.loginButton, loginButtonConstraints);
    }

    private void setController() {
        this.controller = new LoginPanelController(this);
    }

    protected void addHostServerSelectionListener(ItemListener listener) {
        this.hostComboBox.addItemListener(listener);
    }

    protected void addLoginButtonListener(MouseListener listener) {
        this.loginButton.addMouseListener(listener);
    }

    public void addAddHostButtonListener(ActionListener listener) {
        this.hostCredentialsManagementTools.addAddButtonActionListener(listener);
    }

    public void addRemoveHostButtonListener(ActionListener listener) {
        this.hostCredentialsManagementTools.addRemoveButtonActionListener(listener);
    }

    public void addEditHostButtonListener(ActionListener listener) {
        this.hostCredentialsManagementTools.addEditButtonActionListener(listener);
    }

    public void addAddUserButtonListener(ActionListener listener) {
        this.userCredentialsManagementTools.addAddButtonActionListener(listener);
    }

    public void addRemoveUserButtonListener(ActionListener listener) {
        this.userCredentialsManagementTools.addRemoveButtonActionListener(listener);
    }

    public void addEditUserButtonListener(ActionListener listener) {
        this.userCredentialsManagementTools.addEditButtonActionListener(listener);
    }

    protected void setHosts(Set<String> hosts, Optional<String> selection) {
        this.hostComboBox.removeAllItems();
        this.userComboBox.removeAllItems();
        for (String host : hosts) {
            this.hostComboBox.addItem(host);
        }
        if (selection.isPresent()) {
            this.hostComboBox.setSelectedItem(selection.get());
        }
        this.hostComboBox.updateUI();
    }

    protected void setUsers(Set<String> users, Optional<String> selection) {
        this.userComboBox.removeAllItems();
        for (String user : users) {
            this.userComboBox.addItem(user);
        }
        if (selection.isPresent()) {
            this.userComboBox.setSelectedItem(selection.get());
        } else {
            this.userComboBox.setSelectedIndex(-1);
        }
    }

    public Optional<String> getSelectedHost() {
        return Optional.ofNullable((String)this.hostComboBox.getSelectedItem());
    }

    public Optional<String> getSelectedUser() {
        return Optional.ofNullable((String)this.userComboBox.getSelectedItem());
    }

    public void addLoginListener(LoginPanelController.LoginListener listener) {
        this.controller.addLoginListener(listener);
    }

    public void removeLoginListener(LoginPanelController.LoginListener listener) {
        this.controller.removeLoginListener(listener);
    }

    public void start() {
        this.controller.updateCredentials();
    }
}

