/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.abstractannotations.filters;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class AbstractAnnotationFilterAdditionPanel
extends JPanel {
    private static final long serialVersionUID = 4137122890897621036L;
    private JComboBox<String> filterSelector;
    private JButton btnAddFilter;
    private List<AbstractAnnotationFilterAdditionListener> filterAdditionListeners;

    public AbstractAnnotationFilterAdditionPanel() {
        this.setupUI();
        this.createListenerLists();
        this.setControlListeners();
    }

    private void setupUI() {
        this.setGridBagLayout();
        this.addFilterSelector();
        this.addAdditionButton();
    }

    private void setGridBagLayout() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0};
        gridBagLayout.columnWeights = new double[]{1.0, 0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
    }

    private void addFilterSelector() {
        this.filterSelector = new JComboBox();
        this.filterSelector.setModel(new DefaultComboBoxModel<String>(new String[]{"User", "Term"}));
        GridBagConstraints gbc_filterSelector = new GridBagConstraints();
        gbc_filterSelector.insets = new Insets(0, 0, 0, 5);
        gbc_filterSelector.fill = 2;
        gbc_filterSelector.gridx = 0;
        gbc_filterSelector.gridy = 0;
        this.add(this.filterSelector, gbc_filterSelector);
    }

    private void addAdditionButton() {
        this.btnAddFilter = new JButton("Add Filter");
        GridBagConstraints gbc_btnAddFilter = new GridBagConstraints();
        gbc_btnAddFilter.gridx = 1;
        gbc_btnAddFilter.gridy = 0;
        this.add((Component)this.btnAddFilter, gbc_btnAddFilter);
    }

    private void createListenerLists() {
        this.filterAdditionListeners = new ArrayList<AbstractAnnotationFilterAdditionListener>(1);
    }

    private void setControlListeners() {
        this.btnAddFilter.addActionListener(this::fireAnnotationFilterAddition);
    }

    private void fireAnnotationFilterAddition(ActionEvent actionevent1) {
        this.filterAdditionListeners.forEach(l -> l.filterAdditionRequested((String)this.filterSelector.getSelectedItem()));
    }

    public void addAnnotationFilterAdditionListener(AbstractAnnotationFilterAdditionListener listener) {
        this.filterAdditionListeners.add(listener);
    }

    public void removeAnnotationFilterAdditionListener(AbstractAnnotationFilterAdditionListener listener) {
        this.filterAdditionListeners.remove(listener);
    }

    public static interface AbstractAnnotationFilterAdditionListener {
        public void filterAdditionRequested(String var1);
    }
}

