/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.abstractannotations.filters;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.JPanel;
import org.bioimageanalysis.icy.icytomine.core.connection.client.CytomineClientException;
import org.bioimageanalysis.icy.icytomine.core.model.AbstractAnnotation;
import org.bioimageanalysis.icy.icytomine.core.model.Image;
import org.bioimageanalysis.icy.icytomine.core.model.Term;
import org.bioimageanalysis.icy.icytomine.core.model.User;
import org.bioimageanalysis.icy.icytomine.core.model.filters.abstrct.AbstractAnnotationFilter;
import org.bioimageanalysis.icy.icytomine.core.model.filters.abstrct.AbstractAnnotationFilterBypass;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.abstractannotations.filters.AbstractAnnotationFilterAdditionPanel;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.abstractannotations.filters.AbstractAnnotationFilterByTermPanel;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.abstractannotations.filters.AbstractAnnotationFilterByUserPanel;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.abstractannotations.filters.AbstractAnnotationFilterPanel;

public class AbstractAnnotationFilteringPanel
extends JPanel {
    private static final long serialVersionUID = -238444864338788296L;
    private GridBagLayout gridBagLayout;
    private AbstractAnnotationFilterAdditionPanel abstractAnnotationFilterAdditionPanel;
    private List<AbstractAnnotationFilterPanel<?>> addedFilterPanels;
    private JPanel panelFilters;
    private List<AbstractAnnotationFilter.AbstractAnnotationFilterUpdateListener> filterUpdateListeners;
    private LinkedList<AbstractAnnotationFilter> activeFilters;
    private Image image;

    public AbstractAnnotationFilteringPanel() {
        this.setupUI();
        this.setListenerLists();
        this.initializeFilterList();
        this.setUIListeners();
    }

    private void setupUI() {
        this.setGridBagLayout();
        this.addFilterAdditionPanel();
        this.setFilterPanelList();
        this.addFiltersPanel();
    }

    private void setGridBagLayout() {
        this.gridBagLayout = new GridBagLayout();
        this.gridBagLayout.rowWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        this.gridBagLayout.rowHeights = new int[]{0, 0, 0};
        this.gridBagLayout.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        this.gridBagLayout.columnWidths = new int[]{0, 0};
        this.setLayout(this.gridBagLayout);
    }

    private void addFilterAdditionPanel() {
        this.abstractAnnotationFilterAdditionPanel = new AbstractAnnotationFilterAdditionPanel();
        GridBagLayout gridBagLayout_1 = (GridBagLayout)this.abstractAnnotationFilterAdditionPanel.getLayout();
        gridBagLayout_1.rowHeights = new int[]{0, 0};
        GridBagConstraints gbc_abstractAnnotationFilterAdditionPanel = new GridBagConstraints();
        gbc_abstractAnnotationFilterAdditionPanel.fill = 1;
        gbc_abstractAnnotationFilterAdditionPanel.gridx = 0;
        gbc_abstractAnnotationFilterAdditionPanel.gridy = 0;
        this.add((Component)this.abstractAnnotationFilterAdditionPanel, gbc_abstractAnnotationFilterAdditionPanel);
    }

    private void setFilterPanelList() {
        this.addedFilterPanels = new ArrayList();
    }

    private void addFiltersPanel() {
        this.panelFilters = new JPanel();
        GridBagConstraints gbc_panelFilters = new GridBagConstraints();
        gbc_panelFilters.fill = 1;
        gbc_panelFilters.gridx = 0;
        gbc_panelFilters.gridy = 1;
        this.add((Component)this.panelFilters, gbc_panelFilters);
        GridBagLayout gbl_panelFilters = new GridBagLayout();
        gbl_panelFilters.columnWidths = new int[]{0};
        gbl_panelFilters.rowHeights = new int[]{1};
        gbl_panelFilters.columnWeights = new double[]{Double.MIN_VALUE};
        gbl_panelFilters.rowWeights = new double[]{Double.MIN_VALUE};
        this.panelFilters.setLayout(gbl_panelFilters);
    }

    private void setListenerLists() {
        this.filterUpdateListeners = new ArrayList<AbstractAnnotationFilter.AbstractAnnotationFilterUpdateListener>();
    }

    private void initializeFilterList() {
        this.activeFilters = new LinkedList();
        AbstractAnnotationFilterBypass firstFilter = new AbstractAnnotationFilterBypass();
        this.activeFilters.add(firstFilter);
    }

    private void setUIListeners() {
        this.abstractAnnotationFilterAdditionPanel.addAnnotationFilterAdditionListener(this::onFilterAdditionRequested);
    }

    private void onFilterAdditionRequested(String filterName) {
        AbstractAnnotationFilterPanel<?> filterPanel = this.createRequestedFilterPanel(filterName);
        filterPanel.addRemoveButtonActionListener(e -> this.removeFilterPanel(filterPanel));
        AbstractAnnotationFilter prevFilter = this.getLastFilter();
        AbstractAnnotationFilter currFilter = filterPanel.getAnnotationFilter();
        for (AbstractAnnotationFilter.AbstractAnnotationFilterUpdateListener listener : this.filterUpdateListeners) {
            prevFilter.removeAnnotationFilterUpdateListener(listener);
            currFilter.addAnnotationFilterUpdateListener(listener);
        }
        int row = this.addedFilterPanels.size();
        GridBagConstraints layoutConstraints = new GridBagConstraints();
        layoutConstraints.insets = new Insets(5, 0, 0, 0);
        layoutConstraints.fill = 2;
        layoutConstraints.gridx = 0;
        layoutConstraints.gridy = row;
        this.panelFilters.add(filterPanel, layoutConstraints);
        this.panelFilters.revalidate();
        this.updateUI();
        this.repaint();
        this.activeFilters.add(currFilter);
        this.addedFilterPanels.add(filterPanel);
    }

    private AbstractAnnotationFilterPanel<?> createRequestedFilterPanel(String filterName) {
        AbstractAnnotationFilter lastFilter = this.getLastFilter();
        switch (filterName) {
            case "User": {
                AbstractAnnotationFilterByUserPanel userFilterPanel = new AbstractAnnotationFilterByUserPanel();
                userFilterPanel.setPreviousFilter(lastFilter);
                userFilterPanel.setAvailableUsers(this.getImageUsers());
                return userFilterPanel;
            }
            case "Term": {
                AbstractAnnotationFilterByTermPanel termFilterPanel = new AbstractAnnotationFilterByTermPanel();
                termFilterPanel.setPreviousFilter(lastFilter);
                termFilterPanel.setAvailableTerms(this.getImageTerms());
                return termFilterPanel;
            }
        }
        return null;
    }

    private AbstractAnnotationFilter getLastFilter() {
        return this.activeFilters.getLast();
    }

    private void removeFilterPanel(AbstractAnnotationFilterPanel<?> filterPanel) {
        this.panelFilters.remove(filterPanel);
        filterPanel.getAnnotationFilter().disconnect();
        this.addedFilterPanels.remove(filterPanel);
        this.activeFilters.remove(filterPanel.getAnnotationFilter());
        this.revalidate();
    }

    public void setTargetImage(Image image) {
        this.image = image;
    }

    public Image getTargetImage() {
        return this.image;
    }

    private Set<User> getImageUsers() {
        try {
            return this.image == null ? Collections.emptySet() : new HashSet<User>(this.image.getProject().getUsers(false));
        }
        catch (CytomineClientException e) {
            e.printStackTrace();
            return Collections.emptySet();
        }
    }

    private Set<Term> getImageTerms() {
        try {
            return this.image == null ? Collections.emptySet() : this.image.getProject().getOntology().getTerms(false);
        }
        catch (CytomineClientException e) {
            e.printStackTrace();
            return Collections.emptySet();
        }
    }

    public void setTargetAnnotations(Set<AbstractAnnotation> targetAnnotations) {
        ((AbstractAnnotationFilterBypass)this.activeFilters.getFirst()).setActiveAnnotations(targetAnnotations);
    }

    public Set<AbstractAnnotation> getActiveAnnotations() {
        return this.getLastFilter().getActiveAnnotations(AbstractAnnotationFilter.ComputationMode.USE_LAST_RESULT);
    }

    public void addAnnotationFilterUpdateListener(AbstractAnnotationFilter.AbstractAnnotationFilterUpdateListener listener) {
        this.filterUpdateListeners.add(listener);
    }

    public void removeAnnotationFilterUpdateListener(AbstractAnnotationFilter.AbstractAnnotationFilterUpdateListener listener) {
        this.filterUpdateListeners.remove(listener);
    }
}

