/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.icy2Cytomine.folder;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.icy2Cytomine.folder.IcyFolderToCytominePanelController;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.controller.view.ViewController;

public class IcyFolderToCytominePanel
extends JPanel {
    private JLabel folderPathLabel;
    private JButton selectFolderButton;
    private JProgressBar transferProgressBar;
    private JButton sendButton;
    private JButton cancelButton;
    private IcyFolderToCytominePanelController panelController;

    public IcyFolderToCytominePanel(ViewController viewController) {
        this.setView();
        this.setController(viewController);
    }

    private void setView() {
        this.setPreferredSize(new Dimension(330, 150));
        this.setPanelLayout();
        this.addInstructions();
        this.addFolderSelection();
        this.addProgressBar();
        this.addActionPanel();
    }

    private void setPanelLayout() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0, 0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0, 0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, 1.0, 0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
    }

    private void addInstructions() {
        JLabel instructionsLabel = new JLabel("Select a folder to send the annotations on images inside that folder.");
        GridBagConstraints instructionsLabelConstraints = new GridBagConstraints();
        instructionsLabelConstraints.gridwidth = 3;
        instructionsLabelConstraints.insets = new Insets(5, 5, 5, 5);
        instructionsLabelConstraints.gridx = 0;
        instructionsLabelConstraints.gridy = 0;
        this.add((Component)instructionsLabel, instructionsLabelConstraints);
    }

    private void addFolderSelection() {
        JLabel fileLabel = new JLabel("Folder:");
        GridBagConstraints fileLabelConstraints = new GridBagConstraints();
        fileLabelConstraints.anchor = 13;
        fileLabelConstraints.insets = new Insets(0, 5, 5, 5);
        fileLabelConstraints.gridx = 0;
        fileLabelConstraints.gridy = 1;
        this.add((Component)fileLabel, fileLabelConstraints);
        this.folderPathLabel = new JLabel("No folder selected");
        GridBagConstraints filePathLabelConstraints = new GridBagConstraints();
        filePathLabelConstraints.insets = new Insets(0, 0, 5, 5);
        filePathLabelConstraints.gridx = 1;
        filePathLabelConstraints.gridy = 1;
        this.add((Component)this.folderPathLabel, filePathLabelConstraints);
        this.selectFolderButton = new JButton("Select folder...");
        GridBagConstraints selectFileButtonConstraints = new GridBagConstraints();
        selectFileButtonConstraints.anchor = 17;
        selectFileButtonConstraints.insets = new Insets(0, 0, 5, 5);
        selectFileButtonConstraints.gridx = 2;
        selectFileButtonConstraints.gridy = 1;
        this.add((Component)this.selectFolderButton, selectFileButtonConstraints);
    }

    private void addProgressBar() {
        this.transferProgressBar = new JProgressBar();
        GridBagConstraints transferProgressBarConstraints = new GridBagConstraints();
        transferProgressBarConstraints.fill = 2;
        transferProgressBarConstraints.gridwidth = 3;
        transferProgressBarConstraints.insets = new Insets(0, 5, 5, 5);
        transferProgressBarConstraints.gridx = 0;
        transferProgressBarConstraints.gridy = 2;
        this.add((Component)this.transferProgressBar, transferProgressBarConstraints);
    }

    private void addActionPanel() {
        JPanel actionPanel = new JPanel();
        GridBagConstraints actionPanelConstraints = new GridBagConstraints();
        actionPanelConstraints.gridwidth = 3;
        actionPanelConstraints.insets = new Insets(0, 5, 5, 5);
        actionPanelConstraints.fill = 2;
        actionPanelConstraints.gridx = 0;
        actionPanelConstraints.gridy = 3;
        this.add((Component)actionPanel, actionPanelConstraints);
        GridBagLayout actionPanelLayout = new GridBagLayout();
        actionPanelLayout.columnWidths = new int[]{119, 89};
        actionPanelLayout.rowHeights = new int[]{23};
        actionPanelLayout.columnWeights = new double[]{0.0, 0.0};
        actionPanelLayout.rowWeights = new double[]{0.0};
        actionPanel.setLayout(actionPanelLayout);
        this.sendButton = new JButton("Send");
        GridBagConstraints sendButtonConstraints = new GridBagConstraints();
        sendButtonConstraints.insets = new Insets(0, 0, 0, 5);
        sendButtonConstraints.gridx = 0;
        sendButtonConstraints.gridy = 0;
        actionPanel.add((Component)this.sendButton, sendButtonConstraints);
        this.cancelButton = new JButton("Cancel");
        GridBagConstraints cancelButtonConstraints = new GridBagConstraints();
        cancelButtonConstraints.anchor = 18;
        cancelButtonConstraints.gridx = 1;
        cancelButtonConstraints.gridy = 0;
        actionPanel.add((Component)this.cancelButton, cancelButtonConstraints);
    }

    private void setController(ViewController viewController) {
        if (this.panelController == null) {
            this.panelController = new IcyFolderToCytominePanelController(this, viewController);
        }
    }

    protected JLabel getFolderPathLabel() {
        return this.folderPathLabel;
    }

    protected JButton getSelectFolderButton() {
        return this.selectFolderButton;
    }

    public JProgressBar getTransferProgressBar() {
        return this.transferProgressBar;
    }

    protected JButton getSendButton() {
        return this.sendButton;
    }

    protected JButton getCancelButton() {
        return this.cancelButton;
    }

    public IcyFolderToCytominePanelController getController() {
        return this.panelController;
    }
}

