/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.UniqueVisitor;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.filter.function.ClassificationFunction;
import org.geotools.filter.function.ExplicitClassifier;
import org.geotools.filter.function.RangedClassifier;
import org.geotools.util.NullProgressListener;
import org.opengis.feature.FeatureVisitor;
import org.opengis.filter.capability.FunctionName;

public class UniqueIntervalFunction
extends ClassificationFunction {
    public static FunctionName NAME = new FunctionNameImpl("UniqueInterval", RangedClassifier.class, FunctionNameImpl.parameter("value", Double.class), FunctionNameImpl.parameter("classes", Integer.class));

    public UniqueIntervalFunction() {
        super(NAME);
    }

    private Object calculate(SimpleFeatureCollection featureCollection) {
        try {
            Set[] values;
            int classNum = this.getClasses();
            UniqueVisitor uniqueVisit = new UniqueVisitor(this.getParameters().get(0));
            if (this.progress == null) {
                this.progress = new NullProgressListener();
            }
            featureCollection.accepts((FeatureVisitor)uniqueVisit, this.progress);
            if (this.progress.isCanceled()) {
                return null;
            }
            CalcResult calcResult = uniqueVisit.getResult();
            if (calcResult == null) {
                return null;
            }
            List result = calcResult.toList();
            Collections.sort(result, new Comparator(){

                public int compare(Object o1, Object o2) {
                    if (o1 == null) {
                        if (o2 == null) {
                            return 0;
                        }
                        return -1;
                    }
                    if (o2 == null) {
                        return 1;
                    }
                    if (o1 instanceof String && o2 instanceof String) {
                        return ((String)o1).compareTo((String)o2);
                    }
                    return 0;
                }
            });
            Object[] results = result.toArray();
            if (classNum < results.length) {
                values = new Set[classNum];
                int binPop = new Double(Math.ceil((double)results.length / (double)classNum)).intValue();
                int lastBigBin = results.length % classNum;
                lastBigBin = lastBigBin == 0 ? classNum : --lastBigBin;
                int itemIndex = 0;
                for (int binIndex = 0; binIndex < classNum; ++binIndex) {
                    HashSet<Object> val = new HashSet<Object>();
                    for (int binItem = 0; binItem < binPop; ++binItem) {
                        val.add(results[itemIndex++]);
                    }
                    if (lastBigBin == binIndex) {
                        --binPop;
                    }
                    values[binIndex] = val;
                }
            } else {
                if (classNum > results.length) {
                    classNum = results.length;
                }
                values = new Set[classNum];
                for (int i = 0; i < classNum; ++i) {
                    HashSet<Object> val = new HashSet<Object>();
                    val.add(results[i]);
                    values[i] = val;
                }
            }
            return new ExplicitClassifier(values);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "UniqueIntervalFunction calculate failed", e);
            return null;
        }
    }

    @Override
    public Object evaluate(Object feature) {
        if (!(feature instanceof FeatureCollection)) {
            return null;
        }
        return this.calculate((SimpleFeatureCollection)feature);
    }
}

