/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts.coordinatesequence;

import com.vividsolutions.jts.algorithm.RobustDeterminant;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceComparator;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequence;
import java.util.ArrayList;
import java.util.List;
import org.geotools.geometry.jts.CurvedGeometry;

public class CoordinateSequences
extends com.vividsolutions.jts.geom.CoordinateSequences {
    public static boolean isCCW(CoordinateSequence ring) {
        int nPts = ring.size() - 1;
        double hiy = ring.getOrdinate(0, 1);
        int hiIndex = 0;
        for (int i = 1; i <= nPts; ++i) {
            if (!(ring.getOrdinate(i, 1) > hiy)) continue;
            hiy = ring.getOrdinate(i, 1);
            hiIndex = i;
        }
        int iPrev = hiIndex;
        do {
            if (--iPrev >= 0) continue;
            iPrev = nPts;
        } while (CoordinateSequences.equals2D(ring, iPrev, hiIndex) && iPrev != hiIndex);
        int iNext = hiIndex;
        while (CoordinateSequences.equals2D(ring, iNext = (iNext + 1) % nPts, hiIndex) && iNext != hiIndex) {
        }
        if (CoordinateSequences.equals2D(ring, iPrev, hiIndex) || CoordinateSequences.equals2D(ring, iNext, hiIndex) || CoordinateSequences.equals2D(ring, iPrev, iNext)) {
            return false;
        }
        int disc = CoordinateSequences.computeOrientation(ring, iPrev, hiIndex, iNext);
        boolean isCCW = false;
        isCCW = disc == 0 ? ring.getOrdinate(iPrev, 0) > ring.getOrdinate(iNext, 0) : disc > 0;
        return isCCW;
    }

    private static boolean equals2D(CoordinateSequence cs, int i, int j) {
        return cs.getOrdinate(i, 0) == cs.getOrdinate(j, 0) && cs.getOrdinate(i, 1) == cs.getOrdinate(j, 1);
    }

    public static int computeOrientation(CoordinateSequence cs, int p1, int p2, int q) {
        double p1x = cs.getOrdinate(p1, 0);
        double p1y = cs.getOrdinate(p1, 1);
        double p2x = cs.getOrdinate(p2, 0);
        double p2y = cs.getOrdinate(p2, 1);
        double qx = cs.getOrdinate(q, 0);
        double qy = cs.getOrdinate(q, 1);
        double dx1 = p2x - p1x;
        double dy1 = p2y - p1y;
        double dx2 = qx - p2x;
        double dy2 = qy - p2y;
        return RobustDeterminant.signOfDet2x2(dx1, dy1, dx2, dy2);
    }

    public static int coordinateDimension(Geometry g) {
        if (g instanceof CurvedGeometry) {
            return ((CurvedGeometry)g).getCoordinatesDimension();
        }
        if (g instanceof Point) {
            return CoordinateSequences.coordinateDimension(((Point)g).getCoordinateSequence());
        }
        if (g instanceof LineString) {
            return CoordinateSequences.coordinateDimension(((LineString)g).getCoordinateSequence());
        }
        if (g instanceof Polygon) {
            return CoordinateSequences.coordinateDimension(((Polygon)g).getExteriorRing().getCoordinateSequence());
        }
        CoordinateSequence cs = CoordinateSequenceFinder.find(g);
        return CoordinateSequences.coordinateDimension(cs);
    }

    public static int coordinateDimension(CoordinateSequence seq) {
        if (seq == null) {
            return 3;
        }
        int dim = seq.getDimension();
        if (dim != 3) {
            return dim;
        }
        if (seq instanceof CoordinateArraySequence && seq.size() > 0) {
            if (Double.isNaN(seq.getOrdinate(0, 1))) {
                return 1;
            }
            if (Double.isNaN(seq.getOrdinate(0, 2))) {
                return 2;
            }
        }
        return 3;
    }

    public static boolean equalsND(Geometry g1, Geometry g2) {
        int dim2;
        if (!g1.equals(g2)) {
            return false;
        }
        int dim1 = CoordinateSequences.coordinateDimension(g1);
        if (dim1 != (dim2 = CoordinateSequences.coordinateDimension(g2))) {
            return false;
        }
        if (dim1 == 2) {
            return true;
        }
        List<CoordinateSequence> sequences1 = CoordinateSequenceCollector.find(g1);
        List<CoordinateSequence> sequences2 = CoordinateSequenceCollector.find(g2);
        if (sequences1.size() != sequences2.size()) {
            return false;
        }
        CoordinateSequenceComparator comparator = new CoordinateSequenceComparator();
        for (int i = 0; i < sequences1.size(); ++i) {
            CoordinateSequence cs2;
            CoordinateSequence cs1 = sequences1.get(i);
            if (comparator.compare(cs1, cs2 = sequences2.get(i)) == 0) continue;
            return false;
        }
        return true;
    }

    private static class CoordinateSequenceCollector
    implements CoordinateSequenceFilter {
        private List<CoordinateSequence> sequences = new ArrayList<CoordinateSequence>();

        private CoordinateSequenceCollector() {
        }

        public static List<CoordinateSequence> find(Geometry g) {
            CoordinateSequenceCollector finder = new CoordinateSequenceCollector();
            g.apply(finder);
            return finder.getSequences();
        }

        public List<CoordinateSequence> getSequences() {
            return this.sequences;
        }

        @Override
        public void filter(CoordinateSequence seq, int i) {
            this.sequences.add(seq);
        }

        @Override
        public boolean isDone() {
            return false;
        }

        @Override
        public boolean isGeometryChanged() {
            return false;
        }
    }

    private static class CoordinateSequenceFinder
    implements CoordinateSequenceFilter {
        private CoordinateSequence firstSeqFound = null;

        private CoordinateSequenceFinder() {
        }

        public static CoordinateSequence find(Geometry g) {
            CoordinateSequenceFinder finder = new CoordinateSequenceFinder();
            g.apply(finder);
            return finder.getSeq();
        }

        public CoordinateSequence getSeq() {
            return this.firstSeqFound;
        }

        @Override
        public void filter(CoordinateSequence seq, int i) {
            if (this.firstSeqFound == null) {
                this.firstSeqFound = seq;
            }
        }

        @Override
        public boolean isDone() {
            return this.firstSeqFound != null;
        }

        @Override
        public boolean isGeometryChanged() {
            return false;
        }
    }
}

