/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.japura.gui.ButtonTextField;
import org.japura.gui.DefaultValueToString;
import org.japura.gui.DropDownFilteredListListener;
import org.japura.gui.ValueToString;

public class DropDownFilteredList<T> {
    private ValueToString<T> valueToString;
    private JPopupMenu popup;
    private JComponent invoker;
    private JTextField field;
    private JPanel root;
    private DropDownList<T> list;
    private DefaultListModel model;
    private Collection<T> items;
    private boolean caseSensitive;
    private List<DropDownFilteredListListener> listeners;
    private int maxVisibleRowCount = 10;
    private Filter filter = new DefaultFilter();

    public DropDownFilteredList(ButtonTextField buttonField, List<T> items) {
        this(buttonField, items, false);
    }

    public DropDownFilteredList(ButtonTextField buttonField, List<T> items, boolean caseSensitive) {
        this.invoker = buttonField;
        this.init(buttonField.getField(), items, caseSensitive);
    }

    public DropDownFilteredList(JTextField field, List<T> items) {
        this(field, items, false);
    }

    public DropDownFilteredList(JTextField field, List<T> items, boolean caseSensitive) {
        this.invoker = field;
        this.init(field, items, caseSensitive);
    }

    private void init(JTextField field, List<T> items, boolean caseSensitive) {
        this.listeners = new ArrayList<DropDownFilteredListListener>();
        this.valueToString = new DefaultValueToString();
        this.field = field;
        this.caseSensitive = caseSensitive;
        field.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                DropDownFilteredList.this.rebuildModel();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                DropDownFilteredList.this.rebuildModel();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                DropDownFilteredList.this.rebuildModel();
            }
        });
        field.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                DropDownFilteredList.this.keyListenerAction(e);
            }

            @Override
            public void keyPressed(KeyEvent e) {
                DropDownFilteredList.this.keyListenerAction(e);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                DropDownFilteredList.this.keyListenerAction(e);
            }
        });
        this.setItems(items);
    }

    private void keyListenerAction(KeyEvent e) {
        if (this.model.size() == 0 || e.getKeyCode() == 10) {
            this.getPopup().setVisible(false);
        } else if (!this.getPopup().isVisible()) {
            this.showList();
        }
        if (e.getKeyCode() == 40 || e.getKeyCode() == 38) {
            e.consume();
        }
        if (e.getKeyCode() == 40) {
            if (this.getList().getSelectedIndex() == -1 && this.model.size() > 0) {
                this.getList().setSelectedIndex(0);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DropDownFilteredList.this.getList().requestFocus();
                }
            });
        } else if (e.getKeyCode() == 27) {
            this.getPopup().setVisible(false);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DropDownFilteredList.this.getField().requestFocus();
                }
            });
        }
    }

    public void setFilter(Filter filter) {
        if (filter != null) {
            this.filter = filter;
        }
    }

    public Filter getFilter() {
        return this.filter;
    }

    public int getMaxVisibleRowCount() {
        return this.maxVisibleRowCount;
    }

    public void setMaxVisibleRowCount(int count) {
        this.maxVisibleRowCount = Math.max(1, count);
    }

    public void setValueToString(ValueToString<T> valueToString) {
        if (valueToString != null) {
            this.valueToString = valueToString;
        }
    }

    public ValueToString<T> getValueToString() {
        return this.valueToString;
    }

    public void addListener(DropDownFilteredListListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(DropDownFilteredListListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    public List<DropDownFilteredListListener> getListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    public void setItems(Collection<T> items) {
        this.items = items;
        this.getPopup().setVisible(false);
        this.rebuildModel();
        int rows = Math.min(items.size(), this.getMaxVisibleRowCount());
        this.getList().setVisibleRowCount(rows);
    }

    public ListCellRenderer getCellRenderer() {
        return this.getList().getCellRenderer();
    }

    public void setCellRenderer(ListCellRenderer cellRenderer) {
        this.getList().setCellRenderer(cellRenderer);
    }

    private void chooseSelectedListItem() {
        if (this.getList().getSelectedIndex() > -1) {
            Object item = this.getList().getSelectedValue();
            String text = this.getValueToString().valueToString(item);
            this.getField().setText(text);
            this.getPopup().setVisible(false);
            for (DropDownFilteredListListener listener : this.getListeners()) {
                listener.itemSelected(text);
            }
        }
    }

    private JTextField getField() {
        return this.field;
    }

    private JPopupMenu getPopup() {
        if (this.popup == null) {
            this.popup = new JPopupMenu();
            this.popup.add(this.getRoot());
        }
        return this.popup;
    }

    private JPanel getRoot() {
        if (this.root == null) {
            this.root = new JPanel();
            this.root.setLayout(new GridLayout(1, 1));
            JScrollPane sp = new JScrollPane(this.getList());
            sp.setBorder(null);
            this.root.add(sp);
        }
        return this.root;
    }

    private void rebuildModel() {
        String typedText = this.getField().getText();
        if (!this.caseSensitive) {
            typedText = typedText.toLowerCase();
        }
        this.model = new DefaultListModel();
        for (T item : this.items) {
            String text = this.getValueToString().valueToString(item);
            if (!this.caseSensitive) {
                text = text.toLowerCase();
            }
            if (!this.getFilter().matches(text, typedText)) continue;
            this.model.addElement(item);
        }
        this.getList().setModel(this.model);
    }

    public void showList() {
        if (this.model == null) {
            this.rebuildModel();
        }
        if (this.model.getSize() > 0) {
            this.getPopup().setPreferredSize(null);
            Dimension dim = this.getPopup().getPreferredSize();
            dim.width = this.invoker.getWidth();
            this.getPopup().setPreferredSize(dim);
            this.getPopup().show(this.invoker, 0, this.invoker.getHeight());
        }
    }

    private DropDownList<T> getList() {
        if (this.list == null) {
            this.list = new DropDownList();
            this.list.setCellRenderer(new ListRenderer());
            this.list.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
            this.list.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        DropDownFilteredList.this.chooseSelectedListItem();
                    }
                }
            });
            this.list.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 1) {
                        DropDownFilteredList.this.chooseSelectedListItem();
                    }
                }
            });
        }
        return this.list;
    }

    public static class DefaultFilter
    implements Filter {
        @Override
        public boolean matches(String itemText, String typedText) {
            return itemText.length() == 0 || itemText.indexOf(typedText) > -1;
        }
    }

    public static interface Filter {
        public boolean matches(String var1, String var2);
    }

    private class ListRenderer
    extends DefaultListCellRenderer {
        private ListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Object item = value;
            String text = DropDownFilteredList.this.getValueToString().valueToString(item);
            return super.getListCellRendererComponent(list, text, index, isSelected, cellHasFocus);
        }
    }

    private class DropDownList<E>
    extends JList<E> {
        private DropDownList() {
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }
    }
}

