/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.LinkedHashMap;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.japura.gui.Anchor;
import org.japura.gui.Gradient;

public class PaintedPanel
extends JPanel {
    private static final long serialVersionUID = -4090857463216178976L;
    private LinkedHashMap<Object, Paint> paints = new LinkedHashMap();

    public PaintedPanel() {
    }

    public PaintedPanel(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
    }

    public PaintedPanel(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
    }

    public PaintedPanel(LayoutManager layout) {
        super(layout);
    }

    public void removeBackgrounds() {
        this.paints.clear();
    }

    public void addBackground(Color color) {
        this.add(color, null);
    }

    public void removeBackground(Color color) {
        this.remove(color);
    }

    public void addBackground(Icon icon) {
        this.add(icon, null);
    }

    public void addBackground(Icon icon, Anchor anchor) {
        this.add(icon, anchor);
    }

    public void removeBackground(Icon icon) {
        this.remove(icon);
    }

    public void addBackground(Gradient gradient) {
        this.add(gradient, null);
    }

    public void removeBackground(Gradient gradient) {
        this.remove(gradient);
    }

    private void remove(Object background) {
        if (background != null) {
            this.paints.remove(background);
        }
    }

    private void add(Object background, Anchor anchor) {
        if (background != null && !this.paints.containsKey(background)) {
            if (anchor == null) {
                anchor = Anchor.CENTER;
            }
            Paint paint = new Paint();
            paint.anchor = anchor;
            paint.background = background;
            this.paints.put(background, paint);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        for (Object key : this.paints.keySet()) {
            Paint paint = this.paints.get(key);
            if (paint.background instanceof Icon) {
                this.paintIcon(paint, g);
                continue;
            }
            if (paint.background instanceof Gradient) {
                this.paintGradient((Gradient)paint.background, g);
                continue;
            }
            if (!(paint.background instanceof Color)) continue;
            this.paintColor((Color)paint.background, g);
        }
    }

    private void paintColor(Color color, Graphics g) {
        Insets insets = this.getInsets();
        Graphics2D g2d = (Graphics2D)g;
        int y = insets.top;
        int x = insets.left;
        int w = this.getWidth() - (insets.left + insets.right);
        int h = this.getHeight() - (insets.bottom + insets.top);
        g2d.setColor(color);
        g2d.fillRect(x, y, w, h);
    }

    private void paintGradient(Gradient gradient, Graphics g) {
        Insets insets = this.getInsets();
        Graphics2D g2d = (Graphics2D)g;
        GradientPaint gp = null;
        Gradient.Direction direction = gradient.getDirection();
        Color firstColor = gradient.getFirstColor();
        Color secondColor = gradient.getSecondColor();
        int y = insets.top;
        int x = insets.left;
        int w = this.getWidth() - (insets.left + insets.right);
        int h = this.getHeight() - (insets.bottom + insets.top);
        if (direction.equals((Object)Gradient.Direction.TOP_TO_BOTTOM)) {
            gp = new GradientPaint(0.0f, y, firstColor, 0.0f, h, secondColor);
        } else if (direction.equals((Object)Gradient.Direction.BOTTOM_TO_TOP)) {
            gp = new GradientPaint(0.0f, y, secondColor, 0.0f, h, firstColor);
        } else if (direction.equals((Object)Gradient.Direction.LEFT_TO_RIGHT)) {
            gp = new GradientPaint(x, 0.0f, firstColor, w, 0.0f, secondColor);
        } else if (direction.equals((Object)Gradient.Direction.RIGHT_TO_LEFT)) {
            gp = new GradientPaint(x, 0.0f, secondColor, w, 0.0f, firstColor);
        }
        g2d.setPaint(gp);
        g2d.fillRect(x, y, w, h);
    }

    private void paintIcon(Paint paint, Graphics g) {
        Insets insets = this.getInsets();
        Icon icon = (Icon)paint.background;
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        int x = 0;
        int y = 0;
        if (paint.anchor.equals((Object)Anchor.CENTER)) {
            x = (this.getWidth() - w) / 2;
            y = (this.getHeight() - h) / 2;
        } else if (paint.anchor.equals((Object)Anchor.NORTH)) {
            x = (this.getWidth() - w) / 2;
            y = insets.top;
        } else if (paint.anchor.equals((Object)Anchor.NORTH_WEST)) {
            x = insets.left;
            y = insets.top;
        } else if (paint.anchor.equals((Object)Anchor.NORTH_EAST)) {
            x = this.getWidth() - w - insets.right;
            y = insets.top;
        } else if (paint.anchor.equals((Object)Anchor.SOUTH)) {
            x = (this.getWidth() - w) / 2;
            y = this.getHeight() - h - insets.bottom;
        } else if (paint.anchor.equals((Object)Anchor.SOUTH_WEST)) {
            x = insets.left;
            y = this.getHeight() - h - insets.bottom;
        } else if (paint.anchor.equals((Object)Anchor.SOUTH_EAST)) {
            x = this.getWidth() - w - insets.right;
            y = this.getHeight() - h - insets.bottom;
        } else if (paint.anchor.equals((Object)Anchor.EAST)) {
            x = this.getWidth() - w - insets.right;
            y = (this.getHeight() - h) / 2;
        } else if (paint.anchor.equals((Object)Anchor.WEST)) {
            x = insets.left;
            y = (this.getHeight() - h) / 2;
        }
        icon.paintIcon(this, g, x, y);
    }

    private static class Paint {
        private Object background;
        private Anchor anchor;

        private Paint() {
        }
    }
}

