/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui.calendar;

import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.util.HashMap;
import org.japura.gui.calendar.DayOfWeek;

public final class CalendarProperties {
    private static CalendarProperties dcp;
    boolean getFromDefault = true;
    private HashMap<DayOfWeek, Color> dayOfWeekForegrounds;
    private HashMap<DayOfWeek, Color> dayOfWeekBackgrounds = new HashMap();
    private Insets dayOfWeekMargin;
    private Color dayOfMonthBackground;
    private Color dayOfMonthForeground;
    private Color dayOfNonCurrentMonthBackground;
    private Color dayOfNonCurrentMonthForeground;
    private Insets dayOfMonthMargin;
    private Font dayOfMonthFont;
    private Font dayOfWeekFont;
    private Color selectedDayOfMonthBackground;
    private Color selectedDayOfMonthForeground;
    private Color buttonColor;
    private Color disabledButtonColor;
    private Color mouseOverButtonColor;
    private Color monthForeground;
    private Color yearForeground;
    private Color topBarBackground;
    private Color topDayOfWeekSeparatorColor;
    private Color bottomDayOfWeekSeparatorColor;
    private DayOfWeek startDayOfWeek;

    public static CalendarProperties getDefaultCalendarProperties() {
        if (dcp == null) {
            dcp = CalendarProperties.buildCalendarProperties();
        }
        return dcp;
    }

    private static CalendarProperties buildCalendarProperties() {
        CalendarProperties cp = new CalendarProperties();
        cp.getFromDefault = false;
        Color color = new Color(50, 122, 244);
        Color color2 = new Color(0, 80, 160);
        Color color3 = new Color(0, 95, 190);
        cp.setDayOfWeekForeground(DayOfWeek.MONDAY, Color.WHITE);
        cp.setDayOfWeekForeground(DayOfWeek.TUESDAY, Color.WHITE);
        cp.setDayOfWeekForeground(DayOfWeek.WEDNESDAY, Color.WHITE);
        cp.setDayOfWeekForeground(DayOfWeek.THURSDAY, Color.WHITE);
        cp.setDayOfWeekForeground(DayOfWeek.FRIDAY, Color.WHITE);
        cp.setDayOfWeekForeground(DayOfWeek.SATURDAY, Color.WHITE);
        cp.setDayOfWeekForeground(DayOfWeek.SUNDAY, Color.WHITE);
        cp.setDayOfWeekBackground(DayOfWeek.MONDAY, color3);
        cp.setDayOfWeekBackground(DayOfWeek.TUESDAY, color3);
        cp.setDayOfWeekBackground(DayOfWeek.WEDNESDAY, color3);
        cp.setDayOfWeekBackground(DayOfWeek.THURSDAY, color3);
        cp.setDayOfWeekBackground(DayOfWeek.FRIDAY, color3);
        cp.setDayOfWeekBackground(DayOfWeek.SATURDAY, color);
        cp.setDayOfWeekBackground(DayOfWeek.SUNDAY, color);
        cp.setDayOfWeekMargin(new Insets(2, 2, 2, 2));
        cp.setDayOfMonthMargin(new Insets(2, 2, 2, 2));
        cp.setDayOfMonthBackground(Color.WHITE);
        cp.setDayOfMonthForeground(Color.BLACK);
        cp.setDayOfNonCurrentMonthBackground(Color.WHITE);
        cp.setDayOfNonCurrentMonthForeground(Color.LIGHT_GRAY);
        cp.setSelectedDayOfMonthBackground(new Color(146, 190, 255));
        cp.setSelectedDayOfMonthForeground(Color.BLACK);
        cp.setDayOfMonthFont(new Font("Dialog", 0, 12));
        cp.setDayOfWeekFont(new Font("Dialog", 1, 12));
        cp.setButtonColor(Color.WHITE);
        cp.setMouseOverButtonColor(new Color(220, 220, 255));
        cp.setDisabledButtonColor(Color.LIGHT_GRAY);
        cp.setMonthForeground(Color.WHITE);
        cp.setYearForeground(Color.WHITE);
        cp.setTopBarBackground(color2);
        cp.setTopDayOfWeekSeparatorColor(Color.WHITE);
        cp.setBottomDayOfWeekSeparatorColor(Color.BLACK);
        cp.setStartDayOfWeek(DayOfWeek.MONDAY);
        return cp;
    }

    public static void setDefaultCalendarProperties(CalendarProperties calendarProperties) {
        calendarProperties.getFromDefault = false;
        dcp = calendarProperties;
    }

    public CalendarProperties() {
        this.dayOfWeekForegrounds = new HashMap();
    }

    public void setDayOfWeekForeground(DayOfWeek dayOfWeek, Color color) {
        if (color != null) {
            this.dayOfWeekForegrounds.put(dayOfWeek, color);
        }
    }

    public void setDayOfWeekBackground(DayOfWeek dayOfWeek, Color color) {
        if (color != null) {
            this.dayOfWeekBackgrounds.put(dayOfWeek, color);
        }
    }

    public void setDayOfWeekMargin(Insets margin) {
        if (margin != null) {
            this.dayOfWeekMargin = margin = this.validateMargin(margin);
        }
    }

    private Insets validateMargin(Insets margin) {
        margin.left = Math.max(margin.left, 0);
        margin.right = Math.max(margin.right, 0);
        margin.top = Math.max(margin.top, 0);
        margin.bottom = Math.max(margin.bottom, 0);
        return margin;
    }

    public Color getDayOfWeekForeground(DayOfWeek dayOfWeek) {
        Color color = this.dayOfWeekForegrounds.get((Object)dayOfWeek);
        if (this.getFromDefault && color == null && (color = CalendarProperties.getDefaultCalendarProperties().getDayOfWeekForeground(dayOfWeek)) == null) {
            throw new RuntimeException("Null foreground color for " + dayOfWeek.name());
        }
        return color;
    }

    public Color getDayOfWeekBackground(DayOfWeek dayOfWeek) {
        Color color = this.dayOfWeekBackgrounds.get((Object)dayOfWeek);
        if (this.getFromDefault && color == null && (color = CalendarProperties.getDefaultCalendarProperties().getDayOfWeekBackground(dayOfWeek)) == null) {
            throw new RuntimeException("Null background color for " + (Object)((Object)dayOfWeek));
        }
        return color;
    }

    public Insets getDayOfWeekMargin() {
        if (this.getFromDefault && this.dayOfWeekMargin == null) {
            if (CalendarProperties.getDefaultCalendarProperties().getDayOfWeekMargin() != null) {
                return CalendarProperties.getDefaultCalendarProperties().getDayOfWeekMargin();
            }
            throw new RuntimeException("Null margin for day of week ");
        }
        return this.dayOfWeekMargin;
    }

    public Color getDayOfMonthBackground() {
        if (this.getFromDefault && this.dayOfMonthBackground == null) {
            if (CalendarProperties.getDefaultCalendarProperties().getDayOfMonthBackground() == null) {
                throw new RuntimeException("Null background color for day of month");
            }
            return CalendarProperties.getDefaultCalendarProperties().getDayOfMonthBackground();
        }
        return this.dayOfMonthBackground;
    }

    public void setDayOfMonthBackground(Color dayOfMonthBackground) {
        this.dayOfMonthBackground = dayOfMonthBackground;
    }

    public Color getDayOfMonthForeground() {
        if (this.getFromDefault && this.dayOfMonthForeground == null) {
            if (CalendarProperties.getDefaultCalendarProperties().getDayOfMonthForeground() == null) {
                throw new RuntimeException("Null foreground color for day of month");
            }
            return CalendarProperties.getDefaultCalendarProperties().getDayOfMonthForeground();
        }
        return this.dayOfMonthForeground;
    }

    public void setDayOfMonthForeground(Color dayOfMonthForeground) {
        this.dayOfMonthForeground = dayOfMonthForeground;
    }

    public Color getDayOfNonCurrentMonthBackground() {
        if (this.getFromDefault && this.dayOfNonCurrentMonthBackground == null) {
            if (CalendarProperties.getDefaultCalendarProperties().getDayOfNonCurrentMonthBackground() == null) {
                throw new RuntimeException("Null background color for day of month");
            }
            return CalendarProperties.getDefaultCalendarProperties().getDayOfNonCurrentMonthBackground();
        }
        return this.dayOfNonCurrentMonthBackground;
    }

    public void setDayOfNonCurrentMonthBackground(Color color) {
        this.dayOfNonCurrentMonthBackground = color;
    }

    public Color getDayOfNonCurrentMonthForeground() {
        if (this.getFromDefault && this.dayOfNonCurrentMonthForeground == null) {
            if (CalendarProperties.getDefaultCalendarProperties().getDayOfNonCurrentMonthForeground() == null) {
                throw new RuntimeException("Null foreground color for day of month");
            }
            return CalendarProperties.getDefaultCalendarProperties().getDayOfNonCurrentMonthForeground();
        }
        return this.dayOfNonCurrentMonthForeground;
    }

    public void setDayOfNonCurrentMonthForeground(Color color) {
        this.dayOfNonCurrentMonthForeground = color;
    }

    public Insets getDayOfMonthMargin() {
        if (this.getFromDefault && this.dayOfMonthMargin == null) {
            if (CalendarProperties.getDefaultCalendarProperties().getDayOfMonthMargin() == null) {
                throw new RuntimeException("Null margin for day of month");
            }
            return CalendarProperties.getDefaultCalendarProperties().getDayOfMonthMargin();
        }
        return this.dayOfMonthMargin;
    }

    public void setDayOfMonthMargin(Insets margin) {
        this.dayOfMonthMargin = margin = this.validateMargin(margin);
    }

    public Color getSelectedDayOfMonthBackground() {
        if (this.getFromDefault && this.selectedDayOfMonthBackground == null) {
            if (CalendarProperties.getDefaultCalendarProperties().getSelectedDayOfMonthBackground() == null) {
                throw new RuntimeException("Null background color for selected day of month");
            }
            return CalendarProperties.getDefaultCalendarProperties().getSelectedDayOfMonthBackground();
        }
        return this.selectedDayOfMonthBackground;
    }

    public void setSelectedDayOfMonthBackground(Color selectedDayOfMonthBackground) {
        this.selectedDayOfMonthBackground = selectedDayOfMonthBackground;
    }

    public Color getButtonColor() {
        if (this.getFromDefault && this.buttonColor == null) {
            if (CalendarProperties.getDefaultCalendarProperties().getButtonColor() == null) {
                throw new RuntimeException("Null button color");
            }
            return CalendarProperties.getDefaultCalendarProperties().getButtonColor();
        }
        return this.buttonColor;
    }

    public void setButtonColor(Color buttonColor) {
        this.buttonColor = buttonColor;
    }

    public Color getDisabledButtonColor() {
        if (this.getFromDefault && this.disabledButtonColor == null) {
            if (CalendarProperties.getDefaultCalendarProperties().getDisabledButtonColor() == null) {
                throw new RuntimeException("Null disabled button color");
            }
            return CalendarProperties.getDefaultCalendarProperties().getDisabledButtonColor();
        }
        return this.disabledButtonColor;
    }

    public void setDisabledButtonColor(Color color) {
        this.disabledButtonColor = color;
    }

    public Color getMouseOverButtonColor() {
        if (this.getFromDefault && this.mouseOverButtonColor == null) {
            if (CalendarProperties.getDefaultCalendarProperties().getMouseOverButtonColor() == null) {
                throw new RuntimeException("Null mouse over button color");
            }
            return CalendarProperties.getDefaultCalendarProperties().getMouseOverButtonColor();
        }
        return this.mouseOverButtonColor;
    }

    public void setMouseOverButtonColor(Color color) {
        this.mouseOverButtonColor = color;
    }

    public Color getMonthForeground() {
        if (this.getFromDefault && this.monthForeground == null) {
            if (CalendarProperties.getDefaultCalendarProperties().getMonthForeground() == null) {
                throw new RuntimeException("Null month foreground");
            }
            return CalendarProperties.getDefaultCalendarProperties().getMonthForeground();
        }
        return this.monthForeground;
    }

    public void setMonthForeground(Color monthForeground) {
        this.monthForeground = monthForeground;
    }

    public Color getYearForeground() {
        if (this.getFromDefault && this.yearForeground == null) {
            if (CalendarProperties.getDefaultCalendarProperties().getYearForeground() == null) {
                throw new RuntimeException("Null year foreground");
            }
            return CalendarProperties.getDefaultCalendarProperties().getYearForeground();
        }
        return this.yearForeground;
    }

    public void setYearForeground(Color yearForeground) {
        this.yearForeground = yearForeground;
    }

    public Color getTopBarBackground() {
        if (this.getFromDefault && this.topBarBackground == null) {
            if (CalendarProperties.getDefaultCalendarProperties().getTopBarBackground() == null) {
                throw new RuntimeException("Null top bar background");
            }
            return CalendarProperties.getDefaultCalendarProperties().getTopBarBackground();
        }
        return this.topBarBackground;
    }

    public void setTopBarBackground(Color topBarBackground) {
        this.topBarBackground = topBarBackground;
    }

    public Color getSelectedDayOfMonthForeground() {
        if (this.getFromDefault && this.selectedDayOfMonthForeground == null) {
            if (CalendarProperties.getDefaultCalendarProperties().getSelectedDayOfMonthForeground() == null) {
                throw new RuntimeException("Null foreground color for selected day of month");
            }
            return CalendarProperties.getDefaultCalendarProperties().getSelectedDayOfMonthForeground();
        }
        return this.selectedDayOfMonthForeground;
    }

    public void setSelectedDayOfMonthForeground(Color selectedDayOfMonthForeground) {
        this.selectedDayOfMonthForeground = selectedDayOfMonthForeground;
    }

    public Font getDayOfMonthFont() {
        if (this.getFromDefault && this.dayOfMonthFont == null) {
            if (CalendarProperties.getDefaultCalendarProperties().getDayOfMonthFont() == null) {
                throw new RuntimeException("Null font for day of month");
            }
            return CalendarProperties.getDefaultCalendarProperties().getDayOfMonthFont();
        }
        return this.dayOfMonthFont;
    }

    public void setDayOfMonthFont(Font dayOfMonthFont) {
        this.dayOfMonthFont = dayOfMonthFont;
    }

    public Font getDayOfWeekFont() {
        if (this.getFromDefault && this.dayOfWeekFont == null) {
            if (CalendarProperties.getDefaultCalendarProperties().getDayOfWeekFont() == null) {
                throw new RuntimeException("Null font for day of week");
            }
            return CalendarProperties.getDefaultCalendarProperties().getDayOfWeekFont();
        }
        return this.dayOfWeekFont;
    }

    public void setDayOfWeekFont(Font dayOfWeekFont) {
        this.dayOfWeekFont = dayOfWeekFont;
    }

    public Color getTopDayOfWeekSeparatorColor() {
        if (this.getFromDefault && this.topDayOfWeekSeparatorColor == null) {
            if (CalendarProperties.getDefaultCalendarProperties().getTopDayOfWeekSeparatorColor() == null) {
                throw new RuntimeException("Null separator color for top day of week");
            }
            return CalendarProperties.getDefaultCalendarProperties().getTopDayOfWeekSeparatorColor();
        }
        return this.topDayOfWeekSeparatorColor;
    }

    public void setTopDayOfWeekSeparatorColor(Color topDayOfWeekSeparatorColor) {
        this.topDayOfWeekSeparatorColor = topDayOfWeekSeparatorColor;
    }

    public Color getBottomDayOfWeekSeparatorColor() {
        if (this.getFromDefault && this.bottomDayOfWeekSeparatorColor == null) {
            if (CalendarProperties.getDefaultCalendarProperties().getBottomDayOfWeekSeparatorColor() == null) {
                throw new RuntimeException("Null separator color for bottom day of week");
            }
            return CalendarProperties.getDefaultCalendarProperties().getBottomDayOfWeekSeparatorColor();
        }
        return this.bottomDayOfWeekSeparatorColor;
    }

    public void setBottomDayOfWeekSeparatorColor(Color bottomDayOfWeekSeparatorColor) {
        this.bottomDayOfWeekSeparatorColor = bottomDayOfWeekSeparatorColor;
    }

    public DayOfWeek getStartDayOfWeek() {
        if (this.getFromDefault && this.startDayOfWeek == null) {
            if (CalendarProperties.getDefaultCalendarProperties().getStartDayOfWeek() == null) {
                throw new RuntimeException("Null start day of week");
            }
            return CalendarProperties.getDefaultCalendarProperties().getStartDayOfWeek();
        }
        return this.startDayOfWeek;
    }

    public void setStartDayOfWeek(DayOfWeek startDayOfWeek) {
        this.startDayOfWeek = startDayOfWeek;
    }
}

