/*
 * Decompiled with CFR 0.152.
 */
package plugins.danyfel80.cytomine.annotation;

import icy.plugin.abstract_.Plugin;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bioimageanalysis.icy.icytomine.core.model.AbstractAnnotation;
import org.bioimageanalysis.icy.icytomine.core.model.AlgorithmAnnotation;
import org.bioimageanalysis.icy.icytomine.core.model.Entity;
import org.bioimageanalysis.icy.icytomine.core.model.Image;
import org.bioimageanalysis.icy.icytomine.core.model.Term;
import org.bioimageanalysis.icy.icytomine.core.model.UserJob;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarGenericArray;
import plugins.adufour.vars.lang.VarString;
import vars.cytomine.VarCytomineImage;

public class GetCytomineImageAlgorithmAnnotations
extends Plugin
implements Block {
    private VarCytomineImage varInImage;
    private VarString varInUserJobIdFilter;
    private VarString varInTermNameFilter;
    private VarGenericArray<AbstractAnnotation[]> varOutAnnotations;
    private Image targetImage;
    private Set<String> userJobIds;
    private Set<String> termNames;
    private Set<AlgorithmAnnotation> targetAnnotations;

    public void declareInput(VarList inputMap) {
        this.varInImage = VarCytomineImage.ofNullable(null);
        this.varInUserJobIdFilter = new VarString("User Job ids", "");
        this.varInTermNameFilter = new VarString("Term name", "No Term");
        inputMap.add(this.varInImage.getName(), (Var)this.varInImage);
        inputMap.add(this.varInUserJobIdFilter.getName(), (Var)this.varInUserJobIdFilter);
        inputMap.add(this.varInTermNameFilter.getName(), (Var)this.varInTermNameFilter);
    }

    public void declareOutput(VarList outputMap) {
        this.varOutAnnotations = new VarGenericArray("Annotations", AbstractAnnotation[].class, (Object)new AbstractAnnotation[0]);
        outputMap.add(this.varOutAnnotations.getName(), this.varOutAnnotations);
    }

    public void run() {
        this.readParameters();
        this.computeAnnotations();
        this.setOutputValues();
    }

    private void readParameters() {
        this.targetImage = (Image)this.varInImage.getValue(true);
        this.userJobIds = Arrays.stream(((String)this.varInUserJobIdFilter.getValue(true)).toLowerCase().split(" *, *")).distinct().collect(Collectors.toSet());
        this.termNames = Arrays.stream(((String)this.varInTermNameFilter.getValue(true)).toLowerCase().split(" *, *")).filter(t -> !t.isEmpty()).distinct().map(String::toLowerCase).collect(Collectors.toSet());
    }

    private void computeAnnotations() {
        List<UserJob> userJobs = this.targetImage.getProject().getUserJobs(false);
        Set targetUserJobs = userJobs.stream().filter(u -> this.userJobIds.contains(u.getId().toString())).collect(Collectors.toSet());
        Map<Long, AlgorithmAnnotation> algoAnnotations = targetUserJobs.isEmpty() ? this.targetImage.getClient().getImageAlgorithmAnnotations(this.targetImage) : this.targetImage.getClient().getImageAlgorithmAnnotations(this.targetImage, targetUserJobs.stream().map(Entity::getId).collect(Collectors.toSet()));
        Set<Term> terms = this.targetImage.getProject().getOntology().getTerms(false);
        Set targetTerms = terms.stream().filter(t -> this.termNames.contains(t.getName().orElse("").toLowerCase())).collect(Collectors.toSet());
        boolean containsNoTerm = this.termNames.contains("No Term");
        this.targetAnnotations = algoAnnotations.values().stream().filter(a -> {
            Set<Term> aTerms = a.getAssociatedTerms();
            return this.termNames.isEmpty() || aTerms.stream().anyMatch(t -> targetTerms.contains(t)) || containsNoTerm && aTerms.isEmpty();
        }).collect(Collectors.toSet());
    }

    private void setOutputValues() {
        this.varOutAnnotations.setValue((Object)this.targetAnnotations.toArray(new AbstractAnnotation[this.targetAnnotations.size()]));
    }
}

