/*
 * Decompiled with CFR 0.152.
 */
package be.cytomine.client.collections;

import be.cytomine.client.Cytomine;
import be.cytomine.client.CytomineConnection;
import be.cytomine.client.CytomineException;
import be.cytomine.client.collections.Collection;
import be.cytomine.client.models.Job;
import be.cytomine.client.models.Model;
import be.cytomine.client.models.Project;
import be.cytomine.client.models.Software;

public class JobCollection
extends Collection<Job> {
    public JobCollection() {
        this(0, 0);
    }

    public JobCollection(int offset, int max) {
        super(Job.class, max, offset);
    }

    public static JobCollection fetchBySoftware(Software software) throws CytomineException {
        return JobCollection.fetchBySoftware(Cytomine.getInstance().getDefaultCytomineConnection(), software);
    }

    public static JobCollection fetchBySoftware(CytomineConnection connection, Software software) throws CytomineException {
        return JobCollection.fetchByDomain(connection, software, 0, 0);
    }

    public static JobCollection fetchBySoftware(Software software, int offset, int max) throws CytomineException {
        return JobCollection.fetchByDomain(Cytomine.getInstance().getDefaultCytomineConnection(), software, offset, max);
    }

    public static JobCollection fetchByProject(Project project) throws CytomineException {
        return JobCollection.fetchByProject(Cytomine.getInstance().getDefaultCytomineConnection(), project);
    }

    public static JobCollection fetchByProject(CytomineConnection connection, Project project) throws CytomineException {
        return JobCollection.fetchByDomain(connection, project, 0, 0);
    }

    public static JobCollection fetchByProject(Project project, int offset, int max) throws CytomineException {
        return JobCollection.fetchByDomain(Cytomine.getInstance().getDefaultCytomineConnection(), project, offset, max);
    }

    private static JobCollection fetchByDomain(CytomineConnection connection, Model domain, int offset, int max) throws CytomineException {
        return (JobCollection)new JobCollection(max, offset).fetchWithFilter(connection, domain.getClass(), domain.getId(), offset, max);
    }

    public static JobCollection fetchByProjectAndSoftware(Project project, Software software) throws CytomineException {
        return JobCollection.fetchByProjectAndSoftware(Cytomine.getInstance().getDefaultCytomineConnection(), project, software);
    }

    public static JobCollection fetchByProjectAndSoftware(CytomineConnection connection, Project project, Software software) throws CytomineException {
        return JobCollection.fetchByProjectAndSoftware(connection, project, software, 0, 0);
    }

    public static JobCollection fetchByProjectAndSoftware(Project project, Software software, int offset, int max) throws CytomineException {
        return JobCollection.fetchByProjectAndSoftware(Cytomine.getInstance().getDefaultCytomineConnection(), project, software, offset, max);
    }

    public static JobCollection fetchByProjectAndSoftware(CytomineConnection connection, Project project, Software software, int offset, int max) throws CytomineException {
        JobCollection sc = new JobCollection(max, offset);
        sc.addFilter(project.getDomainName(), project.getId().toString());
        sc.addFilter(software.getDomainName(), software.getId().toString());
        return (JobCollection)sc.fetch();
    }

    @Override
    protected String getJSONResourceURL() throws CytomineException {
        StringBuilder urlB = new StringBuilder("/api");
        urlB.append("/" + this.getDomainName() + ".json?");
        this.map.forEach((k, v) -> urlB.append(k + "=" + v + "&"));
        urlB.deleteCharAt(urlB.length() - 1);
        return urlB.toString();
    }
}

