/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.command;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.bioimageanalysis.icy.icytomine.command.process.CommandProcess;
import org.bioimageanalysis.icy.icytomine.command.process.CommandProcessUtil;
import org.bioimageanalysis.icy.icytomine.command.process.ConnectionCommand;
import org.bioimageanalysis.icy.icytomine.command.process.ExitCommand;
import org.bioimageanalysis.icy.icytomine.command.process.connected.ConnectedCommandProcess;
import org.bioimageanalysis.icy.icytomine.core.connection.client.CytomineClient;

public class CommandProcessor
implements Callable<Void> {
    Map<String, Class<CommandProcess<?>>> commands;
    private CytomineClient connection;
    private Object previousResult;

    public CommandProcessor() throws IOException, ClassNotFoundException {
        this.loadCommandProcessList();
    }

    private void loadCommandProcessList() throws IOException, ClassNotFoundException {
        String line;
        InputStream in = CommandProcessor.class.getResourceAsStream("/commandProcessList.txt");
        if (in == null) {
            throw new IOException("Could not find process list file");
        }
        this.commands = new HashMap();
        ClassLoader loader = CommandProcessor.class.getClassLoader();
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        while ((line = br.readLine()) != null) {
            Class<?> loadedClass = loader.loadClass(line);
            if (!CommandProcess.class.isAssignableFrom(loadedClass)) continue;
            Class<?> loadedProcessClass = loadedClass;
            try {
                this.commands.put(((CommandProcess)loadedProcessClass.newInstance()).getCommand(), loadedProcessClass);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new ClassNotFoundException("Could not get the command name for class " + loadedProcessClass.getName(), e);
            }
        }
    }

    @Override
    public Void call() throws Exception {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        while ((line = br.readLine()) != null) {
            String[] params = line.split("[ \t]+");
            if (params.length < 1) {
                System.err.println("No command received.");
                continue;
            }
            if ((params = (String[])Arrays.stream(params).map(s -> s.toLowerCase()).toArray(String[]::new))[0].equals("help")) {
                System.out.println("Commands:");
                this.commands.entrySet().stream().forEach(k -> {
                    try {
                        System.out.println(CommandProcessUtil.getCommandDescription((Class)k.getValue()));
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        throw new RuntimeException(e);
                    }
                });
                continue;
            }
            Class<CommandProcess<?>> processClass = this.commands.get(params[0]);
            if (processClass == null) {
                System.err.format("Command %s not recognized.\n", params[0]);
                continue;
            }
            CommandProcess<?> process = processClass.newInstance();
            params = (String[])Arrays.stream(params).skip(1L).toArray(String[]::new);
            process.setArguments(params);
            process.setPreviousResult(this.previousResult);
            if (process instanceof ConnectedCommandProcess) {
                if (this.connection == null) {
                    System.err.println("No cytomine server has been established.");
                    continue;
                }
                ((ConnectedCommandProcess)process).setClient(this.connection);
            }
            Object result = null;
            try {
                result = process.call();
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!(e instanceof IllegalArgumentException)) continue;
                System.err.println("usage: " + process.toString());
                continue;
            }
            if (result instanceof String) {
                System.out.println((Object)result);
            }
            if (process instanceof ConnectionCommand) {
                this.connection = result;
            } else if (process instanceof ExitCommand) break;
            this.previousResult = result;
        }
        return null;
    }
}

