/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.command.process.connected;

import java.util.Map;
import java.util.stream.Collectors;
import org.bioimageanalysis.icy.icytomine.command.process.connected.ConnectedCommandProcess;
import org.bioimageanalysis.icy.icytomine.core.model.AbstractAnnotation;
import org.bioimageanalysis.icy.icytomine.core.model.Image;

public class AnnotationsCommandProcess
extends ConnectedCommandProcess<String> {
    private static final String COMMAND = "annotations";
    private static final String NAME = "List image annotations made by users";
    private static final String[] ARGS_DESCRIPTION = new String[]{"imageID"};
    private static final String DESCRIPTION = "Lists all user annotation associated to a given image.";

    @Override
    public String getCommand() {
        return COMMAND;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String[] getArgumentsDescription() {
        return ARGS_DESCRIPTION;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public String call() throws Exception {
        if (this.getArguments().length < 1) {
            throw new IllegalArgumentException("Expected at least 1 argument but got 0");
        }
        StringBuffer annotationList = new StringBuffer();
        for (int p = 0; p < this.getArguments().length; ++p) {
            long imgId = Long.parseLong(this.getArguments()[p]);
            Image img = this.getClient().getImageInstance(imgId);
            Map<Long, AbstractAnnotation> annots = this.getClient().getImageAbstractAnnotations(img);
            annotationList.append("Annotations (ID, terms, Polygon):\n");
            for (AbstractAnnotation annot : annots.values()) {
                annotationList.append(annot.getId() + " " + annot.getAssociatedTerms().stream().map(t -> t.getName().orElse("Not specified")).collect(Collectors.toSet()) + " " + annot.getLocation().orElse("Not specified") + "\n");
            }
        }
        return annotationList.toString();
    }
}

