/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.core.connection.client;

import be.cytomine.client.Cytomine;
import be.cytomine.client.CytomineException;
import be.cytomine.client.collections.AnnotationCollection;
import be.cytomine.client.collections.Collection;
import be.cytomine.client.collections.PropertyCollection;
import be.cytomine.client.models.AbstractImage;
import be.cytomine.client.models.Annotation;
import be.cytomine.client.models.AnnotationTerm;
import be.cytomine.client.models.ImageInstance;
import be.cytomine.client.models.UserJob;
import danyfel80.common.stream.StreamUtils;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.bioimageanalysis.icy.icytomine.core.connection.client.CytomineClientException;
import org.bioimageanalysis.icy.icytomine.core.connection.client.collection.ImageServers;
import org.bioimageanalysis.icy.icytomine.core.model.AbstractAnnotation;
import org.bioimageanalysis.icy.icytomine.core.model.AlgorithmAnnotation;
import org.bioimageanalysis.icy.icytomine.core.model.Description;
import org.bioimageanalysis.icy.icytomine.core.model.Image;
import org.bioimageanalysis.icy.icytomine.core.model.Ontology;
import org.bioimageanalysis.icy.icytomine.core.model.Project;
import org.bioimageanalysis.icy.icytomine.core.model.Property;
import org.bioimageanalysis.icy.icytomine.core.model.ReviewedAnnotation;
import org.bioimageanalysis.icy.icytomine.core.model.Term;
import org.bioimageanalysis.icy.icytomine.core.model.User;
import org.bioimageanalysis.icy.icytomine.core.model.UserAnnotation;
import org.bioimageanalysis.icy.icytomine.core.model.cache.AbstractAnnotationCache;
import org.bioimageanalysis.icy.icytomine.core.model.cache.DescriptionCache;
import org.bioimageanalysis.icy.icytomine.core.model.cache.EntityCacheException;
import org.bioimageanalysis.icy.icytomine.core.model.cache.ImageInstanceCache;
import org.bioimageanalysis.icy.icytomine.core.model.cache.OntologyCache;
import org.bioimageanalysis.icy.icytomine.core.model.cache.ProjectCache;
import org.bioimageanalysis.icy.icytomine.core.model.cache.TermCache;
import org.bioimageanalysis.icy.icytomine.core.model.cache.UserCache;
import org.bioimageanalysis.icy.icytomine.core.model.cache.UserJobCache;
import org.bioimageanalysis.icy.icytomine.core.model.key.DescriptionId;
import org.bioimageanalysis.icy.icytomine.geom.WKTUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class CytomineClient
implements AutoCloseable {
    private Cytomine internalClient;
    private User currentUser;
    private UserCache userCache;
    private ProjectCache projectCache;
    private DescriptionCache descriptionCache;
    private OntologyCache ontologyCache;
    private TermCache termCache;
    private ImageInstanceCache imageInstanceCache;
    private AbstractAnnotationCache abstractAnnotationCache;
    private UserJobCache userJobCache;

    public static CytomineClient create(URL host, String publicKey, String privateKey) throws CytomineClientException {
        Cytomine client;
        try {
            Cytomine.connection(host.toString(), publicKey, privateKey);
            client = Cytomine.getInstance();
        }
        catch (CytomineException e) {
            throw new CytomineClientException(e);
        }
        CytomineClient cytomineClient = new CytomineClient(client);
        return cytomineClient;
    }

    private CytomineClient(Cytomine client) throws CytomineClientException {
        this.internalClient = client;
        this.checkCurrentUser();
    }

    private void checkCurrentUser() throws CytomineClientException {
        try {
            be.cytomine.client.models.User internalUser = this.getInternalClient().getCurrentUser();
            if (internalUser.getAttr() == null) {
                throw new CytomineClientException(String.format("User credentials not recognized for public key: %s", this.getInternalClient().getPublicKey()));
            }
        }
        catch (CytomineException e) {
            throw new CytomineClientException("Could not connect to server: " + e.getMessage(), e);
        }
    }

    protected Cytomine getInternalClient() {
        return this.internalClient;
    }

    public String getHost() {
        return this.getInternalClient().getHost();
    }

    public String getPublicKey() {
        return this.getInternalClient().getPublicKey();
    }

    public User getCurrentUser() throws CytomineClientException {
        if (this.currentUser == null) {
            this.currentUser = this.downloadCurrentUser();
            this.getUserCache().store(this.currentUser.getId(), this.currentUser);
        }
        return this.currentUser;
    }

    private User downloadCurrentUser() throws CytomineClientException {
        try {
            be.cytomine.client.models.User user = this.getInternalClient().getCurrentUser();
            if (user.getAttr() == null) {
                throw new CytomineClientException("No user data downloaded");
            }
            return new User(this, user);
        }
        catch (CytomineException e) {
            throw new CytomineClientException("Could not download user data", e);
        }
    }

    private UserCache getUserCache() {
        if (this.userCache == null) {
            this.userCache = UserCache.create(this);
        }
        return this.userCache;
    }

    public User getUser(long userId) throws CytomineClientException {
        User user;
        try {
            user = (User)this.getUserCache().retrieve(userId);
        }
        catch (EntityCacheException e) {
            user = this.downloadUser(userId);
            this.getUserCache().store(userId, user);
        }
        return user;
    }

    private User downloadUser(long userId) throws CytomineClientException {
        try {
            be.cytomine.client.models.User user = this.getInternalClient().getCurrentUser();
            if (user.getAttr() == null) {
                throw new CytomineClientException("No user data downloaded");
            }
            return new User(this, user);
        }
        catch (CytomineException e) {
            throw new CytomineClientException(String.format("Could not download user data (user id=%d)", userId), e);
        }
    }

    public List<Project> getUserProjects(long userId) throws CytomineClientException {
        Collection<be.cytomine.client.models.Project> projectCollection;
        try {
            projectCollection = Collection.fetchWithFilter(be.cytomine.client.models.Project.class, be.cytomine.client.models.User.class, userId, 0, 0);
        }
        catch (CytomineException e) {
            throw new CytomineClientException(String.format("Could not download user projects (user id=%d)", userId), e);
        }
        ArrayList<Project> projects = new ArrayList<Project>(projectCollection.size());
        for (int i = 0; i < projectCollection.size(); ++i) {
            be.cytomine.client.models.Project p = projectCollection.get(i);
            be.cytomine.client.models.Project newP = new be.cytomine.client.models.Project();
            newP.setAttr(p.getAttr());
            Project project = new Project(this, newP);
            this.getProjectCache().store(project.getId(), project);
            projects.add(project);
        }
        return projects;
    }

    public Project getProject(long projectId) throws CytomineClientException {
        Project project;
        try {
            project = (Project)this.getProjectCache().retrieve(projectId);
        }
        catch (EntityCacheException e) {
            project = this.downloadProject(projectId);
            this.getProjectCache().store(projectId, project);
        }
        return project;
    }

    private ProjectCache getProjectCache() {
        if (this.projectCache == null) {
            this.projectCache = ProjectCache.create(this);
        }
        return this.projectCache;
    }

    private Project downloadProject(long projectId) throws CytomineClientException {
        try {
            be.cytomine.client.models.Project project = (be.cytomine.client.models.Project)new be.cytomine.client.models.Project().fetch(projectId);
            if (project.getAttr() == null) {
                throw new CytomineClientException("No project data downloaded");
            }
            return new Project(this, project);
        }
        catch (CytomineException e) {
            throw new CytomineClientException(String.format("Could not download project data (project id=%d)", projectId), e);
        }
    }

    public Description getDescription(long describedEntityId, String describedDomainName) throws CytomineClientException {
        Description description;
        DescriptionId descriptionId = new DescriptionId(describedDomainName, describedEntityId);
        try {
            description = (Description)this.getDescriptionCache().retrieve(descriptionId);
        }
        catch (EntityCacheException e) {
            description = this.downloadDescription(descriptionId);
            this.getDescriptionCache().store(descriptionId, description);
        }
        return description;
    }

    private DescriptionCache getDescriptionCache() {
        if (this.descriptionCache == null) {
            this.descriptionCache = DescriptionCache.create(this);
        }
        return this.descriptionCache;
    }

    private Description downloadDescription(DescriptionId descriptionId) throws CytomineClientException {
        try {
            be.cytomine.client.models.Description description = this.getInternalClient().getDescription(descriptionId.getDescribedEntityId(), descriptionId.getDescribedDomainName());
            if (description.getAttr() == null) {
                throw new CytomineClientException("No description data downloaded");
            }
            return new Description(this, description);
        }
        catch (CytomineException e) {
            throw new CytomineClientException(String.format("Could not download description data (description key=%s)", descriptionId), e);
        }
    }

    public List<User> getProjectUsers(long projectId) throws CytomineClientException {
        Collection<be.cytomine.client.models.User> userCollection;
        try {
            userCollection = Collection.fetchWithFilter(be.cytomine.client.models.User.class, be.cytomine.client.models.Project.class, projectId, 0, 0);
        }
        catch (CytomineException e) {
            throw new CytomineClientException(String.format("Could not download project users (project id=%d)", projectId), e);
        }
        ArrayList<User> users = new ArrayList<User>(userCollection.size());
        for (int i = 0; i < userCollection.size(); ++i) {
            be.cytomine.client.models.User userIn = userCollection.get(i);
            be.cytomine.client.models.User newUserIn = new be.cytomine.client.models.User();
            newUserIn.setAttr(userIn.getAttr());
            User user = new User(this, newUserIn);
            this.getUserCache().store(user.getId(), user);
            users.add(user);
        }
        return users;
    }

    public Ontology getOntology(long ontologyId) throws CytomineClientException {
        Ontology ontology;
        try {
            ontology = (Ontology)this.getOntologyCache().retrieve(ontologyId);
        }
        catch (EntityCacheException e) {
            ontology = this.downloadOntology(ontologyId);
            this.getOntologyCache().store(ontologyId, ontology);
        }
        return ontology;
    }

    private OntologyCache getOntologyCache() {
        if (this.ontologyCache == null) {
            this.ontologyCache = OntologyCache.create(this);
        }
        return this.ontologyCache;
    }

    private Ontology downloadOntology(long ontologyId) throws CytomineClientException {
        try {
            be.cytomine.client.models.Ontology ontology = (be.cytomine.client.models.Ontology)new be.cytomine.client.models.Ontology().fetch(ontologyId);
            if (ontology.getAttr() == null) {
                throw new CytomineClientException("No ontology data downloaded");
            }
            return new Ontology(this, ontology);
        }
        catch (CytomineException e) {
            throw new CytomineClientException(String.format("Could not download ontology data (ontology id=%d)", ontologyId), e);
        }
    }

    public Set<Term> getOntologyTerms(long ontologyId) throws CytomineClientException {
        Collection<be.cytomine.client.models.Term> termCollection;
        try {
            termCollection = Collection.fetchWithFilter(be.cytomine.client.models.Term.class, be.cytomine.client.models.Ontology.class, ontologyId, 0, 0);
        }
        catch (CytomineException e) {
            throw new CytomineClientException(String.format("Could not download ontology terms (ontology id=%d)", ontologyId), e);
        }
        HashSet<Term> terms = new HashSet<Term>(termCollection.size());
        for (int i = 0; i < termCollection.size(); ++i) {
            be.cytomine.client.models.Term inTerm = termCollection.get(i);
            be.cytomine.client.models.Term newInTerm = new be.cytomine.client.models.Term();
            newInTerm.setAttr(inTerm.getAttr());
            Term term = new Term(this, newInTerm);
            this.getTermCache().store(term.getId(), term);
            terms.add(term);
        }
        return terms;
    }

    private TermCache getTermCache() {
        if (this.termCache == null) {
            this.termCache = TermCache.create(this);
        }
        return this.termCache;
    }

    public Term getTerm(long termId) throws CytomineClientException {
        Term term;
        try {
            term = (Term)this.getTermCache().retrieve(termId);
        }
        catch (EntityCacheException e) {
            term = this.downloadTerm(termId);
            this.getTermCache().store(termId, term);
        }
        return term;
    }

    private Term downloadTerm(long termId) throws CytomineClientException {
        try {
            be.cytomine.client.models.Term term = (be.cytomine.client.models.Term)new be.cytomine.client.models.Term().fetch(termId);
            if (term.getAttr() == null) {
                throw new CytomineClientException("No term data downloaded");
            }
            return new Term(this, term);
        }
        catch (CytomineException e) {
            throw new CytomineClientException(String.format("Could not download term data (term id=%d)", termId), e);
        }
    }

    public List<Image> getProjectImages(long projectId) throws CytomineClientException {
        Collection<ImageInstance> imageInstanceCollection;
        try {
            imageInstanceCollection = Collection.fetchWithFilter(ImageInstance.class, be.cytomine.client.models.Project.class, projectId, 0, 0);
        }
        catch (CytomineException e) {
            throw new CytomineClientException(String.format("Could not download project images (project id=%d)", projectId), e);
        }
        ArrayList<Image> images = new ArrayList<Image>(imageInstanceCollection.size());
        for (int i = 0; i < imageInstanceCollection.size(); ++i) {
            ImageInstance inImage = imageInstanceCollection.get(i);
            ImageInstance newInImage = new ImageInstance();
            newInImage.setAttr(inImage.getAttr());
            Image image = new Image(this, newInImage);
            this.getImageCache().store(image.getId(), image);
            images.add(image);
        }
        return images;
    }

    private ImageInstanceCache getImageCache() {
        if (this.imageInstanceCache == null) {
            this.imageInstanceCache = ImageInstanceCache.create(this);
        }
        return this.imageInstanceCache;
    }

    public Image getImageInstance(long imageInstanceId) throws CytomineClientException {
        Image image;
        try {
            image = (Image)this.getImageCache().retrieve(imageInstanceId);
        }
        catch (EntityCacheException e) {
            image = this.downloadImage(imageInstanceId);
            this.getImageCache().store(imageInstanceId, image);
        }
        return image;
    }

    private Image downloadImage(long imageInstanceId) throws CytomineClientException {
        ImageInstance imageInstance;
        try {
            imageInstance = (ImageInstance)new ImageInstance().fetch(imageInstanceId);
        }
        catch (CytomineException e) {
            throw new CytomineClientException(String.format("Could not download image instance data (image instance id=%d)", imageInstanceId), e);
        }
        if (imageInstance.getAttr() == null) {
            throw new CytomineClientException("No image instance data downloaded");
        }
        return new Image(this, imageInstance);
    }

    public List<String> getImageServers(Image image) throws CytomineClientException {
        JSONArray serverJSONArray;
        try {
            AbstractImage abstractImage = new AbstractImage();
            abstractImage.set("id", image.getInternalImage().get("baseImage"));
            Collection<ImageServers> servers = new Collection<ImageServers>(ImageServers.class, 0, 0);
            servers.addFilter("abstractimage", "" + abstractImage.getId());
            JSONObject answer = Cytomine.getInstance().getDefaultCytomineConnection().doGet(servers.toURL());
            serverJSONArray = answer.getOrDefault("imageServersURLs", new JSONArray());
        }
        catch (CytomineException e) {
            throw new CytomineClientException(String.format("Could not download image servers (image=%s)", image.toString()), e);
        }
        List<String> serverList = serverJSONArray.stream().map(s -> s.toString().replace(" ", "%20")).collect(Collectors.toList());
        return serverList;
    }

    public BufferedImage downloadImageAsBufferedImage(long imageInstanceId) throws CytomineClientException {
        try {
            String url = this.getHost() + "/api/abstractimage/" + imageInstanceId + "/thumb.png?maxSize=256";
            return this.getInternalClient().getDefaultCytomineConnection().getPictureAsBufferedImage(url, "png");
        }
        catch (CytomineException e) {
            throw new CytomineClientException(String.format("Could not download image as buffered image (abstract image id=%d)", imageInstanceId), e);
        }
    }

    public UserAnnotation addUserAnnotationWithTerms(Long imageId, String geometryDescription, List<Long> termIds) {
        Annotation internalAnnotation;
        try {
            internalAnnotation = (Annotation)new Annotation(geometryDescription, imageId, termIds).save();
        }
        catch (CytomineException e) {
            throw new CytomineClientException("Could not create annotation.", e);
        }
        UserAnnotation annotation = new UserAnnotation(this, internalAnnotation);
        this.getAbstractAnnotationCache().store(annotation.getId(), annotation);
        return annotation;
    }

    public Map<Long, AbstractAnnotation> getImageAbstractAnnotationsWithGeometry(Image image, boolean recompute) {
        Map<Long, AbstractAnnotation> requestedImageAnnotations = this.getImageAbstractAnnotations(image);
        long annotationsWithoutGeometryCount = requestedImageAnnotations.values().stream().filter(a -> !a.getLocation().isPresent()).count();
        if (annotationsWithoutGeometryCount > 0L || recompute) {
            Map<Long, AbstractAnnotation> geometryAnnotations = this.getImageAbstractAnnotationGeometries(image);
            requestedImageAnnotations.values().stream().forEach(StreamUtils.wrapConsumer(a -> {
                AbstractAnnotation geomAnnotation = (AbstractAnnotation)geometryAnnotations.get(a.getId());
                a.getInternalAnnotation().set("location", geomAnnotation.getInternalAnnotation().get("location"));
            }));
        }
        return requestedImageAnnotations;
    }

    public Map<Long, AbstractAnnotation> getImageAbstractAnnotations(Image image) throws CytomineClientException {
        HashMap<Long, AbstractAnnotation> annotations = new HashMap<Long, AbstractAnnotation>();
        annotations.putAll(this.getImageUserAnnotations(image));
        annotations.putAll(this.getImageAlgorithmAnnotations(image));
        annotations.putAll(this.getImageReviewedAnnotations(image));
        return annotations;
    }

    public Map<Long, UserAnnotation> getImageUserAnnotations(Image image) throws CytomineClientException {
        List<User> users = image.getProject().getUsers(false);
        if (users == null || users.isEmpty()) {
            return new HashMap<Long, UserAnnotation>(0);
        }
        Set<Long> userIds = users.stream().filter(Objects::nonNull).map(u -> u.getId()).collect(Collectors.toSet());
        return this.getImageUserAnnotations(image, userIds);
    }

    public Map<Long, UserAnnotation> getImageUserAnnotations(Image image, Set<Long> userIds) throws CytomineClientException {
        AnnotationCollection annotationCollection;
        if (userIds == null || userIds.isEmpty()) {
            return new HashMap<Long, UserAnnotation>(0);
        }
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("images", image.getId());
            parameters.put("users", userIds.stream().filter(Objects::nonNull).map(u -> u.toString()).collect(Collectors.joining(",")));
            annotationCollection = AnnotationCollection.fetchWithParameters(parameters);
        }
        catch (CytomineException e) {
            throw new CytomineClientException(String.format("Could not download image annotations (image instance id=%d)", image.getId()), e);
        }
        HashMap<Long, UserAnnotation> foundAnnotations = new HashMap<Long, UserAnnotation>();
        for (int i = 0; i < annotationCollection.size(); ++i) {
            UserAnnotation a = new UserAnnotation(this, (Annotation)annotationCollection.get(i));
            this.getAbstractAnnotationCache().store(a.getId(), a);
            foundAnnotations.put(a.getId(), a);
        }
        return foundAnnotations;
    }

    public Map<Long, AlgorithmAnnotation> getImageAlgorithmAnnotations(Image image) throws CytomineClientException {
        List<org.bioimageanalysis.icy.icytomine.core.model.UserJob> jobs = image.getProject().getUserJobs(false);
        if (jobs.isEmpty()) {
            return new HashMap<Long, AlgorithmAnnotation>(0);
        }
        Set<Long> jobIds = jobs.stream().filter(Objects::nonNull).map(u -> u.getId()).collect(Collectors.toSet());
        return this.getImageAlgorithmAnnotations(image, jobIds);
    }

    public Map<Long, AlgorithmAnnotation> getImageAlgorithmAnnotations(Image image, Set<Long> userJobIds) {
        AnnotationCollection annotationCollection;
        if (userJobIds == null || userJobIds.isEmpty()) {
            return new HashMap<Long, AlgorithmAnnotation>(0);
        }
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("images", image.getId());
            String jobsString = userJobIds.stream().filter(Objects::nonNull).map(u -> u.toString()).collect(Collectors.joining(","));
            parameters.put("users", jobsString);
            annotationCollection = AnnotationCollection.fetchWithParameters(parameters);
        }
        catch (CytomineException e) {
            throw new CytomineClientException(String.format("Could not download image annotations (image instance id=%d)", image.getId()), e);
        }
        HashMap<Long, AlgorithmAnnotation> foundAnnotations = new HashMap<Long, AlgorithmAnnotation>();
        for (int i = 0; i < annotationCollection.size(); ++i) {
            AlgorithmAnnotation a = new AlgorithmAnnotation(this, (Annotation)annotationCollection.get(i));
            this.getAbstractAnnotationCache().store(a.getId(), a);
            foundAnnotations.put(a.getId(), a);
        }
        return foundAnnotations;
    }

    public Map<Long, ReviewedAnnotation> getImageReviewedAnnotations(Image image) throws CytomineClientException {
        List<User> users = image.getProject().getUsers(false);
        if (users == null || users.isEmpty()) {
            return new HashMap<Long, ReviewedAnnotation>(0);
        }
        Set<Long> reviewUserIds = users.stream().filter(Objects::nonNull).map(u -> u.getId()).collect(Collectors.toSet());
        return this.getImageReviewedAnnotations(image, reviewUserIds);
    }

    public Map<Long, ReviewedAnnotation> getImageReviewedAnnotations(Image image, Set<Long> reviewUserIds) throws CytomineClientException {
        AnnotationCollection annotationCollection;
        if (reviewUserIds == null || reviewUserIds.isEmpty()) {
            return new HashMap<Long, ReviewedAnnotation>(0);
        }
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("images", image.getId());
            parameters.put("reviewed", true);
            String usersString = reviewUserIds.stream().filter(Objects::nonNull).map(u -> u.toString()).collect(Collectors.joining(","));
            parameters.put("reviewUsers", usersString);
            annotationCollection = AnnotationCollection.fetchWithParameters(parameters);
        }
        catch (CytomineException e) {
            throw new CytomineClientException(String.format("Could not download image annotations (image instance id=%d)", image.getId()), e);
        }
        HashMap<Long, ReviewedAnnotation> foundAnnotations = new HashMap<Long, ReviewedAnnotation>();
        for (int i = 0; i < annotationCollection.size(); ++i) {
            ReviewedAnnotation a = new ReviewedAnnotation(this, (Annotation)annotationCollection.get(i));
            this.getAbstractAnnotationCache().store(a.getId(), a);
            foundAnnotations.put(a.getId(), a);
        }
        return foundAnnotations;
    }

    private AbstractAnnotationCache getAbstractAnnotationCache() {
        if (this.abstractAnnotationCache == null) {
            this.abstractAnnotationCache = AbstractAnnotationCache.create(this);
        }
        return this.abstractAnnotationCache;
    }

    public AbstractAnnotation getAbstractAnnotation(long annotationId) {
        AbstractAnnotation annotation;
        try {
            annotation = (AbstractAnnotation)this.getAbstractAnnotationCache().retrieve(annotationId);
        }
        catch (EntityCacheException e) {
            annotation = this.downloadAbstractAnnotation(annotationId);
            this.getAbstractAnnotationCache().store(annotationId, annotation);
        }
        return annotation;
    }

    public AbstractAnnotation downloadAbstractAnnotation(long annotationId) {
        AbstractAnnotation abstractAnnotation;
        Annotation annotation;
        try {
            annotation = (Annotation)new Annotation().fetch(annotationId);
        }
        catch (CytomineException e) {
            throw new CytomineClientException(String.format("Could not download annotation data (annotation id=%d)", annotationId), e);
        }
        if (annotation.getAttr() == null) {
            throw new CytomineClientException("No annotation data downloaded");
        }
        switch (annotation.getStr("class")) {
            case "be.cytomine.ontology.UserAnnotation": {
                abstractAnnotation = new UserAnnotation(this, annotation);
                break;
            }
            case "be.cytomine.ontology.AlgoAnnotation": {
                abstractAnnotation = new AlgorithmAnnotation(this, annotation);
                break;
            }
            case "be.cytomine.ontology.ReviewedAnnotation": {
                abstractAnnotation = new ReviewedAnnotation(this, annotation);
                break;
            }
            default: {
                throw new CytomineClientException("Annotation with Id " + annotationId + " is of incompatible type " + annotation.getStr("class"));
            }
        }
        return abstractAnnotation;
    }

    public Map<Long, AbstractAnnotation> getImageAbstractAnnotationGeometries(Image image) {
        HashMap<Long, AbstractAnnotation> annotations = new HashMap<Long, AbstractAnnotation>();
        annotations.putAll(this.getImageUserAnnotationGeometries(image));
        annotations.putAll(this.getImageAlgorithmAnnotationGeometries(image));
        annotations.putAll(this.getImageReviewedAnnotationGeometries(image));
        return annotations;
    }

    public Map<Long, UserAnnotation> getImageUserAnnotationGeometries(Image image) {
        List<User> users = image.getProject().getUsers(false);
        if (users == null || users.isEmpty()) {
            return new HashMap<Long, UserAnnotation>(0);
        }
        return this.getImageUserAnnotationGeometries(image, users.stream().map(u -> u.getId()).collect(Collectors.toSet()));
    }

    public Map<Long, UserAnnotation> getImageUserAnnotationGeometries(Image image, Set<Long> userIds) {
        AnnotationCollection annotationCollection;
        if (userIds == null || userIds.isEmpty()) {
            return new HashMap<Long, UserAnnotation>(0);
        }
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("images", image.getId());
            parameters.put("users", userIds.stream().filter(Objects::nonNull).map(u -> u.toString()).collect(Collectors.joining(",")));
            parameters.put("showWKT", "true");
            annotationCollection = AnnotationCollection.fetchWithParameters(parameters);
        }
        catch (CytomineException e) {
            throw new CytomineClientException(String.format("Could not download image annotation geometries (image instance id=%d)", image.getId()), e);
        }
        HashMap<Long, UserAnnotation> foundAnnotations = new HashMap<Long, UserAnnotation>();
        for (int i = 0; i < annotationCollection.size(); ++i) {
            UserAnnotation a = new UserAnnotation(this, (Annotation)annotationCollection.get(i));
            foundAnnotations.put(a.getId(), a);
        }
        return foundAnnotations;
    }

    public Map<Long, AlgorithmAnnotation> getImageAlgorithmAnnotationGeometries(Image image) {
        List<org.bioimageanalysis.icy.icytomine.core.model.UserJob> userJobs = image.getProject().getUserJobs(false);
        if (userJobs.isEmpty()) {
            return new HashMap<Long, AlgorithmAnnotation>(0);
        }
        return this.getImageAlgorithmAnnotationGeometries(image, userJobs.stream().map(uj -> uj.getId()).collect(Collectors.toSet()));
    }

    public Map<Long, AlgorithmAnnotation> getImageAlgorithmAnnotationGeometries(Image image, Set<Long> userJobIds) {
        AnnotationCollection annotationCollection;
        if (userJobIds == null || userJobIds.isEmpty()) {
            return new HashMap<Long, AlgorithmAnnotation>(0);
        }
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("images", image.getId());
            String jobsString = userJobIds.stream().filter(Objects::nonNull).map(u -> u.toString()).collect(Collectors.joining(","));
            parameters.put("users", jobsString);
            parameters.put("showWKT", "true");
            annotationCollection = AnnotationCollection.fetchWithParameters(parameters);
        }
        catch (CytomineException e) {
            throw new CytomineClientException(String.format("Could not download image annotations (image instance id=%d)", image.getId()), e);
        }
        HashMap<Long, AlgorithmAnnotation> foundAnnotations = new HashMap<Long, AlgorithmAnnotation>();
        for (int i = 0; i < annotationCollection.size(); ++i) {
            AlgorithmAnnotation a = new AlgorithmAnnotation(this, (Annotation)annotationCollection.get(i));
            foundAnnotations.put(a.getId(), a);
        }
        return foundAnnotations;
    }

    public Map<Long, ReviewedAnnotation> getImageReviewedAnnotationGeometries(Image image) {
        List<User> users = image.getProject().getUsers(false);
        if (users == null || users.isEmpty()) {
            return new HashMap<Long, ReviewedAnnotation>(0);
        }
        return this.getImageReviewedAnnotationGeometries(image, users.stream().map(u -> u.getId()).collect(Collectors.toSet()));
    }

    public Map<Long, ReviewedAnnotation> getImageReviewedAnnotationGeometries(Image image, Set<Long> reviewUserIds) {
        AnnotationCollection annotationCollection;
        if (reviewUserIds == null || reviewUserIds.isEmpty()) {
            return new HashMap<Long, ReviewedAnnotation>(0);
        }
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("images", image.getId());
            parameters.put("reviewed", true);
            String usersString = reviewUserIds.stream().filter(Objects::nonNull).map(u -> u.toString()).collect(Collectors.joining(","));
            parameters.put("reviewUsers", usersString);
            parameters.put("showWKT", "true");
            annotationCollection = AnnotationCollection.fetchWithParameters(parameters);
        }
        catch (CytomineException e) {
            throw new CytomineClientException(String.format("Could not download image annotations (image instance id=%d)", image.getId()), e);
        }
        HashMap<Long, ReviewedAnnotation> foundAnnotations = new HashMap<Long, ReviewedAnnotation>();
        for (int i = 0; i < annotationCollection.size(); ++i) {
            ReviewedAnnotation a = new ReviewedAnnotation(this, (Annotation)annotationCollection.get(i));
            foundAnnotations.put(a.getId(), a);
        }
        return foundAnnotations;
    }

    public Map<Long, AbstractAnnotation> getImageAbstractAnnotationsAt(Long imageId, Rectangle2D imageArea) throws CytomineClientException {
        HashMap<Long, AbstractAnnotation> annotations = new HashMap<Long, AbstractAnnotation>();
        annotations.putAll(this.getImageUserAnnotationsAt(imageId, imageArea));
        annotations.putAll(this.getImageAlgorithmAnnotationsAt(imageId, imageArea));
        annotations.putAll(this.getImageReviewedAnnotationsAt(imageId, imageArea));
        return annotations;
    }

    public Map<Long, UserAnnotation> getImageUserAnnotationsAt(Long imageId, Rectangle2D imageArea) {
        Image image = this.getImageInstance(imageId);
        List<User> users = image.getProject().getUsers(false);
        if (users == null || users.isEmpty()) {
            return new HashMap<Long, UserAnnotation>(0);
        }
        return this.getImageUserAnnotationsAt(imageId, users.stream().map(u -> u.getId()).collect(Collectors.toSet()), imageArea);
    }

    public Map<Long, UserAnnotation> getImageUserAnnotationsAt(Long imageId, Set<Long> userIds, Rectangle2D imageArea) {
        AnnotationCollection annotationCollection;
        if (userIds == null || userIds.isEmpty() || imageArea == null) {
            return new HashMap<Long, UserAnnotation>(0);
        }
        try {
            Image image = this.getImageInstance(imageId);
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("images", image.getId());
            parameters.put("users", userIds.stream().filter(Objects::nonNull).map(u -> u.toString()).collect(Collectors.joining(",")));
            parameters.put("bbox", WKTUtils.createFromRectangle2D(imageArea).replace(" ", "%20"));
            annotationCollection = AnnotationCollection.fetchWithParameters(parameters);
        }
        catch (CytomineException e) {
            throw new CytomineClientException(String.format("Could not download image annotation geometries (image instance id=%d)", imageId), e);
        }
        HashMap<Long, UserAnnotation> foundAnnotations = new HashMap<Long, UserAnnotation>();
        for (int i = 0; i < annotationCollection.size(); ++i) {
            UserAnnotation a = new UserAnnotation(this, (Annotation)annotationCollection.get(i));
            foundAnnotations.put(a.getId(), a);
        }
        return foundAnnotations;
    }

    public Map<Long, AlgorithmAnnotation> getImageAlgorithmAnnotationsAt(Long imageId, Rectangle2D imageArea) {
        Image image = this.getImageInstance(imageId);
        List<org.bioimageanalysis.icy.icytomine.core.model.UserJob> userJobs = image.getProject().getUserJobs(false);
        if (userJobs.isEmpty()) {
            return new HashMap<Long, AlgorithmAnnotation>(0);
        }
        return this.getImageAlgorithmAnnotationsAt(imageId, userJobs.stream().map(uj -> uj.getId()).collect(Collectors.toSet()), imageArea);
    }

    public Map<Long, AlgorithmAnnotation> getImageAlgorithmAnnotationsAt(Long imageId, Set<Long> userJobIds, Rectangle2D imageArea) {
        AnnotationCollection annotationCollection;
        if (userJobIds == null || userJobIds.isEmpty() || imageArea == null) {
            return new HashMap<Long, AlgorithmAnnotation>(0);
        }
        Image image = this.getImageInstance(imageId);
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("images", image.getId());
            String jobsString = userJobIds.stream().filter(Objects::nonNull).map(u -> u.toString()).collect(Collectors.joining(","));
            parameters.put("users", jobsString);
            parameters.put("bbox", WKTUtils.createFromRectangle2D(imageArea).replace(" ", "%20"));
            annotationCollection = AnnotationCollection.fetchWithParameters(parameters);
        }
        catch (CytomineException e) {
            throw new CytomineClientException(String.format("Could not download image annotations (image instance id=%d)", image.getId()), e);
        }
        HashMap<Long, AlgorithmAnnotation> foundAnnotations = new HashMap<Long, AlgorithmAnnotation>();
        for (int i = 0; i < annotationCollection.size(); ++i) {
            AlgorithmAnnotation a = new AlgorithmAnnotation(this, (Annotation)annotationCollection.get(i));
            foundAnnotations.put(a.getId(), a);
        }
        return foundAnnotations;
    }

    public Map<Long, ReviewedAnnotation> getImageReviewedAnnotationsAt(Long imageId, Rectangle2D imageArea) {
        Image image = this.getImageInstance(imageId);
        List<User> users = image.getProject().getUsers(false);
        if (users == null || users.isEmpty()) {
            return new HashMap<Long, ReviewedAnnotation>(0);
        }
        return this.getImageReviewedAnnotationsAt(imageId, users.stream().map(u -> u.getId()).collect(Collectors.toSet()), imageArea);
    }

    public Map<Long, ReviewedAnnotation> getImageReviewedAnnotationsAt(Long imageId, Set<Long> reviewUserIds, Rectangle2D imageArea) {
        AnnotationCollection annotationCollection;
        if (reviewUserIds == null || reviewUserIds.isEmpty() || imageArea == null) {
            return new HashMap<Long, ReviewedAnnotation>(0);
        }
        try {
            Image image = this.getImageInstance(imageId);
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("images", image.getId());
            parameters.put("reviewed", true);
            parameters.put("reviewUsers", reviewUserIds.stream().filter(Objects::nonNull).map(u -> u.toString()).collect(Collectors.joining(",")));
            parameters.put("bbox", WKTUtils.createFromRectangle2D(imageArea).replace(" ", "%20"));
            annotationCollection = AnnotationCollection.fetchWithParameters(parameters);
        }
        catch (CytomineException e) {
            throw new CytomineClientException(String.format("Could not download image annotation geometries (image instance id=%d)", imageId), e);
        }
        HashMap<Long, ReviewedAnnotation> foundAnnotations = new HashMap<Long, ReviewedAnnotation>();
        for (int i = 0; i < annotationCollection.size(); ++i) {
            ReviewedAnnotation a = new ReviewedAnnotation(this, (Annotation)annotationCollection.get(i));
            foundAnnotations.put(a.getId(), a);
        }
        return foundAnnotations;
    }

    public List<Property> getAbstractAnnotationProperties(AbstractAnnotation annotation) throws CytomineClientException {
        PropertyCollection propertyList;
        try {
            propertyList = this.getInternalClient().getDomainProperties("annotation", annotation.getId());
        }
        catch (CytomineException e) {
            throw new CytomineClientException(String.format("Could not retrieve annotation %d properties", annotation.getId()), e);
        }
        ArrayList<Property> properties = new ArrayList<Property>(propertyList.size());
        for (int i = 0; i < propertyList.size(); ++i) {
            properties.add(new Property(this, (be.cytomine.client.models.Property)propertyList.get(i)));
        }
        return properties;
    }

    public void associateTermsToAnnotation(AbstractAnnotation annotation, Map<Term, Boolean> termSelection) throws CytomineClientException {
        for (Map.Entry<Term, Boolean> termEntry : termSelection.entrySet()) {
            try {
                if (termEntry.getValue().booleanValue()) {
                    new AnnotationTerm(annotation.getId(), termEntry.getKey().getId()).save();
                    continue;
                }
                new AnnotationTerm(annotation.getId(), termEntry.getKey().getId()).delete();
            }
            catch (CytomineException e) {
                System.err.println(String.format("Could not associate terms to annotation %d", (long)annotation.getId()));
                e.printStackTrace();
            }
        }
    }

    public Optional<String> getAnnotationLocation(long annotationId) throws CytomineClientException {
        AbstractAnnotation annotation = this.downloadAbstractAnnotation(annotationId);
        this.getAbstractAnnotationCache().store(annotationId, annotation);
        return annotation.getLocation();
    }

    public BufferedImage downloadPictureAsBufferedImage(String url, String format) throws CytomineClientException {
        try {
            return this.getInternalClient().getDefaultCytomineConnection().getPictureAsBufferedImage(url, format);
        }
        catch (CytomineException e) {
            throw new CytomineClientException(e.getMsg(), e);
        }
    }

    public void removeAnnotation(long annotationId) throws CytomineClientException {
        try {
            new Annotation().delete(annotationId);
            this.getAbstractAnnotationCache().remove(annotationId);
        }
        catch (CytomineException e) {
            throw new CytomineClientException(String.format("Could not remove annotation %d", annotationId), e);
        }
    }

    public Map<Long, Set<Long>> getAnnotationUsersByTerm(AbstractAnnotation annotation) throws CytomineClientException {
        JSONArray termUsersArray = (JSONArray)annotation.getInternalAnnotation().get("userByTerm");
        if (termUsersArray == null) {
            try {
                termUsersArray = Collection.fetchWithFilter(be.cytomine.client.models.Term.class, Annotation.class, annotation.getId(), 0, 0).getList();
            }
            catch (CytomineException e) {
                throw new CytomineClientException(String.format("Could not retrieve annotation %d termUsers", annotation.getId()), e);
            }
        }
        HashMap<Long, Set<Long>> termUsers = new HashMap<Long, Set<Long>>();
        for (Object tObject : termUsersArray) {
            JSONArray userIds;
            JSONObject termUser = (JSONObject)tObject;
            long termId = (Long)termUser.get("term");
            termUsers.putIfAbsent(termId, new HashSet());
            if (termUser.get("user") instanceof JSONArray) {
                userIds = (JSONArray)termUser.get("user");
            } else if (termUser.get("user") != null) {
                userIds = new JSONArray();
                userIds.add((Long)termUser.get("user"));
            } else {
                throw new CytomineClientException("Term " + termId + " has not user associated");
            }
            for (Object uObject : userIds) {
                long userId = (Long)uObject;
                ((Set)termUsers.get(termId)).add(userId);
            }
        }
        return termUsers;
    }

    public List<org.bioimageanalysis.icy.icytomine.core.model.UserJob> getUserJobsInProject(Project project) throws CytomineClientException {
        Collection<UserJob> userJobCollection = new Collection<UserJob>(UserJob.class, 0, 0);
        userJobCollection.addFilter("project", project.getId().toString());
        try {
            JSONObject json = this.internalClient.getDefaultCytomineConnection().doGet(userJobCollection.toURL().toLowerCase());
            userJobCollection.setList((JSONArray)json.get("collection"));
        }
        catch (CytomineException e) {
            throw new CytomineClientException(String.format("Could not retrieve user jobs in project %d", project.getId()), e);
        }
        ArrayList<org.bioimageanalysis.icy.icytomine.core.model.UserJob> foundUserJobs = new ArrayList<org.bioimageanalysis.icy.icytomine.core.model.UserJob>(userJobCollection.size());
        for (int i = 0; i < userJobCollection.size(); ++i) {
            org.bioimageanalysis.icy.icytomine.core.model.UserJob userJob = new org.bioimageanalysis.icy.icytomine.core.model.UserJob(this, userJobCollection.get(i));
            foundUserJobs.add(userJob);
            this.getUserJobCache().store(userJob.getId(), userJob);
        }
        return foundUserJobs;
    }

    public org.bioimageanalysis.icy.icytomine.core.model.UserJob getUserJob(Long userJobId) throws CytomineClientException {
        org.bioimageanalysis.icy.icytomine.core.model.UserJob userJob;
        try {
            userJob = (org.bioimageanalysis.icy.icytomine.core.model.UserJob)this.getUserJobCache().retrieve(userJobId);
        }
        catch (EntityCacheException e) {
            UserJob internalUserJob;
            try {
                internalUserJob = (UserJob)new UserJob().fetch(this.internalClient.getDefaultCytomineConnection(), userJobId);
                if (internalUserJob.getAttr() == null) {
                    throw new CytomineClientException("No user job data downloaded");
                }
            }
            catch (CytomineException e1) {
                throw new CytomineClientException("Could not retrieve user job " + userJobId, e1);
            }
            userJob = new org.bioimageanalysis.icy.icytomine.core.model.UserJob(this, internalUserJob);
            this.getUserJobCache().store(userJobId, userJob);
        }
        return userJob;
    }

    private UserJobCache getUserJobCache() {
        if (this.userJobCache == null) {
            this.userJobCache = UserJobCache.create(this);
        }
        return this.userJobCache;
    }

    public void updateImageMagnfication(Image image, Integer newMagnification) throws CytomineClientException {
        try {
            AbstractImage abstractImage = (AbstractImage)new AbstractImage().fetch(image.getAbstractImageId().get());
            abstractImage.set("magnification", newMagnification);
            abstractImage.update();
            if (!Objects.equals(abstractImage.getInt("magnification"), newMagnification)) {
                throw new CytomineClientException(String.format("You must be the original uploader of the image", new Object[0]));
            }
            image.getInternalImage().set("magnification", abstractImage.get("magnification"));
        }
        catch (Exception e) {
            throw new CytomineClientException(String.format("Could not set the magnification of the image %s to %sX. " + e.getMessage(), image.getId(), newMagnification), e);
        }
    }

    public void updateImageResolution(Image image, Double newResolution) {
        try {
            AbstractImage abstractImage = (AbstractImage)new AbstractImage().fetch(image.getAbstractImageId().get());
            abstractImage.set("resolution", newResolution);
            abstractImage.update();
            if (!Objects.equals(abstractImage.getDbl("resolution"), newResolution)) {
                throw new CytomineClientException(String.format("You must be the original uploader of the image", new Object[0]));
            }
            image.getInternalImage().set("resolution", abstractImage.get("resolution"));
        }
        catch (Exception e) {
            throw new CytomineClientException(String.format("Could not set the resolution of the image %s to %s mics/px", image.getId(), newResolution), e);
        }
    }

    public String toString() {
        return String.format("Cytomine client: host=%s, public key=%s", String.valueOf(this.getHost()), String.valueOf(this.getPublicKey()));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result;
        if (this.internalClient != null) {
            result += this.getHost().hashCode();
            result = 31 * result + this.getPublicKey().hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CytomineClient)) {
            return false;
        }
        CytomineClient other = (CytomineClient)obj;
        return this.hashCode() == other.hashCode();
    }

    @Override
    public void close() throws Exception {
        this.closeCaches();
    }

    private void closeCaches() {
        UserCache.getCacheManager().removeCache(this.userCache.getCacheAlias());
        ProjectCache.getCacheManager().removeCache(this.projectCache.getCacheAlias());
        DescriptionCache.getCacheManager().removeCache(this.descriptionCache.getCacheAlias());
        OntologyCache.getCacheManager().removeCache(this.ontologyCache.getCacheAlias());
        TermCache.getCacheManager().removeCache(this.termCache.getCacheAlias());
        ImageInstanceCache.getCacheManager().removeCache(this.imageInstanceCache.getCacheAlias());
        AbstractAnnotationCache.getCacheManager().removeCache(this.abstractAnnotationCache.getCacheAlias());
        UserJobCache.getCacheManager().removeCache(this.userJobCache.getCacheAlias());
    }
}

