/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.core.model;

import be.cytomine.client.models.ImageInstance;
import danyfel80.common.stream.StreamUtils;
import icy.type.dimension.Dimension2D;
import java.awt.Dimension;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.bioimageanalysis.icy.icytomine.core.connection.client.CytomineClient;
import org.bioimageanalysis.icy.icytomine.core.connection.client.CytomineClientException;
import org.bioimageanalysis.icy.icytomine.core.model.AbstractAnnotation;
import org.bioimageanalysis.icy.icytomine.core.model.AlgorithmAnnotation;
import org.bioimageanalysis.icy.icytomine.core.model.Entity;
import org.bioimageanalysis.icy.icytomine.core.model.Project;
import org.bioimageanalysis.icy.icytomine.core.model.User;
import org.bioimageanalysis.icy.icytomine.core.model.UserAnnotation;
import org.bioimageanalysis.icy.icytomine.core.model.UserJob;

public class Image
extends Entity {
    private static final int DEFAULT_TILE_SIZE = 256;
    private List<String> imageServers;
    private Map<Long, AbstractAnnotation> abstractAnnotations;

    public static Image retrieve(CytomineClient client, long imageInstanceId) throws CytomineClientException {
        return client.getImageInstance(imageInstanceId);
    }

    public Image(CytomineClient client, ImageInstance internalImage) {
        super(client, internalImage);
    }

    public ImageInstance getInternalImage() {
        return (ImageInstance)this.getModel();
    }

    public Optional<Calendar> getCreationDate() {
        Optional<Long> numericDate = this.getLong("created");
        if (numericDate.isPresent()) {
            Calendar c = GregorianCalendar.getInstance();
            c.setTimeInMillis(numericDate.get());
            return Optional.of(c);
        }
        return Optional.ofNullable(null);
    }

    public Optional<Long> getAbstractImageId() {
        return this.getLong("baseImage");
    }

    public Optional<Long> getProjectId() {
        return this.getLong("project");
    }

    public Optional<String> getName() {
        return this.getStr("originalFilename");
    }

    public Optional<String> getMimeType() {
        return Optional.ofNullable(this.getInternalImage().getStr("mime"));
    }

    public Optional<Integer> getSizeX() {
        return this.getInt("width");
    }

    public Optional<Integer> getSizeY() {
        return this.getInt("height");
    }

    public Optional<Dimension> getSize() {
        if (this.getSizeX().isPresent() && this.getSizeY().isPresent()) {
            return Optional.of(new Dimension(this.getSizeX().get(), this.getSizeY().get()));
        }
        return Optional.ofNullable(null);
    }

    public Optional<Double> getResolution() {
        return super.getDbl("resolution");
    }

    public Optional<Double> getDimensionX() {
        Optional<Double> resolution = this.getResolution();
        Optional<Integer> size = this.getSizeX();
        if (size.isPresent() && resolution.isPresent()) {
            return Optional.of(resolution.get() * (double)size.get().intValue());
        }
        return Optional.ofNullable(null);
    }

    public Optional<Double> getDimensionY() {
        Optional<Double> resolution = this.getResolution();
        Optional<Integer> size = this.getSizeY();
        if (size.isPresent() && resolution.isPresent()) {
            return Optional.of(resolution.get() * (double)size.get().intValue());
        }
        return Optional.ofNullable(null);
    }

    public Optional<Dimension2D> getDimension() {
        Optional<Dimension> size = this.getSize();
        Optional<Double> resolution = this.getResolution();
        if (size.isPresent() && resolution.isPresent()) {
            return Optional.of(new Dimension2D.Double((double)size.get().width * resolution.get(), (double)size.get().height * resolution.get()));
        }
        return Optional.ofNullable(null);
    }

    public Optional<Integer> getMagnification() {
        return this.getInt("magnification");
    }

    public Optional<Long> getDepth() {
        return this.getLong("depth");
    }

    public Optional<Integer> getTileWidth() {
        return Optional.of(256);
    }

    public Optional<Integer> getTileHeight() {
        return Optional.of(256);
    }

    public Optional<Dimension> getTileSize() {
        if (this.getTileWidth().isPresent() && this.getTileHeight().isPresent()) {
            return Optional.of(new Dimension(this.getTileWidth().get(), this.getTileHeight().get()));
        }
        return Optional.ofNullable(null);
    }

    public Long getOriginalUserId() {
        return this.getLong("user").get();
    }

    public Optional<Long> getAnnotationsOfUsersNumber() {
        return this.getLong("numberOfAnnotations");
    }

    public Optional<Long> getAnnotationsOfAlgorithmNumber() {
        return this.getLong("numberOfJobAnnotations");
    }

    public Optional<String> getTileUrl(long resolution, int tileIndex, int x, int y) throws CytomineClientException {
        List<String> servers = this.getImageServers(false);
        if (servers.isEmpty()) {
            return Optional.ofNullable(null);
        }
        return Optional.of(String.format("%s&x=%d&y=%d&z=%d&mimeType=%s", servers.get(0), x, y, this.getDepth().orElse(0L) - resolution, this.getMimeType().orElse("ndpi")));
    }

    public List<String> getImageServers(boolean recompute) throws CytomineClientException {
        if (this.imageServers == null || recompute) {
            this.imageServers = null;
            this.imageServers = this.getClient().getImageServers(this);
        }
        return this.imageServers;
    }

    public BufferedImage getThumbnail(int maxSize) throws CytomineClientException {
        return this.getClient().downloadImageAsBufferedImage(this.getAbstractImageId().get());
    }

    public Map<Long, UserAnnotation> getUserAnnotationsWithGeometry(User currentUser, boolean forceDownload) {
        HashSet<Long> userIds = new HashSet<Long>(1);
        userIds.add(currentUser.getId());
        Map<Long, UserAnnotation> annotations = this.getClient().getImageUserAnnotations(this, userIds);
        Map<Long, UserAnnotation> geometries = this.getClient().getImageUserAnnotationGeometries(this, userIds);
        geometries.forEach((aId, g) -> {
            UserAnnotation a = (UserAnnotation)annotations.get(aId);
            if (a != null) {
                a.getInternalAnnotation().set("location", g.getInternalAnnotation().getStr("location"));
            }
        });
        return annotations;
    }

    public Map<Long, AbstractAnnotation> getAbstractAnnotations(boolean recompute) throws CytomineClientException {
        if (this.abstractAnnotations == null || recompute) {
            this.abstractAnnotations = null;
            this.abstractAnnotations = this.getClient().getImageAbstractAnnotations(this);
        }
        return this.abstractAnnotations;
    }

    public Map<Long, AbstractAnnotation> getAbstractAnnotationsWithGeometry(Set<Long> annotationIds, boolean recompute) throws CytomineClientException {
        long annotationsWithoutGeometry = 0L;
        if (this.abstractAnnotations != null) {
            annotationsWithoutGeometry = annotationIds.stream().filter(aId -> {
                AbstractAnnotation a = this.abstractAnnotations.get(aId);
                if (a == null) {
                    return true;
                }
                return !a.getLocation().isPresent();
            }).count();
        }
        if (recompute || annotationsWithoutGeometry > 0L) {
            Map<Long, AbstractAnnotation> annotationsWithGeometry = this.getClient().getImageAbstractAnnotationsWithGeometry(this, recompute);
            if (this.abstractAnnotations == null) {
                this.abstractAnnotations = annotationsWithGeometry;
            } else {
                this.abstractAnnotations.putAll(annotationsWithGeometry);
            }
        }
        return annotationIds.stream().map(StreamUtils.wrapFunction(aId -> this.abstractAnnotations.get(aId))).collect(Collectors.toMap(Entity::getId, Function.identity()));
    }

    public Map<Long, UserAnnotation> getUserAnnotationsWithGeometry(Set<User> users) {
        Set<Long> userIds = users.stream().map(u -> u.getId()).collect(Collectors.toSet());
        Map<Long, UserAnnotation> annotations = this.getClient().getImageUserAnnotations(this, userIds);
        Map<Long, UserAnnotation> geometries = this.getClient().getImageUserAnnotationGeometries(this, userIds);
        geometries.forEach((aId, g) -> {
            UserAnnotation a = (UserAnnotation)annotations.get(aId);
            if (a != null) {
                a.getInternalAnnotation().set("location", g.getInternalAnnotation().getStr("location"));
            }
        });
        return annotations;
    }

    public Map<Long, AlgorithmAnnotation> getAlgorithmAnnotationsWithGeometry(Set<UserJob> userJobs) {
        Set<Long> userJobIds = userJobs.stream().map(u -> u.getId()).collect(Collectors.toSet());
        Map<Long, AlgorithmAnnotation> annotations = this.getClient().getImageAlgorithmAnnotations(this, userJobIds);
        Map<Long, AlgorithmAnnotation> geometries = this.getClient().getImageAlgorithmAnnotationGeometries(this, userJobIds);
        geometries.forEach((aId, g) -> {
            AlgorithmAnnotation a = (AlgorithmAnnotation)annotations.get(aId);
            if (a != null) {
                a.getInternalAnnotation().set("location", g.getInternalAnnotation().getStr("location"));
            }
        });
        return annotations;
    }

    public Map<Long, AbstractAnnotation> getAbstractAnnotationsAt(Rectangle2D imageArea) throws CytomineClientException {
        return this.getClient().getImageAbstractAnnotationsAt(this.getId(), imageArea);
    }

    public void removeAbstractAnnotations(Set<AbstractAnnotation> selectedAnnotations) {
        for (AbstractAnnotation annotation : selectedAnnotations) {
            this.getClient().removeAnnotation(annotation.getId());
        }
        if (this.abstractAnnotations != null) {
            Set<Long> selectedAnnotationIds = selectedAnnotations.stream().map(a -> a.getId()).collect(Collectors.toSet());
            selectedAnnotationIds.forEach(aId -> this.abstractAnnotations.remove(aId));
        }
    }

    public Project getProject() throws CytomineClientException {
        return this.getClient().getProject(this.getProjectId().get());
    }

    public void setMagnification(Integer newMagnification) throws CytomineClientException {
        this.getClient().updateImageMagnfication(this, newMagnification);
    }

    public void setResolution(Double newResolution) throws CytomineClientException {
        this.getClient().updateImageResolution(this, newResolution);
    }

    @Override
    public String toString() {
        return String.format("Image instance: id=%s, name=%s", String.valueOf(this.getId()), this.getName().orElse("Not specified"));
    }
}

