/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.ui.core.explorer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.bioimageanalysis.icy.icytomine.core.connection.client.CytomineClientException;
import org.bioimageanalysis.icy.icytomine.core.model.Project;

public class ProjectDetailsPanel
extends JPanel {
    private static final long serialVersionUID = -8451854002703582368L;
    private Project currentProject;
    private JScrollPane scrollPane;
    private JPanel panel;
    private JTextArea lblProjectName;
    private JTextArea txtrProjectDescription;
    private JTextArea lblIdValue;
    private JTextArea lblOntologyValue;
    private JTextArea lblImagesValue;
    private JTextArea lblAnnotationsValue;
    private JTextArea txtrUsers;

    public ProjectDetailsPanel() {
        this.setMinimumSize(new Dimension(150, 300));
        this.setPreferredSize(new Dimension(240, 400));
        this.setLayout(new BoxLayout(this, 1));
        JLabel lblProjectDetails = new JLabel("Project Details");
        lblProjectDetails.setAlignmentX(0.5f);
        lblProjectDetails.setHorizontalAlignment(0);
        lblProjectDetails.setFont(new Font("Tahoma", 1, 11));
        this.add(lblProjectDetails);
        this.scrollPane = new JScrollPane();
        this.scrollPane.setAutoscrolls(true);
        this.add(this.scrollPane);
        this.panel = new JPanel();
        this.panel.setBackground(UIManager.getColor("Panel.background"));
        this.setMinimumSize(new Dimension(200, 300));
        this.scrollPane.setViewportView(this.panel);
        GridBagLayout gbl_panel = new GridBagLayout();
        gbl_panel.columnWidths = new int[]{40, 0};
        gbl_panel.rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0};
        gbl_panel.columnWeights = new double[]{0.0};
        gbl_panel.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0};
        this.panel.setLayout(gbl_panel);
        this.lblProjectName = new JTextArea("Project Name");
        this.lblProjectName.setEditable(false);
        this.lblProjectName.setOpaque(false);
        this.lblProjectName.setFont(new Font("Tahoma", 1, 15));
        this.lblProjectName.setBackground(SystemColor.control);
        GridBagConstraints gbc_lblProjectName = new GridBagConstraints();
        gbc_lblProjectName.anchor = 11;
        gbc_lblProjectName.gridwidth = 2;
        gbc_lblProjectName.insets = new Insets(10, 10, 10, 10);
        gbc_lblProjectName.gridx = 0;
        gbc_lblProjectName.gridy = 0;
        this.panel.add((Component)this.lblProjectName, gbc_lblProjectName);
        this.txtrProjectDescription = new JTextArea();
        this.txtrProjectDescription.setOpaque(false);
        this.txtrProjectDescription.setSelectionColor(UIManager.getColor("TextArea.selectionBackground"));
        this.txtrProjectDescription.setSelectedTextColor(UIManager.getColor("TextArea.selectionForeground"));
        this.txtrProjectDescription.setEditable(false);
        this.txtrProjectDescription.setBackground(UIManager.getColor("Panel.background"));
        this.txtrProjectDescription.setFont(new Font("Tahoma", 0, 12));
        this.txtrProjectDescription.setMaximumSize(new Dimension(Integer.MAX_VALUE, 100));
        this.txtrProjectDescription.setPreferredSize(new Dimension(200, 50));
        this.txtrProjectDescription.setMinimumSize(new Dimension(60, 50));
        this.txtrProjectDescription.setLineWrap(true);
        this.txtrProjectDescription.setWrapStyleWord(true);
        this.txtrProjectDescription.setText("Some description of the project, maybe multiple lines involved here");
        GridBagConstraints gbc_txtrProjectDescription = new GridBagConstraints();
        gbc_txtrProjectDescription.gridwidth = 2;
        gbc_txtrProjectDescription.insets = new Insets(0, 0, 15, 0);
        gbc_txtrProjectDescription.fill = 1;
        gbc_txtrProjectDescription.gridx = 0;
        gbc_txtrProjectDescription.gridy = 1;
        this.panel.add((Component)this.txtrProjectDescription, gbc_txtrProjectDescription);
        JLabel lblId = new JLabel("ID");
        lblId.setFocusable(false);
        lblId.setFont(new Font("Tahoma", 1, 12));
        lblId.setHorizontalAlignment(4);
        GridBagConstraints gbc_lblId = new GridBagConstraints();
        gbc_lblId.insets = new Insets(0, 0, 5, 10);
        gbc_lblId.anchor = 13;
        gbc_lblId.gridx = 0;
        gbc_lblId.gridy = 2;
        this.panel.add((Component)lblId, gbc_lblId);
        this.lblIdValue = new JTextArea("12345678");
        this.lblIdValue.setEditable(false);
        this.lblIdValue.setFont(new Font("Tahoma", 0, 11));
        this.lblIdValue.setOpaque(false);
        GridBagConstraints gbc_lblIdValue = new GridBagConstraints();
        gbc_lblIdValue.fill = 2;
        gbc_lblIdValue.insets = new Insets(0, 0, 5, 0);
        gbc_lblIdValue.gridx = 1;
        gbc_lblIdValue.gridy = 2;
        this.panel.add((Component)this.lblIdValue, gbc_lblIdValue);
        JLabel lblOntology = new JLabel("Ontology");
        lblOntology.setFocusable(false);
        lblOntology.setHorizontalAlignment(4);
        lblOntology.setFont(new Font("Tahoma", 1, 12));
        GridBagConstraints gbc_lblOntology = new GridBagConstraints();
        gbc_lblOntology.anchor = 13;
        gbc_lblOntology.insets = new Insets(0, 0, 5, 10);
        gbc_lblOntology.gridx = 0;
        gbc_lblOntology.gridy = 3;
        this.panel.add((Component)lblOntology, gbc_lblOntology);
        this.lblOntologyValue = new JTextArea("Some ontology name");
        this.lblOntologyValue.setEditable(false);
        this.lblOntologyValue.setFont(new Font("Tahoma", 0, 11));
        this.lblOntologyValue.setOpaque(false);
        GridBagConstraints gbc_lblOntologyValue = new GridBagConstraints();
        gbc_lblOntologyValue.fill = 2;
        gbc_lblOntologyValue.insets = new Insets(0, 0, 5, 0);
        gbc_lblOntologyValue.gridx = 1;
        gbc_lblOntologyValue.gridy = 3;
        this.panel.add((Component)this.lblOntologyValue, gbc_lblOntologyValue);
        JLabel lblImages = new JLabel("Images");
        lblImages.setFocusable(false);
        lblImages.setHorizontalAlignment(4);
        lblImages.setFont(new Font("Tahoma", 1, 12));
        GridBagConstraints gbc_lblImages = new GridBagConstraints();
        gbc_lblImages.anchor = 13;
        gbc_lblImages.insets = new Insets(0, 0, 5, 10);
        gbc_lblImages.gridx = 0;
        gbc_lblImages.gridy = 4;
        this.panel.add((Component)lblImages, gbc_lblImages);
        this.lblImagesValue = new JTextArea("14");
        this.lblImagesValue.setEditable(false);
        this.lblImagesValue.setFont(new Font("Tahoma", 0, 11));
        this.lblImagesValue.setOpaque(false);
        GridBagConstraints gbc_lblImagesValue = new GridBagConstraints();
        gbc_lblImagesValue.fill = 2;
        gbc_lblImagesValue.insets = new Insets(0, 0, 5, 0);
        gbc_lblImagesValue.gridx = 1;
        gbc_lblImagesValue.gridy = 4;
        this.panel.add((Component)this.lblImagesValue, gbc_lblImagesValue);
        JLabel lblAnnotations = new JLabel("Annotations");
        lblAnnotations.setFocusable(false);
        lblAnnotations.setHorizontalAlignment(4);
        lblAnnotations.setFont(new Font("Tahoma", 1, 12));
        GridBagConstraints gbc_lblAnnotations = new GridBagConstraints();
        gbc_lblAnnotations.anchor = 13;
        gbc_lblAnnotations.insets = new Insets(0, 0, 5, 10);
        gbc_lblAnnotations.gridx = 0;
        gbc_lblAnnotations.gridy = 5;
        this.panel.add((Component)lblAnnotations, gbc_lblAnnotations);
        this.lblAnnotationsValue = new JTextArea("14");
        this.lblAnnotationsValue.setEditable(false);
        this.lblAnnotationsValue.setFont(new Font("Tahoma", 0, 11));
        this.lblAnnotationsValue.setOpaque(false);
        GridBagConstraints gbc_lblAnnotationsValue = new GridBagConstraints();
        gbc_lblAnnotationsValue.fill = 2;
        gbc_lblAnnotationsValue.insets = new Insets(0, 0, 5, 0);
        gbc_lblAnnotationsValue.gridx = 1;
        gbc_lblAnnotationsValue.gridy = 5;
        this.panel.add((Component)this.lblAnnotationsValue, gbc_lblAnnotationsValue);
        JLabel lblUsers = new JLabel("Users");
        lblUsers.setFocusable(false);
        lblUsers.setHorizontalAlignment(4);
        lblUsers.setFont(new Font("Tahoma", 1, 12));
        GridBagConstraints gbc_lblUsers = new GridBagConstraints();
        gbc_lblUsers.anchor = 12;
        gbc_lblUsers.insets = new Insets(0, 0, 5, 10);
        gbc_lblUsers.gridx = 0;
        gbc_lblUsers.gridy = 6;
        this.panel.add((Component)lblUsers, gbc_lblUsers);
        this.txtrUsers = new JTextArea();
        this.txtrUsers.setOpaque(false);
        this.txtrUsers.setSelectionColor(UIManager.getColor("TextArea.selectionBackground"));
        this.txtrUsers.setSelectedTextColor(UIManager.getColor("TextArea.selectionForeground"));
        this.txtrUsers.setEditable(false);
        this.txtrUsers.setLineWrap(true);
        this.txtrUsers.setBackground(UIManager.getColor("Panel.background"));
        this.txtrUsers.setFont(new Font("Tahoma", 0, 12));
        this.txtrUsers.setWrapStyleWord(true);
        this.txtrUsers.setText("Username 1\nUsername 2\nUsername 3");
        GridBagConstraints gbc_txtrUsers = new GridBagConstraints();
        gbc_txtrUsers.gridwidth = 1;
        gbc_txtrUsers.insets = new Insets(0, 0, 5, 0);
        gbc_txtrUsers.fill = 1;
        gbc_txtrUsers.gridx = 1;
        gbc_txtrUsers.gridy = 6;
        this.panel.add((Component)this.txtrUsers, gbc_txtrUsers);
    }

    public void setCurrentProject(Project project) {
        this.currentProject = project;
        this.updateProjectDetails();
    }

    public Project getCurrentProject() {
        return this.currentProject;
    }

    public void updateProjectDetails() {
        if (this.getCurrentProject() != null) {
            String users;
            String description;
            String name = this.getCurrentProject().getName().orElse("Not specified");
            this.lblProjectName.setText(name);
            try {
                description = this.getCurrentProject().getDescription().getData().orElse("Not specified");
            }
            catch (CytomineClientException e) {
                description = "Not specified";
            }
            this.txtrProjectDescription.setText(description);
            Long id = this.getCurrentProject().getId();
            if (id == null) {
                this.lblIdValue.setText("not Specified");
            } else {
                this.lblIdValue.setText(id.toString());
            }
            String ontology = this.getCurrentProject().getOntologyName().orElse("Not specified");
            this.lblOntologyValue.setText(ontology);
            Optional<Long> numImages = this.getCurrentProject().getNumberOfImages();
            if (numImages.isPresent()) {
                this.lblImagesValue.setText(numImages.get().toString());
            } else {
                this.lblImagesValue.setText("Not specified");
            }
            Long numAnnotations = this.getCurrentProject().getTotalNumberOfAnnotations();
            if (numAnnotations == null) {
                this.lblAnnotationsValue.setText("Not specified");
            } else {
                this.lblAnnotationsValue.setText(numAnnotations.toString());
            }
            try {
                users = this.getCurrentProject().getUsers(true).stream().map(u -> u.getName().orElse(String.format("Not specified (id=%d)", (long)u.getId()))).collect(Collectors.joining(System.lineSeparator()));
            }
            catch (CytomineClientException e) {
                users = "Not specified";
            }
            this.txtrUsers.setText(users);
        } else {
            this.lblProjectName.setText("Unavailable");
            this.txtrProjectDescription.setText("Unavailable");
            this.lblIdValue.setText("Unavailable");
            this.lblOntologyValue.setText("Unavailable");
            this.lblImagesValue.setText("Unavailable");
            this.lblAnnotationsValue.setText("Unavailable");
            this.txtrUsers.setText("Unavailable");
        }
    }

    public void updateLayout() {
        SwingUtilities.invokeLater(() -> {
            this.scrollPane.getVerticalScrollBar().setValue(this.scrollPane.getVerticalScrollBar().getMinimum());
            this.scrollPane.getHorizontalScrollBar().setValue(this.scrollPane.getHorizontalScrollBar().getMinimum());
        });
        this.panel.revalidate();
        this.panel.repaint();
    }
}

