/*
 * Decompiled with CFR 0.152.
 */
package be.cytomine.client.models;

import be.cytomine.client.Cytomine;
import be.cytomine.client.CytomineConnection;
import be.cytomine.client.CytomineException;
import be.cytomine.client.models.Job;
import be.cytomine.client.models.Model;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;

public class JobData
extends Model<JobData> {
    public JobData() {
    }

    public JobData(Job job, String key, String filename) {
        this(job.getId(), key, filename);
    }

    public JobData(Long idJob, String key, String filename) {
        this.set("key", key);
        this.set("job", idJob);
        this.set("filename", filename);
    }

    public void uploadJobData(File file) throws CytomineException, IOException {
        this.uploadJobData(Cytomine.getInstance().getDefaultCytomineConnection(), file);
    }

    public void uploadJobData(CytomineConnection connection, File file) throws CytomineException, IOException {
        connection.uploadFile("/api/jobdata/" + this.getId() + "/upload", Files.readAllBytes(file.toPath()));
    }

    public void uploadJobData(byte[] data) throws CytomineException {
        this.uploadJobData(Cytomine.getInstance().getDefaultCytomineConnection(), data);
    }

    public void uploadJobData(CytomineConnection connection, byte[] data) throws CytomineException {
        connection.uploadFile("/api/jobdata/" + this.getId() + "/upload", data);
    }

    public File downloadJobData(String file) throws CytomineException {
        return this.downloadJobData(Cytomine.getInstance().getDefaultCytomineConnection(), file);
    }

    public File downloadJobData(CytomineConnection connection, String file) throws CytomineException {
        connection.downloadFile("/api/jobdata/" + this.getId() + "/download", file);
        return new File(file);
    }
}

