/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.core.model.filters.abstrct;

import com.google.common.base.Objects;
import java.util.HashSet;
import java.util.Set;
import org.bioimageanalysis.icy.icytomine.core.model.AbstractAnnotation;

public abstract class AbstractAnnotationFilter {
    private AbstractAnnotationFilter previousFilter;
    private AbstractAnnotationFilterUpdateListener previousFilterUpdateHandler;
    protected Set<AbstractAnnotation> activeAnnotations;
    private Set<AbstractAnnotationFilterUpdateListener> updateListeners = new HashSet<AbstractAnnotationFilterUpdateListener>();

    public void setPreviousFilter(AbstractAnnotationFilter newPreviousFilter) {
        if (!Objects.equal((Object)this.previousFilter, (Object)newPreviousFilter)) {
            if (this.previousFilter != null) {
                this.previousFilter.removeAnnotationFilterUpdateListener(this.getPreviousFilterUpdateHandler());
            }
            this.previousFilter = newPreviousFilter;
            if (this.previousFilter != null) {
                this.previousFilter.addAnnotationFilterUpdateListener(this.getPreviousFilterUpdateHandler());
                this.computeActiveAnnotations(ComputationMode.RECOMPUTE_JUST_THIS);
            }
        }
    }

    private AbstractAnnotationFilterUpdateListener getPreviousFilterUpdateHandler() {
        if (this.previousFilterUpdateHandler == null) {
            this.previousFilterUpdateHandler = activeAnnotations -> this.computeActiveAnnotations(ComputationMode.RECOMPUTE_JUST_THIS);
        }
        return this.previousFilterUpdateHandler;
    }

    public AbstractAnnotationFilter getPreviousFilter() {
        return this.previousFilter;
    }

    public Set<AbstractAnnotation> getActiveAnnotations(ComputationMode mode) {
        if (!this.isComputed() || mode != ComputationMode.USE_LAST_RESULT) {
            this.computeActiveAnnotations(mode);
        }
        return this.activeAnnotations;
    }

    private boolean isComputed() {
        return this.activeAnnotations != null;
    }

    public void computeActiveAnnotations(ComputationMode mode) {
        Set<AbstractAnnotation> inputAnnotations = null;
        if (mode == ComputationMode.USE_LAST_RESULT) {
            if (!this.isComputed()) {
                inputAnnotations = this.previousFilter.getActiveAnnotations(mode);
                this.activeAnnotations = this.applyFilter(inputAnnotations);
                this.notifyUpdateListeners();
            }
        } else {
            inputAnnotations = mode == ComputationMode.RECOMPUTE_ALL ? this.previousFilter.getActiveAnnotations(mode) : this.previousFilter.getActiveAnnotations(ComputationMode.USE_LAST_RESULT);
            this.activeAnnotations = this.applyFilter(inputAnnotations);
            this.notifyUpdateListeners();
        }
    }

    protected abstract Set<AbstractAnnotation> applyFilter(Set<AbstractAnnotation> var1);

    protected void notifyUpdateListeners() {
        this.updateListeners.forEach(l -> l.filterUpdated(this.activeAnnotations));
    }

    public void addAnnotationFilterUpdateListener(AbstractAnnotationFilterUpdateListener listener) {
        this.updateListeners.add(listener);
    }

    public void removeAnnotationFilterUpdateListener(AbstractAnnotationFilterUpdateListener listener) {
        this.updateListeners.remove(listener);
    }

    public void disconnect() {
        AbstractAnnotationFilter previousFilter = this.getPreviousFilter();
        HashSet<AbstractAnnotationFilterUpdateListener> updateListenersCopy = new HashSet<AbstractAnnotationFilterUpdateListener>(this.updateListeners);
        for (AbstractAnnotationFilterUpdateListener listener : updateListenersCopy) {
            this.removeAnnotationFilterUpdateListener(listener);
            previousFilter.addAnnotationFilterUpdateListener(listener);
        }
        this.setPreviousFilter(null);
        previousFilter.computeActiveAnnotations(ComputationMode.RECOMPUTE_JUST_THIS);
    }

    public static interface AbstractAnnotationFilterUpdateListener {
        public void filterUpdated(Set<AbstractAnnotation> var1);
    }

    public static enum ComputationMode {
        RECOMPUTE_ALL,
        RECOMPUTE_JUST_THIS,
        USE_LAST_RESULT;

    }
}

