/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.core.view;

import icy.plugin.PluginLoader;
import java.awt.image.BufferedImage;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.bioimageanalysis.icy.icytomine.core.model.Image;
import org.bioimageanalysis.icy.icytomine.core.view.Tile2DKey;
import org.bioimageanalysis.icy.icytomine.core.view.TileResult;
import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.ehcache.config.Builder;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;

public class ViewTileCache {
    private static CacheManager cacheManager = CacheManagerBuilder.newCacheManagerBuilder().withClassLoader(PluginLoader.getLoader()).build(true);
    private Image imageInformation;
    private Cache<Tile2DKey, BufferedImage> tileCache;
    private Set<ViewTileLoadListener> tileLoadListeners;
    private ThreadPoolExecutor tileRequestThreadPool;
    private ExecutorCompletionService<TileResult> tileRequestCompletionService;
    private List<Future<TileResult>> tileRequests;
    private ExecutorService requestHandlingService;

    public ViewTileCache(Image imageInformation) {
        this.imageInformation = imageInformation;
        this.tileLoadListeners = new HashSet<ViewTileLoadListener>();
        this.startTileCache();
        this.startRequestHandlingService();
    }

    private void startTileCache() {
        String cacheName = "ViewCache" + this.hashCode();
        this.tileCache = cacheManager.getCache(cacheName, Tile2DKey.class, BufferedImage.class);
        if (this.tileCache == null) {
            this.tileCache = cacheManager.createCache(cacheName, CacheConfigurationBuilder.newCacheConfigurationBuilder(Tile2DKey.class, BufferedImage.class, (Builder)ResourcePoolsBuilder.heap((long)500L)).build());
        }
    }

    private void startRequestHandlingService() {
        this.tileRequestThreadPool = (ThreadPoolExecutor)Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 2);
        this.tileRequestCompletionService = new ExecutorCompletionService(this.tileRequestThreadPool);
        this.tileRequests = new LinkedList<Future<TileResult>>();
        this.requestHandlingService = Executors.newSingleThreadExecutor();
        this.requestHandlingService.submit(this.getRequestLoopHandlingTask());
        this.requestHandlingService.shutdown();
    }

    private Runnable getRequestLoopHandlingTask() {
        return () -> {
            ExecutorService loopHandlingService = null;
            try {
                loopHandlingService = Executors.newSingleThreadExecutor();
                Future<Void> loopHandlingResult = loopHandlingService.submit(this.getLoopTask());
                loopHandlingService.shutdown();
                loopHandlingResult.get();
            }
            catch (InterruptedException loopHandlingResult) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.stopExecutor(loopHandlingService);
                System.out.println("Stopped receiving cache events.");
            }
        };
    }

    private Callable<Void> getLoopTask() {
        return () -> {
            while (!this.tileRequestThreadPool.isTerminated()) {
                try {
                    Future<TileResult> futureResult = this.tileRequestCompletionService.take();
                    if (futureResult.isCancelled()) continue;
                    TileResult result = futureResult.get();
                    this.notifyTileLoaded(result);
                }
                catch (CancellationException e) {
                }
                catch (InterruptedException e) {
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return null;
        };
    }

    protected void notifyTileLoaded(TileResult result) {
        this.tileLoadListeners.forEach(l -> l.tileLoaded(result.getKey(), result.getTileImage()));
    }

    public void addTileLoadedListener(ViewTileLoadListener listener) {
        this.tileLoadListeners.add(listener);
    }

    public void cancelPreviousRequest() {
        this.tileRequests.forEach(future -> future.cancel(true));
        this.tileRequestThreadPool.purge();
        this.tileRequests.clear();
    }

    public void requestTile(long resolutionLevel, int x, int y, int tileIndex) {
        Tile2DKey key = new Tile2DKey(this.imageInformation, resolutionLevel, x, y, tileIndex);
        Future<TileResult> request = this.tileRequestCompletionService.submit(() -> {
            BufferedImage tileImage = (BufferedImage)this.tileCache.get((Object)key);
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (tileImage == null) {
                tileImage = this.imageInformation.getClient().downloadPictureAsBufferedImage(this.imageInformation.getTileUrl(resolutionLevel, tileIndex, x, y).get(), "ndpi");
            }
            if (tileImage != null) {
                this.tileCache.put((Object)key, (Object)tileImage);
            } else {
                tileImage = this.createDefaultTile();
            }
            return new TileResult(key, tileImage);
        });
        this.tileRequests.add(request);
    }

    private BufferedImage createDefaultTile() {
        return new BufferedImage(this.imageInformation.getTileWidth().get(), this.imageInformation.getTileHeight().get(), 2);
    }

    public void stop() {
        this.stopExecutor(this.requestHandlingService);
        this.stopExecutor(this.tileRequestThreadPool);
        this.stopCache();
    }

    private void stopExecutor(ExecutorService service) {
        if (service != null) {
            service.shutdownNow();
            try {
                service.awaitTermination(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void stopCache() {
        cacheManager.removeCache("ViewCache" + this.hashCode());
    }

    public boolean isProcessing() {
        return !this.tileRequestThreadPool.getQueue().isEmpty();
    }

    public static interface ViewTileLoadListener {
        public void tileLoaded(Tile2DKey var1, BufferedImage var2);
    }
}

