/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.ui.core.explorer;

import icy.gui.dialog.MessageDialog;
import icy.plugin.PluginLoader;
import java.awt.image.BufferedImage;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.bioimageanalysis.icy.icytomine.core.connection.client.CytomineClient;
import org.bioimageanalysis.icy.icytomine.core.connection.client.CytomineClientException;
import org.bioimageanalysis.icy.icytomine.core.model.Image;
import org.bioimageanalysis.icy.icytomine.core.model.Project;
import org.bioimageanalysis.icy.icytomine.ui.core.explorer.ExplorerPanel;
import org.bioimageanalysis.icy.icytomine.ui.core.explorer.ImagePanel;
import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.ehcache.config.Builder;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.expiry.Duration;
import org.ehcache.expiry.Expirations;

public class ExplorerPanelController {
    private ExplorerPanel panel;
    private Set<ImagePanel.ImageSelectionListener> viewerRequestListeners;

    public ExplorerPanelController(ExplorerPanel explorerPanel) {
        this.panel = explorerPanel;
        this.viewerRequestListeners = new HashSet<ImagePanel.ImageSelectionListener>();
        this.setEventHandlers();
        this.setCacheManagement();
    }

    private void setEventHandlers() {
        this.setProjectSelectionHandler();
        this.setImageSelectionHandler();
        this.setImageMagnificationChangeHandler();
        this.setImageResolutionChangeHandler();
        this.setImageViewerRequestHandler();
    }

    private void setProjectSelectionHandler() {
        this.panel.getProjectPanel().addProjectSelectionListener(project -> this.onProjectSelected(project));
    }

    private void onProjectSelected(Project project) {
        if (project == null) {
            this.panel.showNoDetails();
        } else {
            this.panel.getProjectDetailsPanel().setCurrentProject(project);
            this.panel.showProjectDetails();
        }
        this.panel.getImagePanel().setProject(project);
    }

    private void setImageSelectionHandler() {
        this.panel.getImagePanel().addImageSelectionListener(image -> this.onImageSelected(image));
    }

    private void onImageSelected(Image image) {
        if (image == null) {
            if (this.panel.getProjectPanel().getSelectedProject() == null) {
                this.panel.showNoDetails();
            } else {
                this.panel.showProjectDetails();
            }
        } else {
            this.panel.getImageDetailsPanel().setCurrentImage(image);
            this.panel.showImageDetails();
        }
    }

    private void setImageMagnificationChangeHandler() {
        this.panel.getImageDetailsPanel().addImageMagnificationChangeListener((image, newMagnification) -> this.onImageMagnificationChanged(image, newMagnification));
    }

    private void onImageMagnificationChanged(Image image, Integer newMagnification) {
        try {
            image.setMagnification(newMagnification);
        }
        catch (CytomineClientException e) {
            e.printStackTrace();
            MessageDialog.showDialog((String)"Error updating magnification", (String)e.getMessage(), (int)0);
        }
    }

    private void setImageResolutionChangeHandler() {
        this.panel.getImageDetailsPanel().addImageResolutionChangeListener((image, newResolution) -> this.onImageResolutionChanged(image, newResolution));
    }

    private void onImageResolutionChanged(Image image, Double newResolution) {
        try {
            image.setResolution(newResolution);
        }
        catch (CytomineClientException e) {
            e.printStackTrace();
            MessageDialog.showDialog((String)"Error updating resolution", (String)e.getMessage(), (int)0);
        }
    }

    private void setImageViewerRequestHandler() {
        this.panel.getImagePanel().addImageDoubleClickListener(image -> this.viewerRequestListeners.forEach(listener -> listener.imageSelected(image)));
        this.panel.getImageDetailsPanel().addImagePreviewDoubleClickListener(image -> this.viewerRequestListeners.forEach(listener -> listener.imageSelected(image)));
    }

    private void setCacheManagement() {
        final CacheManager cacheManager = CacheManagerBuilder.newCacheManagerBuilder().withClassLoader(PluginLoader.getLoader()).build(true);
        this.panel.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                cacheManager.removeCache(ExplorerPanelController.this.getPreviewCacheAlias());
                System.out.println("preview cache destroyed");
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorAdded(AncestorEvent event) {
                CacheConfiguration cacheConfiguration = CacheConfigurationBuilder.newCacheConfigurationBuilder(Long.class, BufferedImage.class, (Builder)ResourcePoolsBuilder.heap((long)500L)).withExpiry(Expirations.timeToLiveExpiration((Duration)Duration.of((long)1L, (TimeUnit)TimeUnit.MINUTES))).build();
                Cache previewCache = cacheManager.createCache(ExplorerPanelController.this.getPreviewCacheAlias(), cacheConfiguration);
                ExplorerPanelController.this.panel.getImageDetailsPanel().setPreviewCache((Cache<Long, BufferedImage>)previewCache);
                System.out.println("preview cache created");
            }
        });
    }

    private String getPreviewCacheAlias() {
        return "previewCache" + this.panel.hashCode();
    }

    public void setClient(CytomineClient client) {
        this.panel.getHostAddressLabel().setText(client.getCurrentUser().getName().orElse("no username") + " @ " + client.getHost());
        this.panel.getProjectPanel().setClient(client);
        this.updateProjects();
    }

    private void updateProjects() {
        try {
            this.panel.getProjectPanel().updateProjectList();
        }
        catch (CytomineClientException e) {
            e.printStackTrace();
            this.onProjectSelected(null);
        }
    }

    public void addImageViewerRequestListener(ImagePanel.ImageSelectionListener listener) {
        this.viewerRequestListeners.add(listener);
    }

    public void removeImageViewerRequestListener(ImagePanel.ImageSelectionListener listener) {
        this.viewerRequestListeners.remove(listener);
    }
}

