/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.abstractannotations;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import org.bioimageanalysis.icy.icytomine.core.model.AbstractAnnotation;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.abstractannotations.AbstractAnnotationTableModel;

public class AbstractAnnotationTable
extends JPanel {
    private static final long serialVersionUID = -7027821039693155920L;
    private JTable table;
    private JScrollPane tableScrollPane;
    private List<AbstractAnnotationTableModel.AnnotationVisibilityListener> annotationVisibilityListeners;
    private List<AnnotationSelectionListener> annotationSelectionListeners;
    private List<AnnotationDoubleClickListener> annotationDoubleClickListeners;
    private AbstractAnnotationTableModel tableModel;

    public AbstractAnnotationTable() {
        this.setupUI();
        this.setListenerLists();
        this.setAnnotationsInTable(Collections.emptyMap());
        this.setListenersInTable();
    }

    private void setupUI() {
        this.setGridBagLayout();
        this.addTable();
    }

    private void setGridBagLayout() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{224, 0};
        gridBagLayout.rowHeights = new int[]{100, 0};
        gridBagLayout.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{1.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
    }

    private void addTable() {
        this.tableScrollPane = new JScrollPane();
        GridBagConstraints gbc_scrollPane = new GridBagConstraints();
        gbc_scrollPane.fill = 1;
        gbc_scrollPane.gridx = 0;
        gbc_scrollPane.gridy = 0;
        this.add((Component)this.tableScrollPane, gbc_scrollPane);
        this.table = new JTable();
        this.tableScrollPane.setViewportView(this.table);
    }

    private void setListenerLists() {
        this.annotationVisibilityListeners = new ArrayList<AbstractAnnotationTableModel.AnnotationVisibilityListener>();
        this.annotationSelectionListeners = new ArrayList<AnnotationSelectionListener>();
        this.annotationDoubleClickListeners = new ArrayList<AnnotationDoubleClickListener>();
    }

    private void removeAnnotationVisibilityListenersFromTableModel() {
        if (this.tableModel != null) {
            this.annotationVisibilityListeners.forEach(listener -> this.tableModel.removeAnnotationVisibilityListener((AbstractAnnotationTableModel.AnnotationVisibilityListener)listener));
        }
    }

    private void addAnnotationVisibilityListenersFromTableModel() {
        if (this.tableModel != null) {
            this.annotationVisibilityListeners.forEach(listener -> this.tableModel.addAnnotationVisibilityListener((AbstractAnnotationTableModel.AnnotationVisibilityListener)listener));
        }
    }

    public void setAnnotationVisibility(Map<AbstractAnnotation, Boolean> annotationVisibility) {
        this.setAnnotationsInTable(annotationVisibility);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAnnotationsInTable(Map<AbstractAnnotation, Boolean> visibilityForAnnotation) {
        AbstractAnnotationTableModel tableModel = new AbstractAnnotationTableModel(visibilityForAnnotation);
        JTable jTable = this.table;
        synchronized (jTable) {
            this.removeAnnotationVisibilityListenersFromTableModel();
            this.table.setModel(tableModel);
            this.tableModel = tableModel;
            tableModel.fireTableDataChanged();
            this.addAnnotationVisibilityListenersFromTableModel();
        }
    }

    public Map<AbstractAnnotation, Boolean> getAnnotationVisibilityMap() {
        return this.tableModel.getAnnotationVisibility();
    }

    private void setListenersInTable() {
        this.table.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                this.notifySelectionChange();
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 2 && AbstractAnnotationTable.this.table.getSelectedRow() != -1) {
                    Point point = e.getPoint();
                    int row = AbstractAnnotationTable.this.table.rowAtPoint(point);
                    if (row != -1) {
                        AbstractAnnotationTable.this.notifyDoubleClickSelection();
                    }
                }
            }
        });
    }

    private void notifySelectionChange() {
        Set<AbstractAnnotation> selectedAnnotations = this.getSelectedAnnotations();
        this.annotationSelectionListeners.forEach(l -> l.selectionChanged(selectedAnnotations));
    }

    public Set<AbstractAnnotation> getSelectedAnnotations() {
        ListSelectionModel selectionModel = this.table.getSelectionModel();
        HashSet<AbstractAnnotation> selectedAnnotations = new HashSet<AbstractAnnotation>();
        if (!selectionModel.isSelectionEmpty()) {
            int minIndex = selectionModel.getMinSelectionIndex();
            int maxIndex = selectionModel.getMaxSelectionIndex();
            for (int i = minIndex; i <= maxIndex; ++i) {
                if (!selectionModel.isSelectedIndex(i)) continue;
                selectedAnnotations.add(((AbstractAnnotationTableModel)this.table.getModel()).getAnnotationAt(i));
            }
        }
        return selectedAnnotations;
    }

    private void notifyDoubleClickSelection() {
        this.annotationDoubleClickListeners.forEach(l -> l.annotationDoubleClicked(this.getSelectedAnnotation()));
    }

    private AbstractAnnotation getSelectedAnnotation() {
        ListSelectionModel selectionModel = this.table.getSelectionModel();
        int rowIndex = selectionModel.getMinSelectionIndex();
        if (rowIndex != -1) {
            return ((AbstractAnnotationTableModel)this.table.getModel()).getAnnotationAt(rowIndex);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAnnotationVisibilityListener(AbstractAnnotationTableModel.AnnotationVisibilityListener listener) {
        JTable jTable = this.table;
        synchronized (jTable) {
            this.annotationVisibilityListeners.add(listener);
            if (this.tableModel != null) {
                this.tableModel.addAnnotationVisibilityListener(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAnnotationVisibilityListener(AbstractAnnotationTableModel.AnnotationVisibilityListener listener) {
        JTable jTable = this.table;
        synchronized (jTable) {
            this.annotationVisibilityListeners.remove(listener);
            if (this.tableModel != null) {
                this.tableModel.removeAnnotationVisibilityListener(listener);
            }
        }
    }

    public void addAnnotationSelectionListener(AnnotationSelectionListener listener) {
        this.annotationSelectionListeners.add(listener);
    }

    public void removeAnnotationSelectionListener(AnnotationSelectionListener listener) {
        this.annotationSelectionListeners.remove(listener);
    }

    public void addAnnotationDoubleClickListener(AnnotationDoubleClickListener listener) {
        this.annotationDoubleClickListeners.add(listener);
    }

    public void removeAnnotationDoubleClickListener(AnnotationDoubleClickListener listener) {
        this.annotationDoubleClickListeners.remove(listener);
    }

    public void setSelectedAnnotations(Set<AbstractAnnotation> selectedAnnotations) {
        int numAnnotations = this.tableModel.getRowCount();
        this.table.getSelectionModel().clearSelection();
        boolean firstFound = true;
        for (int row = 0; row < numAnnotations; ++row) {
            AbstractAnnotation annotationAtRow = this.tableModel.getAnnotationAt(row);
            if (!selectedAnnotations.contains(annotationAtRow)) continue;
            this.table.getSelectionModel().addSelectionInterval(row, row);
            if (!firstFound) continue;
            this.table.scrollRectToVisible(this.table.getCellRect(row, 0, true));
            firstFound = false;
        }
    }

    public static interface AnnotationDoubleClickListener {
        public void annotationDoubleClicked(AbstractAnnotation var1);
    }

    public static interface AnnotationSelectionListener {
        public void selectionChanged(Set<AbstractAnnotation> var1);
    }
}

