/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.abstractannotations;

import danyfel80.common.stream.StreamUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import org.bioimageanalysis.icy.icytomine.core.connection.client.CytomineClientException;
import org.bioimageanalysis.icy.icytomine.core.model.AbstractAnnotation;

public class AbstractAnnotationTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -6011058852592614856L;
    private static final String[] columnNames = new String[]{"Visible", "Name", "Terms", "Author", "Type"};
    private List<AbstractAnnotation> annotations;
    private Map<AbstractAnnotation, Boolean> visibilityForAnnotation;
    private List<AnnotationVisibilityListener> annotationVisibilityListeners;

    public AbstractAnnotationTableModel(Map<? extends AbstractAnnotation, Boolean> visibilityForAnnotation) {
        this.annotations = new ArrayList<AbstractAnnotation>(visibilityForAnnotation.keySet());
        this.visibilityForAnnotation = new ConcurrentHashMap<AbstractAnnotation, Boolean>(visibilityForAnnotation);
        this.annotationVisibilityListeners = new ArrayList<AnnotationVisibilityListener>();
        this.addTableModelListener(this::onTableValuesChanged);
    }

    @Override
    public String getColumnName(int column) {
        return 0 <= column && column < columnNames.length ? columnNames[column] : null;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return List.class;
            }
            case 3: {
                return String.class;
            }
            case 4: {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0 && 0 <= rowIndex && rowIndex < this.annotations.size();
    }

    @Override
    public int getRowCount() {
        return this.annotations.size();
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (0 <= rowIndex && rowIndex < this.annotations.size()) {
            switch (columnIndex) {
                case 0: {
                    return this.isAnnotationVisible(rowIndex);
                }
                case 1: {
                    return this.getAnnotationId(rowIndex);
                }
                case 2: {
                    return this.getAnnotationTerms(rowIndex);
                }
                case 3: {
                    return this.getAnnotationAuthor(rowIndex);
                }
                case 4: {
                    return this.getAnnotationType(rowIndex);
                }
            }
            return null;
        }
        return null;
    }

    public Boolean isAnnotationVisible(int rowIndex) {
        return this.visibilityForAnnotation.get(this.getAnnotationAt(rowIndex));
    }

    public Long getAnnotationId(int rowIndex) {
        return this.getAnnotationAt(rowIndex).getId();
    }

    public List<String> getAnnotationTerms(int rowIndex) {
        try {
            return this.getAnnotationAt(rowIndex).getAssociatedTerms().stream().map(StreamUtils.wrapFunction(t -> t.getName().orElse("Not specified"))).collect(Collectors.toList());
        }
        catch (CytomineClientException e) {
            return new ArrayList<String>(0);
        }
    }

    public String getAnnotationAuthor(int rowIndex) {
        try {
            return this.getAnnotationAt(rowIndex).getUser().getName().orElse("Not specified");
        }
        catch (CytomineClientException e) {
            return "Unknown";
        }
    }

    public String getAnnotationType(int rowIndex) {
        if (0 <= rowIndex && rowIndex < this.annotations.size()) {
            return this.getAnnotationAt(rowIndex).getClass().getSimpleName();
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            this.visibilityForAnnotation.put(this.getAnnotationAt(rowIndex), (Boolean)aValue);
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAnnotationVisibilityListener(AnnotationVisibilityListener listener) {
        List<AnnotationVisibilityListener> list = this.annotationVisibilityListeners;
        synchronized (list) {
            this.annotationVisibilityListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAnnotationVisibilityListener(AnnotationVisibilityListener listener) {
        List<AnnotationVisibilityListener> list = this.annotationVisibilityListeners;
        synchronized (list) {
            this.annotationVisibilityListeners.remove(listener);
        }
    }

    private void onTableValuesChanged(TableModelEvent event) {
        if (event.getType() == 0) {
            this.notifyAnnotationVisibilityChanged(event.getFirstRow());
        }
    }

    private void notifyAnnotationVisibilityChanged(int annotationIndex) {
        if (this.annotations.size() > 0) {
            AbstractAnnotation annotation = this.getAnnotationAt(annotationIndex);
            this.annotationVisibilityListeners.forEach(listener -> listener.onAnnotationVisibilityChanged(annotation, this.visibilityForAnnotation.get(annotation)));
        }
    }

    public boolean isAnnotationVisible(AbstractAnnotation annotation) {
        return this.visibilityForAnnotation.getOrDefault(annotation, false);
    }

    public Set<AbstractAnnotation> getAnnotations() {
        return new HashSet<AbstractAnnotation>(this.annotations);
    }

    public Map<AbstractAnnotation, Boolean> getAnnotationVisibility() {
        return Collections.unmodifiableMap(this.visibilityForAnnotation);
    }

    public Set<AbstractAnnotation> getVisibleAnnotations() {
        return this.visibilityForAnnotation.entrySet().stream().filter(e -> (Boolean)e.getValue()).map(e -> (AbstractAnnotation)e.getKey()).collect(Collectors.toSet());
    }

    public AbstractAnnotation getAnnotationAt(int rowIndex) throws IndexOutOfBoundsException {
        return this.annotations.get(rowIndex);
    }

    public static interface AnnotationVisibilityListener {
        public void onAnnotationVisibilityChanged(AbstractAnnotation var1, boolean var2);
    }
}

