/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.abstractannotations.actions;

import danyfel80.common.stream.StreamUtils;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JPanel;
import org.bioimageanalysis.icy.icytomine.core.model.Term;
import org.bioimageanalysis.icy.icytomine.ui.general.JCheckableItem;
import org.bioimageanalysis.icy.icytomine.ui.general.JCheckedComboBox;

public class AnnotationTermSelector
extends JPanel {
    private static final long serialVersionUID = 5914334147655073551L;
    private JCheckedComboBox<TermItem> checkedComboBox;

    public AnnotationTermSelector() {
        this.setGridBagLayout();
        this.addCheckedComboBox();
    }

    private void setGridBagLayout() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{1, 0};
        gridBagLayout.rowHeights = new int[]{1, 0};
        gridBagLayout.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
    }

    private void addCheckedComboBox() {
        this.checkedComboBox = new JCheckedComboBox();
        GridBagConstraints gbc_checkedComboBox = new GridBagConstraints();
        gbc_checkedComboBox.fill = 2;
        gbc_checkedComboBox.gridx = 0;
        gbc_checkedComboBox.gridy = 0;
        this.add(this.checkedComboBox, gbc_checkedComboBox);
    }

    public void setAvailableTerms(Collection<Term> terms) {
        Set<TermItem> availableTerms = terms.stream().map(StreamUtils.wrapFunction(t -> new TermItem((Term)t))).collect(Collectors.toSet());
        availableTerms.add(TermItem.NO_TERM);
        this.checkedComboBox.setModel(this.createSelectionModel(availableTerms));
        this.checkedComboBox.setSelectedItem(TermItem.NO_TERM);
    }

    private ComboBoxModel<JCheckableItem<TermItem>> createSelectionModel(Set<TermItem> termItems) {
        DefaultComboBoxModel<JCheckableItem<TermItem>> model = new DefaultComboBoxModel<JCheckableItem<TermItem>>((JCheckableItem[])termItems.stream().map(StreamUtils.wrapFunction(t -> new JCheckableItem<TermItem>((TermItem)t, t.toString(), false))).toArray(JCheckableItem[]::new));
        return model;
    }

    public Set<Term> getAvailableTerms() {
        HashSet<Term> selectedTerms = new HashSet<Term>();
        ComboBoxModel model = this.checkedComboBox.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            JCheckableItem item = (JCheckableItem)model.getElementAt(i);
            if (item.getObject() == TermItem.NO_TERM) continue;
            selectedTerms.add(((TermItem)item.getObject()).getTerm());
        }
        return selectedTerms;
    }

    public void setSelectedTerms(Set<Term> terms) {
        ComboBoxModel model = this.checkedComboBox.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            JCheckableItem checkableItem = (JCheckableItem)model.getElementAt(i);
            if (checkableItem.getObject() == TermItem.NO_TERM) {
                if (!terms.isEmpty()) continue;
                checkableItem.setSelected(true);
                continue;
            }
            if (terms.contains(((TermItem)checkableItem.getObject()).getTerm())) {
                checkableItem.setSelected(true);
                continue;
            }
            checkableItem.setSelected(false);
        }
        this.checkedComboBox.updateUI();
    }

    public Set<Term> getSelectedTerms() {
        HashSet<Term> selectedTerms = new HashSet<Term>();
        ComboBoxModel model = this.checkedComboBox.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            JCheckableItem item = (JCheckableItem)model.getElementAt(i);
            if (!item.isSelected() || item.getObject() == TermItem.NO_TERM) continue;
            selectedTerms.add(((TermItem)item.getObject()).getTerm());
        }
        return selectedTerms;
    }

    private static class TermItem {
        public static final TermItem NO_TERM = new TermItem(null);
        private Term term;

        public TermItem(Term term) {
            this.term = term;
        }

        public Term getTerm() {
            return this.term;
        }

        public String toString() {
            if (this.term != null) {
                return this.term.getName().orElse("Not specified");
            }
            return "No term";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.term == null ? 0 : this.term.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof TermItem)) {
                return false;
            }
            TermItem other = (TermItem)obj;
            return !(this.term == null ? other.term != null : !this.term.equals(other.term));
        }
    }
}

