/*
 * Decompiled with CFR 0.152.
 */
package plugins.danyfel80.cytomine.annotation;

import icy.plugin.abstract_.Plugin;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bioimageanalysis.icy.icytomine.core.model.AbstractAnnotation;
import org.bioimageanalysis.icy.icytomine.core.model.Entity;
import org.bioimageanalysis.icy.icytomine.core.model.Image;
import org.bioimageanalysis.icy.icytomine.core.model.Term;
import org.bioimageanalysis.icy.icytomine.core.model.User;
import org.bioimageanalysis.icy.icytomine.core.model.UserAnnotation;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarGenericArray;
import plugins.adufour.vars.lang.VarString;
import vars.cytomine.VarCytomineImage;

public class GetCytomineImageUserAnnotations
extends Plugin
implements Block {
    private VarCytomineImage varInImage;
    private VarString varInUserNameFilter;
    private VarString varInTermNameFilter;
    private VarGenericArray<AbstractAnnotation[]> varOutAnnotations;
    private Image targetImage;
    private Set<String> usernames;
    private Set<String> termNames;
    private Set<UserAnnotation> targetAnnotations;

    public void declareInput(VarList inputMap) {
        this.varInImage = VarCytomineImage.ofNullable(null);
        this.varInUserNameFilter = new VarString("User names", "noUser");
        this.varInTermNameFilter = new VarString("Term name", "No Term");
        inputMap.add(this.varInImage.getName(), (Var)this.varInImage);
        inputMap.add(this.varInUserNameFilter.getName(), (Var)this.varInUserNameFilter);
        inputMap.add(this.varInTermNameFilter.getName(), (Var)this.varInTermNameFilter);
    }

    public void declareOutput(VarList outputMap) {
        this.varOutAnnotations = new VarGenericArray("Annotations", AbstractAnnotation[].class, (Object)new AbstractAnnotation[0]);
        outputMap.add(this.varOutAnnotations.getName(), this.varOutAnnotations);
    }

    public void run() {
        this.readParameters();
        this.computeAnnotations();
        this.setOutputValues();
    }

    private void readParameters() {
        this.targetImage = (Image)this.varInImage.getValue(true);
        this.usernames = Arrays.stream(((String)this.varInUserNameFilter.getValue(true)).toLowerCase().split(" *, *")).distinct().collect(Collectors.toSet());
        this.termNames = Arrays.stream(((String)this.varInTermNameFilter.getValue(true)).split(" *, *")).filter(t -> !t.isEmpty()).distinct().map(String::toLowerCase).collect(Collectors.toSet());
    }

    private void computeAnnotations() {
        List<User> users = this.targetImage.getProject().getUsers(false);
        Set targetUsers = users.stream().filter(u -> this.usernames.contains(u.getName().orElse("").toLowerCase())).collect(Collectors.toSet());
        Map<Long, UserAnnotation> userAnnotations = targetUsers.isEmpty() ? this.targetImage.getClient().getImageUserAnnotations(this.targetImage) : this.targetImage.getClient().getImageUserAnnotations(this.targetImage, targetUsers.stream().map(Entity::getId).collect(Collectors.toSet()));
        Set<Term> terms = this.targetImage.getProject().getOntology().getTerms(false);
        Set targetTerms = terms.stream().filter(t -> this.termNames.contains(t.getName().orElse("").toLowerCase())).collect(Collectors.toSet());
        boolean containsNoTerm = this.termNames.contains("No Term");
        this.targetAnnotations = userAnnotations.values().stream().filter(a -> {
            Set<Term> aTerms = a.getAssociatedTerms();
            return this.termNames.isEmpty() || aTerms.stream().anyMatch(t -> targetTerms.contains(t)) || containsNoTerm && aTerms.isEmpty();
        }).collect(Collectors.toSet());
    }

    private void setOutputValues() {
        this.varOutAnnotations.setValue((Object)this.targetAnnotations.toArray(new AbstractAnnotation[this.targetAnnotations.size()]));
    }
}

