/*
 * Decompiled with CFR 0.152.
 */
package be.cytomine.client.collections;

import be.cytomine.client.Cytomine;
import be.cytomine.client.CytomineConnection;
import be.cytomine.client.CytomineException;
import be.cytomine.client.collections.Collection;
import be.cytomine.client.models.Project;
import be.cytomine.client.models.User;

public class UserCollection
extends Collection<User> {
    public UserCollection() {
        this(0, 0);
    }

    public UserCollection(int offset, int max) {
        super(User.class, max, offset);
    }

    public static UserCollection fetchMembersOfAProject(Project project) throws CytomineException {
        return UserCollection.fetchMembersOfAProject(project, false);
    }

    public static UserCollection fetchMembersOfAProject(Project project, boolean admin) throws CytomineException {
        return UserCollection.fetchMembersOfAProject(project, admin, false, 0, 0);
    }

    public static UserCollection fetchMembersOfAProject(Project project, boolean admin, boolean online) throws CytomineException {
        return UserCollection.fetchMembersOfAProject(Cytomine.getInstance().getDefaultCytomineConnection(), project, admin, online, 0, 0);
    }

    public static UserCollection fetchMembersOfAProject(Project project, boolean admin, boolean online, int offset, int max) throws CytomineException {
        return UserCollection.fetchMembersOfAProject(Cytomine.getInstance().getDefaultCytomineConnection(), project, admin, online, offset, max);
    }

    public static UserCollection fetchMembersOfAProject(CytomineConnection connection, Project project, boolean admin, boolean online) throws CytomineException {
        return UserCollection.fetchMembersOfAProject(connection, project, admin, online, 0, 0);
    }

    public static UserCollection fetchMembersOfAProject(CytomineConnection connection, Project project, boolean admin, boolean online, int offset, int max) throws CytomineException {
        UserCollection uc = new UserCollection(max, offset);
        if (admin) {
            uc.addFilter("admin", "true");
        }
        if (online) {
            uc.addFilter("online", "true");
        }
        uc.addFilter("project", project.getId().toString());
        return (UserCollection)uc.fetch();
    }

    @Override
    protected String getJSONResourceURL() throws CytomineException {
        if (this.isFilterBy("project") && this.isFilterBy("admin")) {
            return "/api/project/" + this.getFilter("project") + "/admin.json";
        }
        if (this.isFilterBy("project") && this.isFilterBy("online")) {
            return "/api/project/" + this.getFilter("project") + "/online/user.json";
        }
        if (this.isFilterBy("project")) {
            return "/api/project/" + this.getFilter("project") + "/user.json";
        }
        return super.getJSONResourceURL();
    }
}

