/*
 * Decompiled with CFR 0.152.
 */
package be.cytomine.client.models;

import be.cytomine.client.Cytomine;
import be.cytomine.client.CytomineConnection;
import be.cytomine.client.CytomineException;
import be.cytomine.client.models.Model;
import java.io.File;
import java.util.HashMap;
import org.json.simple.JSONObject;

public class AttachedFile
extends Model<AttachedFile> {
    public AttachedFile() {
    }

    public AttachedFile(Model model, File file) {
        this(model, file.getAbsolutePath());
    }

    public AttachedFile(Model model, String file) {
        this(Cytomine.convertDomainName(model.getClass().getSimpleName().toLowerCase()), model.getId(), file);
    }

    public AttachedFile(String domainClassName, Long idDomain, String file) {
        this.set("domainIdent", idDomain.toString());
        this.set("domainClassName", domainClassName);
        this.set("file", file);
    }

    @Override
    public AttachedFile save() throws CytomineException {
        return this.save(Cytomine.getInstance().getDefaultCytomineConnection());
    }

    @Override
    public AttachedFile save(CytomineConnection connection) throws CytomineException {
        if (this.getStr("file") == null || this.getStr("domainIdent") == null || this.getStr("domainClassName") == null) {
            throw new CytomineException(400, "domainClassName, domainIdent and file attribute must be set");
        }
        HashMap<String, String> entities = new HashMap<String, String>();
        entities.put("domainIdent", this.getStr("domainIdent"));
        entities.put("domainClassName", this.getStr("domainClassName"));
        if (this.getStr("filename") != null) {
            entities.put("filename", this.getStr("filename"));
        }
        JSONObject json = connection.uploadFile(this.toURL(), new File(this.getStr("file")), entities);
        this.setAttr(json);
        return this;
    }

    public void downloadFile(String dest) throws CytomineException {
        if (this.getStr("url") == null) {
            throw new CytomineException(400, "Download URL not known");
        }
        Cytomine.getInstance().getDefaultCytomineConnection().downloadFile(this.get("url").toString(), dest);
    }
}

