/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.core.model;

import java.util.Optional;
import org.bioimageanalysis.icy.icytomine.core.connection.client.CytomineClient;
import org.bioimageanalysis.icy.icytomine.core.connection.client.CytomineClientException;
import org.bioimageanalysis.icy.icytomine.core.model.Entity;
import org.bioimageanalysis.icy.icytomine.core.model.key.DescriptionId;

public class Description
extends Entity {
    private DescriptionId descriptionId;

    public static Description retrieve(CytomineClient client, long describedEntityId, String describedDomainName) throws CytomineClientException {
        return client.getDescription(describedEntityId, describedDomainName);
    }

    public Description(CytomineClient client, be.cytomine.client.models.Description model) {
        super(client, model);
        this.descriptionId = new DescriptionId(model.getStr("domainClassName"), model.getLong("domainIdent"));
    }

    public be.cytomine.client.models.Description getInternalUser() {
        return (be.cytomine.client.models.Description)this.getModel();
    }

    public DescriptionId getDescriptionId() {
        return this.descriptionId;
    }

    public Optional<String> getData() {
        return this.getStr("data");
    }

    @Override
    public String getDomainName() {
        return new be.cytomine.client.models.Description().getDomainName();
    }

    @Override
    public String toString() {
        return String.format("Description: Id=%s, Data=%s", String.valueOf(this.getId()), String.valueOf(this.getData()));
    }
}

