/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.ui.core.explorer;

import com.google.common.base.Objects;
import icy.gui.dialog.MessageDialog;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import org.bioimageanalysis.icy.icytomine.core.connection.client.CytomineClientException;
import org.bioimageanalysis.icy.icytomine.core.model.Image;
import org.bioimageanalysis.icy.icytomine.ui.core.explorer.ImageDetailsPanel;
import org.bioimageanalysis.icy.icytomine.ui.core.explorer.ImagePanel;
import org.ehcache.Cache;

public class ImageDetailsPanelController {
    private ImageDetailsPanel panel;
    private Image currentImage;
    private ExecutorService previewExecutor;
    private Cache<Long, BufferedImage> previewCache;
    private Set<ImageMagnificationChangeListener> magnificationChangeListeners;
    private Set<ImageResolutionChangeListener> resolutionChangeListeners;

    public ImageDetailsPanelController(ImageDetailsPanel panel) {
        this.panel = panel;
        this.magnificationChangeListeners = new HashSet<ImageMagnificationChangeListener>();
        this.resolutionChangeListeners = new HashSet<ImageResolutionChangeListener>();
    }

    public void setPreviewCache(Cache<Long, BufferedImage> cache) {
        this.previewCache = cache;
    }

    public Image getCurrentImage() {
        return this.currentImage;
    }

    public void setCurrentImage(Image image) {
        this.currentImage = image;
        this.updateImageDetails();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateImageDetails() {
        if (this.getCurrentImage() != null) {
            String date;
            String id = "" + this.getCurrentImage().getId();
            String filename = this.getCurrentImage().getName().orElse("Not specified");
            Optional<Double> dimensionX = this.getCurrentImage().getDimensionX();
            Optional<Double> dimensionY = this.getCurrentImage().getDimensionY();
            String dimension = dimensionX.isPresent() && dimensionY.isPresent() ? String.format("%.2f x %.2f \u00b5m", dimensionX.get(), dimensionY.get()) : "Not specified";
            Optional<Integer> magnificationValue = this.getCurrentImage().getMagnification();
            String magnification = magnificationValue.isPresent() ? String.format("%dX", magnificationValue.get()) : "Not specified";
            Optional<Long> annotationsAlgoValue = this.getCurrentImage().getAnnotationsOfAlgorithmNumber();
            String annotationsAlgo = annotationsAlgoValue.isPresent() ? annotationsAlgoValue.get().toString() : "Not specified";
            Optional<Long> annotationsUserValue = this.getCurrentImage().getAnnotationsOfUsersNumber();
            String annotationsUser = annotationsUserValue.isPresent() ? annotationsUserValue.get().toString() : "Not specified";
            Optional<Dimension> sizeValue = this.getCurrentImage().getSize();
            String size = sizeValue.isPresent() ? String.format("%d x %d px", sizeValue.get().width, sizeValue.get().height) : "Not specified";
            Optional<Double> resolutionValue = this.getCurrentImage().getResolution();
            String resolution = resolutionValue.isPresent() ? String.format("%f \u00b5m/px", resolutionValue.get()) : "Not specified";
            Optional<Long> depthValue = this.getCurrentImage().getDepth();
            String depth = depthValue.isPresent() ? String.format("%d levels", depthValue.get()) : "Not specified";
            Optional<Calendar> dateValue = this.getCurrentImage().getCreationDate();
            if (dateValue.isPresent()) {
                SimpleDateFormat formatter = new SimpleDateFormat("d MMM yyyy HH:mm");
                date = formatter.format(dateValue.get().getTime());
            } else {
                date = "Not specified";
            }
            JLabel jLabel = this.panel.getPreviewLabel();
            synchronized (jLabel) {
                this.panel.getPreviewLabel().setIcon(null);
                if (this.previewExecutor != null && !this.previewExecutor.isTerminated()) {
                    this.previewExecutor.shutdownNow();
                }
                this.previewExecutor = Executors.newSingleThreadExecutor();
                this.previewExecutor.submit(() -> {
                    ExecutorService thisExecutor = this.previewExecutor;
                    BufferedImage preview = (BufferedImage)this.previewCache.get((Object)this.getCurrentImage().getId());
                    if (preview == null) {
                        try {
                            preview = this.getCurrentImage().getThumbnail(256);
                        }
                        catch (CytomineClientException e) {
                            e.printStackTrace();
                            preview = new BufferedImage(256, 256, 2);
                        }
                    }
                    ImageIcon icon = preview == null ? ImageDetailsPanel.defaultIcon : new ImageIcon(preview);
                    if (this.previewExecutor == thisExecutor) {
                        this.panel.getPreviewLabel().setIcon(icon);
                        this.panel.getPreviewLabel().invalidate();
                    }
                });
                this.previewExecutor.shutdown();
            }
            this.panel.getFileNameLabel().setText(filename);
            this.panel.getImageIdTextArea().setText(id);
            this.panel.getImageDimensionTextArea().setText(dimension);
            this.panel.getImageMagnificationTextArea().setText(magnification);
            this.panel.getNumberOfAlgoAnnotationsTextArea().setText(annotationsAlgo);
            this.panel.getNumberOfUserAnnotationsTextArea().setText(annotationsUser);
            this.panel.getImageSizeTextArea().setText(size);
            this.panel.getImageResolutionTextArea().setText(resolution);
            this.panel.getImageDepthTextArea().setText(depth);
            this.panel.getImageCreationDateTextArea().setText(date);
        } else {
            this.panel.getFileNameLabel().setText("Image file name");
            this.panel.getImageIdTextArea().setText("0");
            this.panel.getImageDimensionTextArea().setText("0 x 0 \u00b5m");
            this.panel.getImageMagnificationTextArea().setText("0X");
            this.panel.getNumberOfAlgoAnnotationsTextArea().setText("0");
            this.panel.getNumberOfUserAnnotationsTextArea().setText("0");
            this.panel.getImageSizeTextArea().setText("0 x 0 px");
            this.panel.getImageResolutionTextArea().setText("0 \u00b5m/px");
            this.panel.getImageDepthTextArea().setText("0 levels");
            this.panel.getImageCreationDateTextArea().setText("Not available");
            this.panel.getPreviewLabel().setIcon(ImageDetailsPanel.defaultIcon);
        }
        this.setEditionHandlers();
        this.panel.updateLayout();
    }

    private void setEditionHandlers() {
        this.setMagnificationEditionHandlers();
        this.setResolutionEditionHandlers();
    }

    private void setMagnificationEditionHandlers() {
        this.panel.getImageMagnificationTextArea().setEditable(false);
        this.panel.getImageMagnificationEditButton().setText("Edit");
        Optional<Integer> magnificationValue = this.getCurrentImage().getMagnification();
        String magnification = magnificationValue.isPresent() ? String.format("%dX", magnificationValue.get()) : "Not specified";
        this.panel.getImageMagnificationTextArea().setText(magnification);
        MouseAdapter magnificationEditListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (!event.isConsumed()) {
                    if (ImageDetailsPanelController.this.panel.getImageMagnificationTextArea().isEditable()) {
                        ImageDetailsPanelController.this.panel.getImageMagnificationTextArea().setEditable(false);
                        ImageDetailsPanelController.this.panel.getImageMagnificationEditButton().setText("Edit");
                        Integer newMagnification = null;
                        try {
                            newMagnification = Integer.parseInt(ImageDetailsPanelController.this.panel.getImageMagnificationTextArea().getText());
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        Integer finalMagnification = newMagnification;
                        ImageDetailsPanelController.this.magnificationChangeListeners.forEach(l -> l.magnificationChanged(ImageDetailsPanelController.this.currentImage, finalMagnification));
                        Optional<Integer> magnificationValue = ImageDetailsPanelController.this.getCurrentImage().getMagnification();
                        String magnification = magnificationValue.isPresent() ? String.format("%dX", magnificationValue.get()) : "Not specified";
                        ImageDetailsPanelController.this.panel.getImageMagnificationTextArea().setText(magnification);
                    } else {
                        Long originalUserId = ImageDetailsPanelController.this.currentImage.getOriginalUserId();
                        if (!Objects.equal((Object)ImageDetailsPanelController.this.currentImage.getClient().getCurrentUser().getId(), (Object)originalUserId)) {
                            MessageDialog.showDialog((String)"You must be the original uploader of the image to edit this field.", (int)0);
                        } else {
                            ImageDetailsPanelController.this.panel.getImageMagnificationTextArea().setText(ImageDetailsPanelController.this.currentImage.getMagnification().orElse(1).toString());
                            ImageDetailsPanelController.this.panel.getImageMagnificationEditButton().setText("Save");
                            ImageDetailsPanelController.this.panel.getImageMagnificationTextArea().setEditable(true);
                        }
                    }
                    event.consume();
                }
            }
        };
        this.panel.getImageMagnificationEditButton().addMouseListener(magnificationEditListener);
    }

    private void setResolutionEditionHandlers() {
        this.panel.getImageResolutionTextArea().setEditable(false);
        this.panel.getImageResolutionEditButton().setText("Edit");
        Optional<Double> resolutionValue = this.getCurrentImage().getResolution();
        String resolution = resolutionValue.isPresent() ? String.format("%f \u00b5m/px", resolutionValue.get()) : "Not specified";
        this.panel.getImageResolutionTextArea().setText(resolution);
        MouseAdapter resolutionEditListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (!event.isConsumed()) {
                    if (ImageDetailsPanelController.this.panel.getImageResolutionTextArea().isEditable()) {
                        ImageDetailsPanelController.this.panel.getImageResolutionTextArea().setEditable(false);
                        ImageDetailsPanelController.this.panel.getImageResolutionEditButton().setText("Edit");
                        Double newResolution = null;
                        try {
                            newResolution = Double.parseDouble(ImageDetailsPanelController.this.panel.getImageResolutionTextArea().getText());
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        Double finalResolution = newResolution;
                        ImageDetailsPanelController.this.resolutionChangeListeners.forEach(l -> l.resolutionChanged(ImageDetailsPanelController.this.currentImage, finalResolution));
                        Optional<Double> resolutionValue = ImageDetailsPanelController.this.getCurrentImage().getResolution();
                        String resolution = resolutionValue.isPresent() ? String.format("%f \u00b5m/px", resolutionValue.get()) : "Not specified";
                        ImageDetailsPanelController.this.panel.getImageResolutionTextArea().setText(resolution);
                    } else {
                        Long originalUserId = ImageDetailsPanelController.this.currentImage.getOriginalUserId();
                        if (!Objects.equal((Object)ImageDetailsPanelController.this.currentImage.getClient().getCurrentUser().getId(), (Object)originalUserId)) {
                            MessageDialog.showDialog((String)"You must be the original uploader of the image to edit this field.", (int)0);
                        } else {
                            ImageDetailsPanelController.this.panel.getImageResolutionTextArea().setText(ImageDetailsPanelController.this.currentImage.getResolution().orElse(1.0).toString());
                            ImageDetailsPanelController.this.panel.getImageResolutionEditButton().setText("Save");
                            ImageDetailsPanelController.this.panel.getImageResolutionTextArea().setEditable(true);
                        }
                    }
                    event.consume();
                }
            }
        };
        this.panel.getImageResolutionEditButton().addMouseListener(resolutionEditListener);
    }

    public void addImageMagnificationChangeListener(ImageMagnificationChangeListener listener) {
        this.magnificationChangeListeners.add(listener);
    }

    public void addImageResolutionChangeListener(ImageResolutionChangeListener listener) {
        this.resolutionChangeListeners.add(listener);
    }

    public void addImagePreviewDoubleClickListener(ImagePanel.ImageSelectionListener listener) {
        MouseListener listDoubleClickListener = this.createListDoubleClickListener(listener);
        this.panel.getPreviewLabel().addMouseListener(listDoubleClickListener);
    }

    private MouseListener createListDoubleClickListener(final ImagePanel.ImageSelectionListener listener) {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    listener.imageSelected(ImageDetailsPanelController.this.currentImage);
                }
            }
        };
    }

    public static interface ImageResolutionChangeListener {
        public void resolutionChanged(Image var1, Double var2);
    }

    public static interface ImageMagnificationChangeListener {
        public void magnificationChanged(Image var1, Integer var2);
    }
}

