/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.abstractannotations;

import icy.gui.dialog.ConfirmDialog;
import icy.gui.dialog.MessageDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.JPanel;
import org.bioimageanalysis.icy.icytomine.core.connection.client.CytomineClientException;
import org.bioimageanalysis.icy.icytomine.core.model.AbstractAnnotation;
import org.bioimageanalysis.icy.icytomine.core.model.Image;
import org.bioimageanalysis.icy.icytomine.core.model.Term;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.abstractannotations.AbstractAnnotationTable;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.abstractannotations.actions.AbstractAnnotationActionPanel;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.abstractannotations.filters.AbstractAnnotationFilteringPanel;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.abstractannotations.layers.AnnotationLayer;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.abstractannotations.layers.AnnotationLayerSelector;

public class AbstractAnnotationManagerPanel
extends JPanel {
    private static final long serialVersionUID = -1103632676301490194L;
    private AnnotationLayerSelector annotationLayerSelector;
    private AbstractAnnotationFilteringPanel annotationFilteringPanel;
    private AbstractAnnotationTable abstractAnnotationTable;
    private AbstractAnnotationActionPanel abstractAnnotationActionPanel;
    private List<AnnotationLayerVisibilityListener> annotationLayersVisibilityListeners;
    private List<AnnotationsVisibilityListener> annotationsVisibilitylisteners;
    private List<AnnotationTermCommitListener> annotationTermSelectionCommitListeners;
    private List<AnnotationDeletionListener> annotationDeletionListeners;

    public AbstractAnnotationManagerPanel() {
        this.setupUI();
        this.setupListeners();
    }

    private void setupUI() {
        this.setGridBagLayout();
        this.addLayerSelector();
        this.addFilterSelector();
        this.addAnnotationTable();
        this.addActionsPanel();
    }

    private void setGridBagLayout() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0, 0, 0};
        gridBagLayout.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 1.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
    }

    private void addLayerSelector() {
        this.annotationLayerSelector = new AnnotationLayerSelector();
        GridBagConstraints gbc_annotationLayerSelector = new GridBagConstraints();
        gbc_annotationLayerSelector.insets = new Insets(0, 0, 5, 0);
        gbc_annotationLayerSelector.fill = 1;
        gbc_annotationLayerSelector.gridx = 0;
        gbc_annotationLayerSelector.gridy = 0;
        this.add((Component)this.annotationLayerSelector, gbc_annotationLayerSelector);
    }

    private void addFilterSelector() {
        this.annotationFilteringPanel = new AbstractAnnotationFilteringPanel();
        GridBagConstraints gbc_annotationFilteringPanel = new GridBagConstraints();
        gbc_annotationFilteringPanel.insets = new Insets(0, 0, 5, 0);
        gbc_annotationFilteringPanel.fill = 1;
        gbc_annotationFilteringPanel.gridx = 0;
        gbc_annotationFilteringPanel.gridy = 1;
        this.add((Component)this.annotationFilteringPanel, gbc_annotationFilteringPanel);
    }

    private void addAnnotationTable() {
        this.abstractAnnotationTable = new AbstractAnnotationTable();
        GridBagConstraints gbc_abstractAnnotationTable = new GridBagConstraints();
        gbc_abstractAnnotationTable.insets = new Insets(0, 0, 5, 0);
        gbc_abstractAnnotationTable.fill = 1;
        gbc_abstractAnnotationTable.gridx = 0;
        gbc_abstractAnnotationTable.gridy = 2;
        this.add((Component)this.abstractAnnotationTable, gbc_abstractAnnotationTable);
    }

    private void addActionsPanel() {
        this.abstractAnnotationActionPanel = new AbstractAnnotationActionPanel();
        GridBagConstraints gbc_abstractAnnotationActionPanel = new GridBagConstraints();
        gbc_abstractAnnotationActionPanel.fill = 1;
        gbc_abstractAnnotationActionPanel.gridx = 0;
        gbc_abstractAnnotationActionPanel.gridy = 3;
        this.add((Component)this.abstractAnnotationActionPanel, gbc_abstractAnnotationActionPanel);
    }

    private void setupListeners() {
        this.annotationLayersVisibilityListeners = new ArrayList<AnnotationLayerVisibilityListener>();
        this.annotationsVisibilitylisteners = new ArrayList<AnnotationsVisibilityListener>();
        this.annotationTermSelectionCommitListeners = new ArrayList<AnnotationTermCommitListener>();
        this.annotationDeletionListeners = new ArrayList<AnnotationDeletionListener>();
        this.annotationLayerSelector.addItemChangeListner(this::targetAnnotationLayersUpdated);
        this.annotationFilteringPanel.addAnnotationFilterUpdateListener(this::targetAnnotationsFilteringUpdated);
        this.abstractAnnotationTable.addAnnotationVisibilityListener(this::annotationVisibilityChanged);
        this.abstractAnnotationActionPanel.addAnnotationTermAssociationListener(this::onAnnotationTermChangeRequested);
        this.abstractAnnotationActionPanel.addAnnotationDeleteListener(this::onAnnotationDeletionRequested);
    }

    private void targetAnnotationLayersUpdated(ItemEvent event) {
        this.annotationLayersVisibilityListeners.forEach(l -> l.annotationLayerVisibilityChanged(this.annotationLayerSelector.getAnnotationLayerStates()));
    }

    private void targetAnnotationsFilteringUpdated(Set<AbstractAnnotation> filteredAnnotations) {
        Map<AbstractAnnotation, Boolean> currentVisibility = this.abstractAnnotationTable.getAnnotationVisibilityMap();
        Map<AbstractAnnotation, Boolean> newAnnotationVisibility = this.createAnnotationVisibility(filteredAnnotations, currentVisibility);
        this.abstractAnnotationTable.setAnnotationVisibility(newAnnotationVisibility);
        Set<AbstractAnnotation> visibleAnnotations = newAnnotationVisibility.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toSet());
        this.notifyAnnotationsVisibilityListeners(visibleAnnotations);
    }

    private Map<AbstractAnnotation, Boolean> createAnnotationVisibility(Set<AbstractAnnotation> filteredAnnotations, Map<AbstractAnnotation, Boolean> currentVisibility) {
        Map<AbstractAnnotation, Boolean> newAnnotationVisibility = filteredAnnotations.stream().collect(Collectors.toMap(Function.identity(), a -> true));
        return newAnnotationVisibility;
    }

    private void annotationVisibilityChanged(AbstractAnnotation annotation, boolean visible) {
        this.notifyAnnotationsVisibilityListeners(this.abstractAnnotationTable.getAnnotationVisibilityMap().entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toSet()));
    }

    private void notifyAnnotationsVisibilityListeners(Set<AbstractAnnotation> newVisibleAnnotations) {
        this.annotationsVisibilitylisteners.forEach(l -> l.annotationsVisibiliyChanged(newVisibleAnnotations));
    }

    public void setTargetImage(Image image) {
        this.annotationFilteringPanel.setTargetImage(image);
        this.abstractAnnotationActionPanel.setAvailableTerms(this.getImageAvailableTerms(image));
    }

    private Collection<Term> getImageAvailableTerms(Image image) {
        try {
            return image.getProject().getOntology().getTerms(false);
        }
        catch (CytomineClientException e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    public void setTargetAnnotations(Map<AbstractAnnotation, Boolean> targetAnnotationVisibilities) {
        this.abstractAnnotationTable.setAnnotationVisibility(targetAnnotationVisibilities);
        this.annotationFilteringPanel.setTargetAnnotations(new HashSet<AbstractAnnotation>(targetAnnotationVisibilities.keySet()));
    }

    public void addTargetAnnotations(Map<AbstractAnnotation, Boolean> annotationVisibilitiesToAdd) {
        HashMap<AbstractAnnotation, Boolean> visibilities = new HashMap<AbstractAnnotation, Boolean>(this.abstractAnnotationTable.getAnnotationVisibilityMap());
        annotationVisibilitiesToAdd.entrySet().stream().forEach(e -> visibilities.put((AbstractAnnotation)e.getKey(), (Boolean)e.getValue()));
        this.abstractAnnotationTable.setAnnotationVisibility(visibilities);
        this.annotationFilteringPanel.setTargetAnnotations(new HashSet<AbstractAnnotation>(visibilities.keySet()));
    }

    public void removeTargetAnnotations(Set<AbstractAnnotation> annotationToRemove) {
        HashMap<AbstractAnnotation, Boolean> visibilities = new HashMap<AbstractAnnotation, Boolean>(this.abstractAnnotationTable.getAnnotationVisibilityMap());
        annotationToRemove.stream().forEach(a -> visibilities.remove(a));
        this.abstractAnnotationTable.setAnnotationVisibility(visibilities);
        this.annotationFilteringPanel.setTargetAnnotations(new HashSet<AbstractAnnotation>(visibilities.keySet()));
    }

    public void setLayers(List<AnnotationLayer> layers) {
        this.annotationLayerSelector.setLayers((AnnotationLayer[])layers.stream().toArray(AnnotationLayer[]::new), l -> l.getName());
    }

    public void setVisibleAnnotations(Set<AbstractAnnotation> visibleAnnotations) {
        HashMap<AbstractAnnotation, Boolean> visibilityMap = new HashMap<AbstractAnnotation, Boolean>(this.abstractAnnotationTable.getAnnotationVisibilityMap());
        visibilityMap.entrySet().forEach(e -> {
            if (visibleAnnotations.contains(e.getKey())) {
                e.setValue(true);
            } else {
                e.setValue(false);
            }
        });
        this.abstractAnnotationTable.setAnnotationVisibility(visibilityMap);
    }

    public void setSelectedAnnotations(Set<AbstractAnnotation> selectedAnnotations) {
        this.abstractAnnotationTable.setSelectedAnnotations(selectedAnnotations);
    }

    public void addAnnotationLayersVisibilityListener(AnnotationLayerVisibilityListener listener) {
        this.annotationLayersVisibilityListeners.add(listener);
    }

    public void removeAnnotationLayersVisibilityListener(AnnotationLayerVisibilityListener listener) {
        this.annotationLayersVisibilityListeners.remove(listener);
    }

    public void addAnnotationsVisibilityListener(AnnotationsVisibilityListener listener) {
        this.annotationsVisibilitylisteners.add(listener);
    }

    public void removeAnnotationsVisibilityListener(AnnotationsVisibilityListener listener) {
        this.annotationsVisibilitylisteners.remove(listener);
    }

    public void addAnnotationTermSelectionCommitListener(AnnotationTermCommitListener listener) {
        this.annotationTermSelectionCommitListeners.add(listener);
    }

    public void removeAnnotationTermSelectionCommitListener(AnnotationTermCommitListener listener) {
        this.annotationTermSelectionCommitListeners.remove(listener);
    }

    public void addAnnotationDeletionListener(AnnotationDeletionListener listener) {
        this.annotationDeletionListeners.add(listener);
    }

    public void removeAnnotationDeletionListener(AnnotationDeletionListener listener) {
        this.annotationDeletionListeners.remove(listener);
    }

    public void addAnnotationSelectionListener(AbstractAnnotationTable.AnnotationSelectionListener selectionListener) {
        this.abstractAnnotationTable.addAnnotationSelectionListener(selectionListener);
    }

    public void removeAnnotationSelectionListener(AbstractAnnotationTable.AnnotationSelectionListener selectionListener) {
        this.abstractAnnotationTable.removeAnnotationSelectionListener(selectionListener);
    }

    public void addAnnotationDoubleClickListener(AbstractAnnotationTable.AnnotationDoubleClickListener listener) {
        this.abstractAnnotationTable.addAnnotationDoubleClickListener(listener);
    }

    public void removeAnnotationDoubleClickListener(AbstractAnnotationTable.AnnotationDoubleClickListener listener) {
        this.abstractAnnotationTable.removeAnnotationDoubleClickListener(listener);
    }

    private void onAnnotationTermChangeRequested(Set<Term> selectedTerms) {
        Set<AbstractAnnotation> selectedAnnotations = this.abstractAnnotationTable.getSelectedAnnotations();
        Set<Term> terms = this.abstractAnnotationActionPanel.getAvailableTerms();
        Map termAssociation = terms.stream().collect(Collectors.toMap(Function.identity(), a -> selectedTerms.contains(a)));
        selectedAnnotations.forEach(a -> a.associateTerms(termAssociation));
        this.annotationTermSelectionCommitListeners.forEach(l -> l.annotationTermCommited(selectedAnnotations));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onAnnotationDeletionRequested(ActionEvent event) {
        Set<AbstractAnnotation> selectedAnnotations = this.abstractAnnotationTable.getSelectedAnnotations();
        if (selectedAnnotations.isEmpty()) {
            MessageDialog.showDialog((String)"Deleting annotations - Icytomine", (String)"No annotations selected", (int)2);
            return;
        }
        boolean confirmation = ConfirmDialog.confirm((String)"Deleting annotations - Icytomine", (String)"Are you sure to delete the annotations?", (int)0);
        if (confirmation) {
            AbstractAnnotation anAnnotation = selectedAnnotations.iterator().next();
            Image image = anAnnotation.getImage();
            try {
                image.removeAbstractAnnotations(selectedAnnotations);
                System.out.format("Erased %s annotations\n", selectedAnnotations.size());
            }
            catch (CytomineClientException e) {
                e.printStackTrace();
                MessageDialog.showDialog((String)"Deleting annotations - Icytomine", (String)"Could not remove annotations.", (int)0);
                return;
            }
            finally {
                this.notifyAnnotationDeletion(selectedAnnotations);
            }
        }
    }

    private void notifyAnnotationDeletion(Set<AbstractAnnotation> selectedAnnotations) {
        this.annotationDeletionListeners.forEach(listener -> listener.annotationsDeleted(selectedAnnotations));
    }

    public static interface AnnotationDeletionListener {
        public void annotationsDeleted(Set<AbstractAnnotation> var1);
    }

    public static interface AnnotationTermCommitListener {
        public void annotationTermCommited(Set<AbstractAnnotation> var1);
    }

    public static interface AnnotationsVisibilityListener {
        public void annotationsVisibiliyChanged(Set<AbstractAnnotation> var1);
    }

    public static interface AnnotationLayerVisibilityListener {
        public void annotationLayerVisibilityChanged(Map<AnnotationLayer, Boolean> var1);
    }
}

