/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.icy2Cytomine.file;

import be.cytomine.client.CytomineException;
import icy.common.listener.ProgressListener;
import icy.file.Loader;
import icy.gui.dialog.MessageDialog;
import icy.gui.dialog.OpenDialog;
import icy.sequence.Sequence;
import java.awt.EventQueue;
import java.awt.event.ActionListener;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.bioimageanalysis.icy.icytomine.core.image.annotation.RoiAnnotationSender;
import org.bioimageanalysis.icy.icytomine.core.model.AbstractAnnotation;
import org.bioimageanalysis.icy.icytomine.core.model.UserAnnotation;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.components.panel.icy2Cytomine.file.IcyFileToCytominePanel;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.controller.view.ViewController;

public class IcyFileToCytominePanelController {
    private IcyFileToCytominePanel panel;
    private ViewController viewController;
    private Path selectedFilePath;
    private ExecutorService transferService;
    private Set<ActionListener> closeListeners;

    public IcyFileToCytominePanelController(IcyFileToCytominePanel icyFileToCytominePanel, ViewController viewController) {
        this.panel = icyFileToCytominePanel;
        this.viewController = viewController;
        this.closeListeners = new HashSet<ActionListener>();
        this.setHandlers();
        this.setDisplayInformation();
    }

    private void setHandlers() {
        this.panel.getSelectFileButton().addActionListener(this.getSelectFileButtonHandler());
        this.panel.getSendButton().addActionListener(this.getSendButtonHandler());
        this.panel.getCancelButton().addActionListener(this.getCancelButtonHandler());
    }

    private ActionListener getSelectFileButtonHandler() {
        return event -> {
            String selectedFilePathText = OpenDialog.chooseFile();
            if (selectedFilePathText != null) {
                this.selectedFilePath = Paths.get(selectedFilePathText, new String[0]);
                this.panel.getFilePathLabel().setText(this.selectedFilePath.toString());
            } else {
                this.selectedFilePath = null;
                this.panel.getFilePathLabel().setText("No file selected");
            }
        };
    }

    private ActionListener getSendButtonHandler() {
        return event -> {
            if (this.selectedFilePath == null) {
                MessageDialog.showDialog((String)"Send annotations to cytomine", (String)"No file selected", (int)0);
            } else {
                Sequence loadedSequence = Loader.loadSequence((String)this.selectedFilePath.toString(), (int)0, (boolean)true);
                this.sendAnnotations(loadedSequence);
            }
        };
    }

    private synchronized void sendAnnotations(Sequence sequence) {
        if (sequence == null) {
            MessageDialog.showDialog((String)"Send annotations to Cytomine", (String)"No sequence selected", (int)0);
        } else {
            this.panel.getSendButton().setEnabled(false);
            this.transferService = Executors.newSingleThreadExecutor();
            this.transferService.submit(this.getTransferHandler(sequence));
            this.transferService.shutdown();
        }
    }

    private Runnable getTransferHandler(Sequence sequence) {
        return () -> {
            try {
                RoiAnnotationSender sender = new RoiAnnotationSender(this.viewController.getImageInformation(), sequence, false);
                sender.addProgressListener(this.getProgressUpdateHandler());
                List<UserAnnotation> createdAnnotations = sender.send();
                this.updateViewerAnnotations(new HashSet<UserAnnotation>(createdAnnotations));
                this.notifyCloseListener();
            }
            catch (Exception e) {
                this.notifyFailure(e);
            }
            finally {
                this.panel.getSendButton().setEnabled(true);
            }
        };
    }

    private ProgressListener getProgressUpdateHandler() {
        return (pos, len) -> {
            this.setProgress(pos / len);
            return true;
        };
    }

    private void setProgress(double progress) {
        EventQueue.invokeLater(() -> this.panel.getTransferProgressBar().setValue((int)(progress * 100.0)));
    }

    private void updateViewerAnnotations(Set<? extends AbstractAnnotation> createdAnnotations) {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.setProgress(0.0);
        try {
            this.viewController.getViewProvider().addTargetAbstractAnnotations(createdAnnotations);
            this.viewController.refreshView();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        MessageDialog.showDialog((String)"Send annotations to Cytomine", (String)String.format("Transfer complete: %d annotations sent", createdAnnotations.size()), (int)1);
    }

    private void notifyFailure(Exception e) {
        if (e instanceof CytomineException) {
            MessageDialog.showDialog((String)"Send annotations to Cytomine", (String)((CytomineException)e).getMsg(), (int)0);
        } else {
            MessageDialog.showDialog((String)"Send annotations to Cytomine", (String)e.getMessage(), (int)0);
        }
        e.printStackTrace();
    }

    private ActionListener getCancelButtonHandler() {
        return event -> {
            try {
                this.cancelPreviousRequest();
            }
            catch (InterruptedException | RuntimeException e) {
                e.printStackTrace();
            }
            this.notifyCloseListener();
        };
    }

    private void cancelPreviousRequest() throws InterruptedException, RuntimeException {
        if (this.transferService != null) {
            ExecutorService t = this.transferService;
            this.transferService = null;
            t.shutdownNow();
            if (!t.awaitTermination(5L, TimeUnit.SECONDS)) {
                throw new RuntimeException("Could not stop transfer service");
            }
        }
    }

    private void notifyCloseListener() {
        this.closeListeners.forEach(l -> l.actionPerformed(null));
    }

    private void setDisplayInformation() {
    }

    public void addCloseListener(ActionListener listener) {
        this.closeListeners.add(listener);
    }

    public void close() {
        try {
            this.cancelPreviousRequest();
        }
        catch (Exception e) {
            e.printStackTrace();
            MessageDialog.showDialog((String)"Error on closing dialog - Icytomine", (String)e.getMessage(), (int)0);
        }
    }
}

