/*
 * Decompiled with CFR 0.152.
 */
package org.bioimageanalysis.icy.icytomine.ui.core.viewer.controller.view.provider;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.HashSet;
import java.util.Set;
import org.bioimageanalysis.icy.icytomine.core.model.AbstractAnnotation;
import org.bioimageanalysis.icy.icytomine.core.model.Image;
import org.bioimageanalysis.icy.icytomine.core.view.CachedAbstractAnnotationView;
import org.bioimageanalysis.icy.icytomine.core.view.CachedImageView;
import org.bioimageanalysis.icy.icytomine.core.view.ViewListener;
import org.bioimageanalysis.icy.icytomine.ui.core.viewer.controller.view.provider.ViewProvider;

public class CachedViewProvider
extends ViewProvider {
    private CachedImageView cachedView;
    private CachedAbstractAnnotationView annotationView;
    private Set<ViewListener> viewListeners;
    private BufferedImage currentImageView;
    private BufferedImage currentAnnotationView;

    public CachedViewProvider(CachedImageView cachedView, CachedAbstractAnnotationView annotationView) {
        this.cachedView = cachedView;
        this.annotationView = annotationView;
        this.viewListeners = new HashSet<ViewListener>();
        this.cachedView.addViewListener(newViews -> this.imageLayerUpdated(newViews));
        this.annotationView.addViewListener(newViews -> this.annotationLayerUpdated(newViews));
    }

    @Override
    public void addViewListener(ViewListener listener) {
        this.viewListeners.add(listener);
    }

    @Override
    public void addViewProcessListener(ViewProvider.ViewProcessListener listener) {
        this.cachedView.addViewProcessListener(listener);
    }

    @Override
    public synchronized BufferedImage getView(Dimension canvasSize) {
        if (canvasSize.width == 0 || canvasSize.height == 0) {
            return new BufferedImage(10, 10, 2);
        }
        return this.buildView(canvasSize);
    }

    private BufferedImage buildView(Dimension canvasSize) {
        this.currentImageView = this.cachedView.getView(this.getPosition(), canvasSize, this.getResolution());
        this.currentAnnotationView = this.annotationView.getView(this.getPosition(), canvasSize, this.getResolution());
        return this.currentImageView;
    }

    @Override
    public Image getImageInformation() {
        return this.cachedView.getImageInformation();
    }

    @Override
    public void stop() {
        this.cachedView.stop();
        this.annotationView.stop();
    }

    private void imageLayerUpdated(BufferedImage[] newViews) {
        this.currentImageView = newViews[0];
        this.notifyViewListeners();
    }

    private void annotationLayerUpdated(BufferedImage[] newViews) {
        this.currentAnnotationView = newViews[0];
        this.notifyViewListeners();
    }

    private void notifyViewListeners() {
        this.viewListeners.forEach(l -> l.onViewChanged(this.currentImageView, this.currentAnnotationView));
    }

    @Override
    public void setTargetAbstractAnnotaions(Set<? extends AbstractAnnotation> newTargetAnnotations) {
        this.annotationView.setTargetAnnotations(newTargetAnnotations);
        this.annotationView.forceViewRefresh();
    }

    @Override
    public void addTargetAbstractAnnotations(Set<? extends AbstractAnnotation> annotationsToAdd) {
        this.annotationView.addTargetAnnotations(annotationsToAdd);
    }

    @Override
    public void removeTargetAbstractAnnotations(Set<? extends AbstractAnnotation> annotationsToRemove) {
        this.annotationView.removeTargetAnnotations(annotationsToRemove);
    }

    @Override
    public Set<AbstractAnnotation> getTargetAbstractAnnotations() {
        return this.annotationView.getTargetAnnotations();
    }

    @Override
    public void setVisibleAbstractAnnotations(Set<? extends AbstractAnnotation> newVisibleAnnotations) {
        this.annotationView.setVisibleAnnotations(newVisibleAnnotations);
        this.annotationView.forceViewRefresh();
    }

    @Override
    public void addVisibleAbstractAnnotations(Set<? extends AbstractAnnotation> annotationsToAdd) {
        this.annotationView.addVisibleAnnotations(annotationsToAdd);
    }

    @Override
    public void removeVisibleAbstractAnnotations(Set<? extends AbstractAnnotation> annotationsToRemove) {
        this.annotationView.removeVisibleAnnotations(annotationsToRemove);
    }

    @Override
    public Set<AbstractAnnotation> getVisibleAbstractAnnotations() {
        return this.annotationView.getVisibleAnnotations();
    }

    @Override
    public Set<AbstractAnnotation> getActiveAbstractAnnotations() {
        return this.annotationView.getActiveAnnotations();
    }

    @Override
    public void setSelectedAbstractAnnotations(Set<? extends AbstractAnnotation> annotations) {
        this.annotationView.setSelectedAnnotations(annotations);
    }

    @Override
    public Set<AbstractAnnotation> getSelectedAbstractAnnotations() {
        return this.annotationView.getSelectedAnnotations();
    }
}

