/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import javax.swing.JComponent;

public class ArrowButton
extends JComponent {
    public static final ArrowType UP = ArrowType.UP;
    public static final ArrowType DOWN = ArrowType.DOWN;
    public static final ArrowType LEFT = ArrowType.LEFT;
    public static final ArrowType RIGHT = ArrowType.RIGHT;
    public static final ArrowType DOUBLE_LEFT = ArrowType.DOUBLE_LEFT;
    public static final ArrowType DOUBLE_RIGHT = ArrowType.DOUBLE_RIGHT;
    public static final ArrowType DOUBLE_DOWN = ArrowType.DOUBLE_DOWN;
    public static final ArrowType DOUBLE_UP = ArrowType.DOUBLE_UP;
    public static final ArrowType FIRST = ArrowType.FIRST;
    public static final ArrowType LAST = ArrowType.LAST;
    private static final long serialVersionUID = -7741558416297551179L;
    private int arrowScale;
    private Dimension preferredSize;
    private GeneralPath gp;
    private Color disabledForeground;
    private Color mouseOverForeground;
    private ArrowType arrowType;
    private boolean mouseOver;

    public ArrowButton() {
        this(null, 12);
    }

    public ArrowButton(int arrowScale) {
        this(null, arrowScale);
    }

    public ArrowButton(ArrowType type) {
        this(type, 12);
    }

    public ArrowButton(ArrowType type, int arrowScale) {
        this.arrowScale = Math.max(5, arrowScale);
        this.setArrowType(type);
        this.disabledForeground = Color.LIGHT_GRAY;
        this.mouseOverForeground = new Color(90, 90, 90);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ArrowButton.this.mouseOver = true;
                ArrowButton.this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ArrowButton.this.mouseOver = false;
                ArrowButton.this.repaint();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                ArrowButton.this.doClick();
            }
        });
    }

    public void doClick() {
        if (this.isEnabled()) {
            this.fireActionPerformed();
        }
    }

    public int getArrowScale() {
        return this.arrowScale;
    }

    public ArrowType getArrowType() {
        return this.arrowType;
    }

    private int getShiftScale() {
        return 2 * this.getArrowScale() / 3;
    }

    public void setArrowType(ArrowType arrowType) {
        if (arrowType == null) {
            arrowType = ArrowType.DOUBLE_LEFT;
        }
        this.arrowType = arrowType;
        this.gp = new GeneralPath();
        if (arrowType.equals((Object)ArrowType.DOUBLE_LEFT)) {
            for (int x = 0; x < this.getArrowScale(); x += this.getShiftScale()) {
                this.gp.moveTo(x, this.getArrowScale() / 2);
                this.gp.lineTo(x + this.getArrowScale(), this.getArrowScale());
                this.gp.lineTo(x + this.getArrowScale(), 0.0f);
                this.gp.lineTo(x, this.getArrowScale() / 2);
            }
        } else if (arrowType.equals((Object)ArrowType.LEFT)) {
            this.gp.moveTo(0.0f, this.getArrowScale() / 2);
            this.gp.lineTo(this.getArrowScale(), this.getArrowScale());
            this.gp.lineTo(this.getArrowScale(), 0.0f);
        } else if (arrowType.equals((Object)ArrowType.FIRST)) {
            float x = this.getArrowScale() / 4;
            this.gp.moveTo(0.0f, 0.0f);
            this.gp.lineTo(x, 0.0f);
            this.gp.lineTo(x, this.getArrowScale());
            this.gp.lineTo(0.0f, this.getArrowScale());
            this.gp.lineTo(0.0f, 0.0f);
            this.gp.moveTo(x, this.getArrowScale() / 2);
            this.gp.lineTo(x + (float)this.getArrowScale(), this.getArrowScale());
            this.gp.lineTo(x + (float)this.getArrowScale(), 0.0f);
        } else if (arrowType.equals((Object)ArrowType.RIGHT)) {
            this.gp.moveTo(0.0f, 0.0f);
            this.gp.lineTo(0.0f, this.getArrowScale());
            this.gp.lineTo(this.getArrowScale(), this.getArrowScale() / 2);
        } else if (arrowType.equals((Object)ArrowType.LAST)) {
            this.gp.moveTo(0.0f, 0.0f);
            this.gp.lineTo(0.0f, this.getArrowScale());
            this.gp.lineTo(this.getArrowScale(), this.getArrowScale() / 2);
            this.gp.lineTo(0.0f, 0.0f);
            this.gp.moveTo(this.getArrowScale(), 0.0f);
            this.gp.lineTo(this.getArrowScale() + this.getArrowScale() / 4, 0.0f);
            this.gp.lineTo(this.getArrowScale() + this.getArrowScale() / 4, this.getArrowScale());
            this.gp.lineTo(this.getArrowScale(), this.getArrowScale());
            this.gp.lineTo(this.getArrowScale(), 0.0f);
        } else if (arrowType.equals((Object)ArrowType.DOUBLE_RIGHT)) {
            for (int x = 0; x < this.getArrowScale(); x += this.getShiftScale()) {
                this.gp.moveTo(x, 0.0f);
                this.gp.lineTo(x, this.getArrowScale());
                this.gp.lineTo(x + this.getArrowScale(), this.getArrowScale() / 2);
                this.gp.lineTo(x, 0.0f);
            }
        } else if (arrowType.equals((Object)ArrowType.UP)) {
            this.gp.moveTo(this.getArrowScale() / 2, 0.0f);
            this.gp.lineTo(this.getArrowScale(), this.getArrowScale());
            this.gp.lineTo(0.0f, this.getArrowScale());
        } else if (arrowType.equals((Object)ArrowType.DOUBLE_UP)) {
            for (int y = 0; y < this.getArrowScale(); y += this.getShiftScale()) {
                this.gp.moveTo(this.getArrowScale() / 2, y);
                this.gp.lineTo(this.getArrowScale(), y + this.getArrowScale());
                this.gp.lineTo(0.0f, y + this.getArrowScale());
            }
        } else if (arrowType.equals((Object)ArrowType.DOUBLE_DOWN)) {
            for (int y = 0; y < this.getArrowScale(); y += this.getShiftScale()) {
                this.gp.moveTo(0.0f, y);
                this.gp.lineTo(this.getArrowScale(), y);
                this.gp.lineTo(this.getArrowScale() / 2, y + this.getArrowScale());
            }
        } else if (arrowType.equals((Object)ArrowType.DOWN)) {
            this.gp.moveTo(0.0f, 0.0f);
            this.gp.lineTo(this.getArrowScale(), 0.0f);
            this.gp.lineTo(this.getArrowScale() / 2, this.getArrowScale());
        }
        this.gp.closePath();
        Rectangle bounds = this.gp.getBounds();
        this.preferredSize = new Dimension(bounds.width, bounds.height);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (!this.isEnabled()) {
            g2d.setColor(this.getDisabledForeground());
        } else if (this.mouseOver) {
            g2d.setColor(this.getMouseOverForeground());
        } else {
            g2d.setColor(this.getForeground());
        }
        g2d.fill(this.gp);
    }

    public void setDisabledForeground(Color color) {
        if (color != null) {
            this.disabledForeground = color;
        }
    }

    public Color getMouseOverForeground() {
        return this.mouseOverForeground;
    }

    public void setMouseOverForeground(Color color) {
        if (color != null) {
            this.mouseOverForeground = color;
        }
    }

    public Color getDisabledForeground() {
        return this.disabledForeground;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    public void addActionListener(ActionListener listener) {
        if (listener != null) {
            this.listenerList.add(ActionListener.class, listener);
        }
    }

    public void removeActionListener(ActionListener listener) {
        if (listener != null) {
            this.listenerList.remove(ActionListener.class, listener);
        }
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.listenerList.getListeners(ActionListener.class);
    }

    protected void fireActionPerformed() {
        ActionListener[] listeners;
        ActionEvent event = new ActionEvent(this, 1001, "linkClicked", System.currentTimeMillis(), 0);
        for (ActionListener listener : listeners = (ActionListener[])this.listenerList.getListeners(ActionListener.class)) {
            listener.actionPerformed(event);
        }
    }

    public static enum ArrowType {
        DOUBLE_LEFT,
        LEFT,
        DOUBLE_RIGHT,
        RIGHT,
        UP,
        DOWN,
        DOUBLE_UP,
        DOUBLE_DOWN,
        FIRST,
        LAST;

    }
}

