/*
 * Decompiled with CFR 0.152.
 */
package plugins.danyfel80.cytomine.annotation;

import com.vividsolutions.jts.geom.Geometry;
import icy.plugin.abstract_.Plugin;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bioimageanalysis.icy.icytomine.core.connection.client.CytomineClient;
import org.bioimageanalysis.icy.icytomine.core.model.AbstractAnnotation;
import org.bioimageanalysis.icy.icytomine.core.model.Image;
import org.bioimageanalysis.icy.icytomine.core.model.Project;
import org.bioimageanalysis.icy.icytomine.core.model.Term;
import org.bioimageanalysis.icy.icytomine.core.model.User;
import org.bioimageanalysis.icy.icytomine.core.model.UserAnnotation;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarGenericArray;
import plugins.adufour.vars.lang.VarString;
import vars.cytomine.VarCytomineAbstractAnnotation;

public class GetCytomineUserAnnotationsInAnnotation
extends Plugin
implements Block {
    private VarCytomineAbstractAnnotation varInTargetAnnotation;
    private VarString varInUserNameFilter;
    private VarString varInTermNameFilter;
    private VarGenericArray<AbstractAnnotation[]> varOutAnnotations;
    private AbstractAnnotation targetAnnotation;
    private Set<String> usernames;
    private Set<String> termNames;
    Set<UserAnnotation> resultAnnotations;

    public void declareInput(VarList inputMap) {
        this.varInTargetAnnotation = VarCytomineAbstractAnnotation.ofNullable(null);
        this.varInUserNameFilter = new VarString("User names", "noUser");
        this.varInTermNameFilter = new VarString("Term name", "No Term");
        inputMap.add(this.varInTargetAnnotation.getName(), (Var)this.varInTargetAnnotation);
        inputMap.add(this.varInUserNameFilter.getName(), (Var)this.varInUserNameFilter);
        inputMap.add(this.varInTermNameFilter.getName(), (Var)this.varInTermNameFilter);
    }

    public void declareOutput(VarList outputMap) {
        this.varOutAnnotations = new VarGenericArray("Annotations", AbstractAnnotation[].class, (Object)new AbstractAnnotation[0]);
        outputMap.add(this.varOutAnnotations.getName(), this.varOutAnnotations);
    }

    public void run() {
        this.readParameters();
        this.computeAnnotations();
        this.setOutputValues();
    }

    private void readParameters() {
        this.targetAnnotation = (AbstractAnnotation)this.varInTargetAnnotation.getValue(true);
        this.usernames = Arrays.stream(((String)this.varInUserNameFilter.getValue(true)).toLowerCase().split(" *, *")).filter(u -> !u.isEmpty()).distinct().collect(Collectors.toSet());
        this.termNames = Arrays.stream(((String)this.varInTermNameFilter.getValue(true)).split(" *, *")).filter(t -> !t.isEmpty()).distinct().map(String::toLowerCase).collect(Collectors.toSet());
    }

    private void computeAnnotations() {
        Long taId = this.targetAnnotation.getId();
        Image taImage = this.targetAnnotation.getImage();
        Long taImageId = taImage.getId();
        Project taImageProject = taImage.getProject();
        CytomineClient taClient = this.targetAnnotation.getClient();
        Rectangle2D taBounds = this.targetAnnotation.getBounds();
        List<User> users = taImageProject.getUsers(false);
        Set<Term> terms = taImageProject.getOntology().getTerms(false);
        Geometry taGeometry = this.targetAnnotation.getGeometryAtZeroResolution(false);
        Set<Long> targetUserIds = users.stream().filter(u -> this.usernames.contains(u.getName().orElse("").toLowerCase())).map(u -> u.getId()).collect(Collectors.toSet());
        Set targetTerms = terms.stream().filter(t -> this.termNames.contains(t.getName().orElse("").toLowerCase())).collect(Collectors.toSet());
        boolean containsNoTerm = this.termNames.contains("No Term");
        Map<Long, UserAnnotation> foundAnnotations = targetUserIds.isEmpty() ? taClient.getImageUserAnnotationsAt(taImageId, taBounds) : taClient.getImageUserAnnotationsAt(taImageId, targetUserIds, taBounds);
        Map<Long, UserAnnotation> foundGeometries = targetUserIds.isEmpty() ? taClient.getImageUserAnnotationGeometries(taImage, taBounds) : taClient.getImageUserAnnotationGeometries(taImage, targetUserIds, taBounds);
        this.resultAnnotations = new HashSet<UserAnnotation>();
        int i = 0;
        for (UserAnnotation annot : foundAnnotations.values()) {
            Long id = annot.getId();
            if (!id.equals(taId)) {
                boolean accepted;
                Set<Term> annotTerms = annot.getAssociatedTerms();
                boolean bl = accepted = this.termNames.isEmpty() || annotTerms.isEmpty() && containsNoTerm;
                if (!accepted) {
                    for (Term annotTerm : annotTerms) {
                        if (!targetTerms.contains(annotTerm)) continue;
                        accepted = true;
                        break;
                    }
                }
                if (accepted) {
                    UserAnnotation geometry = foundGeometries.get(id);
                    if (geometry != null) {
                        annot.getInternalAnnotation().set("location", geometry.getInternalAnnotation().getStr("location"));
                    }
                    if (taGeometry.intersects(annot.getGeometryAtZeroResolution(false))) {
                        this.resultAnnotations.add(annot);
                    }
                }
            }
            ++i;
        }
    }

    private void setOutputValues() {
        this.varOutAnnotations.setValue((Object)((AbstractAnnotation[])this.resultAnnotations.stream().toArray(AbstractAnnotation[]::new)));
    }
}

