/*
 * Decompiled with CFR 0.152.
 */
package plugins.atournay.jep.ui;

import icy.gui.component.IcyTextField;
import icy.gui.dialog.MessageDialog;
import icy.gui.frame.IcyFrame;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import plugins.atournay.jep.prefs.JepPreferences;
import plugins.atournay.jep.utils.JepUtils;
import plugins.atournay.jep.utils.PythonUtils;

public class JepPreferencesWindow
extends IcyFrame
implements ActionListener {
    IcyFrame frame = IcyFrame.findIcyFrame((JInternalFrame)this.getInternalFrame());
    private JButton customPythonBrowseButton;
    private JButton applyButton;
    private JButton saveButton;
    private JButton cancelButton;
    private JComboBox<String> condaEnvCombo;
    private JRadioButton condaRadioButton;
    private JRadioButton customPythonRadioButton;
    private IcyTextField customPythonPathText;
    private Set<String> condaEnvList;

    public JepPreferencesWindow() {
        super("JEP configuration", true, true, true, true);
        this.initialize();
        this.condaRadioButton.addActionListener(this);
        this.customPythonRadioButton.addActionListener(this);
        this.customPythonBrowseButton.addActionListener(this);
        this.applyButton.addActionListener(this);
        this.saveButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.validate();
        this.load();
    }

    private void initialize() {
        JPanel mainPanel = new JPanel(this.createGridLayout());
        mainPanel.setLayout(this.createGridLayout());
        this.condaEnvList = PythonUtils.getInstance().getCondaEnvNames();
        GridBagConstraints condaCons = this.createConstraints(0, 2, 2.0, 23, new int[]{15, 0, 8, 5});
        this.condaRadioButton = this.createRadioButton("Use a Conda (Anaconda, Miniconda, Mamba, etc...) environment");
        mainPanel.add((Component)this.condaRadioButton, condaCons);
        if (this.condaEnvList != null) {
            this.condaEnvCombo = this.createComboBox(this.condaEnvList.toArray(new String[0]));
        } else {
            this.condaRadioButton.setEnabled(false);
            this.condaEnvCombo = this.createComboBox(new String[0]);
        }
        this.condaEnvCombo.setEnabled(false);
        condaCons.gridx = 2;
        condaCons.weightx = 0.0;
        condaCons.gridwidth = 1;
        condaCons.fill = 0;
        condaCons.insets = new Insets(15, 0, 0, 0);
        mainPanel.add(this.condaEnvCombo, condaCons);
        this.customPythonRadioButton = this.createRadioButton("Set manually the path to the Python home directory");
        mainPanel.add((Component)this.customPythonRadioButton, this.createConstraints(1, 1, 1.0, 23, new int[]{0, 0, 8, 0}));
        GridBagConstraints customPythonConstraints = this.createConstraints(2, 2, 2.0, 23, new int[]{0, 0, 0, 5});
        this.customPythonPathText = this.createTextInput();
        this.customPythonPathText.setEnabled(false);
        mainPanel.add((Component)this.customPythonPathText, customPythonConstraints);
        this.customPythonBrowseButton = this.createButton("Browse");
        this.customPythonBrowseButton.setEnabled(false);
        customPythonConstraints.gridx = 2;
        customPythonConstraints.gridwidth = 1;
        customPythonConstraints.weightx = 1.0;
        customPythonConstraints.weighty = 1.0;
        customPythonConstraints.fill = 0;
        mainPanel.add((Component)this.customPythonBrowseButton, customPythonConstraints);
        ButtonGroup radioGroup = this.createRadioGroup();
        radioGroup.add(this.condaRadioButton);
        radioGroup.add(this.customPythonRadioButton);
        if (this.condaEnvList == null) {
            JLabel condaNotInstalled = new JLabel("Conda is currently not installed");
            condaNotInstalled.setFont(new Font(condaNotInstalled.getFont().getName(), 2, condaNotInstalled.getFont().getSize()));
            mainPanel.add((Component)condaNotInstalled, this.createConstraints(3, 2, 1.0, 10, new int[]{0, 0, 0, 0}));
        }
        Box buttonsBox = Box.createHorizontalBox();
        GridBagConstraints buttonsConstraints = this.createConstraints(this.condaEnvList != null ? 3 : 4, 1, 0.0, 26, new int[]{0, 5, 5, 5});
        buttonsConstraints.fill = 0;
        this.applyButton = this.createButton("Apply");
        buttonsBox.add(this.applyButton);
        buttonsBox.add(Box.createHorizontalStrut(5));
        this.saveButton = this.createButton("Ok");
        ++buttonsConstraints.gridx;
        buttonsBox.add(this.saveButton);
        buttonsBox.add(Box.createHorizontalStrut(5));
        this.cancelButton = this.createButton("Cancel");
        ++buttonsConstraints.gridx;
        buttonsBox.add(this.cancelButton);
        mainPanel.add((Component)buttonsBox, buttonsConstraints);
        this.setContentPane(mainPanel);
    }

    private void load() {
        String pythonHomePath = JepPreferences.getInstance().getPythonRoot();
        if (!pythonHomePath.isEmpty()) {
            if (pythonHomePath.contains("conda")) {
                this.condaRadioButton.setSelected(true);
                this.condaEnvCombo.setEnabled(true);
                for (String envName : PythonUtils.getInstance().getCondaEnvNames()) {
                    Pattern pattern = Pattern.compile(envName);
                    Matcher matcher = pattern.matcher(pythonHomePath);
                    if (!matcher.find()) continue;
                    this.condaEnvCombo.setSelectedItem(envName);
                }
            } else {
                this.customPythonRadioButton.setSelected(true);
                this.customPythonPathText.setEnabled(true);
                this.customPythonPathText.setText(pythonHomePath);
                this.customPythonBrowseButton.setEnabled(true);
            }
        }
    }

    private boolean apply() {
        String jepPath;
        String pythonExecutablePath;
        String pythonHomePath = "";
        if (this.condaRadioButton.isSelected()) {
            pythonHomePath = PythonUtils.getInstance().detectCondaEnvironments().get((String)this.condaEnvCombo.getSelectedItem());
        }
        if (this.customPythonRadioButton.isSelected()) {
            pythonHomePath = this.customPythonPathText.getText();
        }
        if ((pythonExecutablePath = PythonUtils.getInstance().findPythonExecutable(pythonHomePath, true)) != null) {
            JepPreferences.getInstance().setPythonRoot(pythonHomePath);
            JepPreferences.getInstance().setPythonExecPath(pythonExecutablePath);
            String sitePackageDirectory = PythonUtils.getInstance().setSitePackagesDirectory();
            jepPath = JepUtils.getInstance().findJepLib(sitePackageDirectory);
            if (jepPath == null) {
                PythonUtils.getInstance().installPythonPackage("wheel numpy jep");
                jepPath = JepUtils.getInstance().findJepLib(sitePackageDirectory);
            }
        } else {
            MessageDialog.showDialog((String)"Error while finding Python", (String)"Python could not be found. Please select an other directory.", (int)0);
            return false;
        }
        JepPreferences.getInstance().setJepPath(jepPath);
        MessageDialog.showDialog((String)"JEP configuration saved", (String)"JEP settings has been successfully saved", (int)1);
        return true;
    }

    private void save() {
        if (this.apply()) {
            this.frame.dispose();
        }
    }

    private void cancel() {
        this.frame.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.condaRadioButton)) {
            if (this.condaEnvList != null) {
                this.condaEnvCombo.setEnabled(this.condaRadioButton.isSelected());
            } else {
                this.condaEnvCombo.setEnabled(false);
            }
            this.customPythonPathText.setEnabled(false);
            this.customPythonBrowseButton.setEnabled(false);
        } else if (actionEvent.getSource().equals(this.customPythonRadioButton)) {
            if (this.customPythonRadioButton.isSelected()) {
                this.condaEnvCombo.setEnabled(false);
                this.customPythonPathText.setEnabled(true);
                this.customPythonBrowseButton.setEnabled(true);
            } else {
                this.condaEnvCombo.setEnabled(false);
                this.customPythonPathText.setEnabled(false);
                this.customPythonBrowseButton.setEnabled(false);
            }
        } else if (actionEvent.getSource().equals(this.customPythonBrowseButton)) {
            this.createDirectorySelection();
        } else if (actionEvent.getSource().equals(this.applyButton)) {
            this.apply();
        } else if (actionEvent.getSource().equals(this.saveButton)) {
            this.save();
        } else if (actionEvent.getSource().equals(this.cancelButton)) {
            this.cancel();
        }
    }

    private GridBagLayout createGridLayout() {
        return new GridBagLayout();
    }

    private GridBagConstraints createConstraints(int y, int width, double weightX, int anchor, int[] insets) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = y;
        constraints.gridwidth = width;
        constraints.gridheight = 1;
        constraints.fill = 2;
        constraints.anchor = anchor;
        constraints.insets = new Insets(insets[0], insets[1], insets[2], insets[3]);
        constraints.weightx = weightX;
        constraints.weighty = 0.0;
        return constraints;
    }

    private ButtonGroup createRadioGroup() {
        return new ButtonGroup();
    }

    private JRadioButton createRadioButton(String text) {
        return new JRadioButton(text);
    }

    private JButton createButton(String text) {
        return new JButton(text);
    }

    private <T> JComboBox<T> createComboBox(T[] content) {
        return new JComboBox<T>(content);
    }

    private IcyTextField createTextInput() {
        return new IcyTextField((Object)"");
    }

    private void createDirectorySelection() {
        String pythonPathInput = this.customPythonPathText.getText();
        JFileChooser selectPythonDirectoryDiag = new JFileChooser();
        selectPythonDirectoryDiag.setFileSelectionMode(1);
        selectPythonDirectoryDiag.setAcceptAllFileFilterUsed(false);
        selectPythonDirectoryDiag.setDialogTitle("Set Python home directory");
        if (!pythonPathInput.isEmpty()) {
            Path pythonHomePath = Paths.get(pythonPathInput, new String[0]);
            boolean isDirectory = pythonHomePath.toFile().isDirectory();
            selectPythonDirectoryDiag.setCurrentDirectory(isDirectory ? pythonHomePath.toFile() : pythonHomePath.getParent().toFile());
        }
        if (selectPythonDirectoryDiag.showOpenDialog(this.customPythonBrowseButton) == 0) {
            this.customPythonPathText.setText(selectPythonDirectoryDiag.getSelectedFile().getAbsolutePath());
        }
    }
}

